/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.metamorph.functions;

import java.util.HashMap;
import java.util.Map;
import org.metafacture.commons.StringUtil;
import org.metafacture.metamorph.api.MorphBuildException;
import org.metafacture.metamorph.api.helpers.AbstractStatefulFunction;

public final class Occurrence
extends AbstractStatefulFunction {
    public static final String LESS_THAN = "lessThan ";
    public static final String MORE_THAN = "moreThan ";
    public static final boolean SAME_ENTITY = false;
    private int count;
    private String format;
    private IntFilter filter = new IntFilter(){

        @Override
        public boolean accept(int value) {
            return true;
        }
    };
    private final Map<String, String> variables = new HashMap<String, String>();
    private boolean sameEntity = false;

    public String process(String value) {
        ++this.count;
        if (this.filter.accept(this.count)) {
            return this.processMatch(value);
        }
        return null;
    }

    private String processMatch(String value) {
        if (this.format == null) {
            return value;
        }
        this.variables.put("value", value);
        this.variables.put("count", String.valueOf(this.count));
        return StringUtil.format((String)this.format, this.variables);
    }

    public void setFormat(String format) {
        this.format = format;
    }

    protected void reset() {
        this.count = 0;
    }

    protected boolean doResetOnEntityChange() {
        return this.sameEntity;
    }

    public void setOnly(String only) {
        this.filter = Occurrence.parse(only);
    }

    public void setSameEntity(boolean sameEntity) {
        this.sameEntity = sameEntity;
    }

    private static IntFilter parse(String only) {
        IntFilter filter;
        if (only.startsWith(LESS_THAN)) {
            filter = Occurrence.createLessThanFilter(Occurrence.extractNumberFrom(only));
        } else if (only.startsWith(MORE_THAN)) {
            filter = Occurrence.createGreaterThanFilter(Occurrence.extractNumberFrom(only));
        } else {
            int number = Integer.parseInt(only);
            filter = Occurrence.createEqualsFilter(number);
        }
        return filter;
    }

    private static int extractNumberFrom(String string) {
        String[] tokens = string.split(" ", 2);
        if (tokens.length < 2) {
            throw new MorphBuildException("Invalid only string: " + string);
        }
        return Integer.parseInt(tokens[1]);
    }

    private static IntFilter createEqualsFilter(final int number) {
        return new IntFilter(){

            @Override
            public boolean accept(int value) {
                return value == number;
            }
        };
    }

    private static IntFilter createLessThanFilter(final int number) {
        return new IntFilter(){

            @Override
            public boolean accept(int value) {
                return value < number;
            }
        };
    }

    private static IntFilter createGreaterThanFilter(final int number) {
        return new IntFilter(){

            @Override
            public boolean accept(int value) {
                return value > number;
            }
        };
    }

    private static interface IntFilter {
        public boolean accept(int var1);
    }
}

