/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.metamorph.functions;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import org.metafacture.metamorph.api.MorphBuildException;
import org.metafacture.metamorph.api.helpers.AbstractSimpleStatelessFunction;

public final class Timestamp
extends AbstractSimpleStatelessFunction {
    public static final String FORMAT_TIMESTAMP = "timestamp";
    public static final String DEFAULT_FORMAT = "timestamp";
    public static final String DEFAULT_TIMEZONE = "UTC";
    private static final int MS_PER_SECOND = 1000;
    private static final Set<String> SUPPORTED_LANGUAGES;
    private String format = "timestamp";
    private String timezone = "UTC";
    private Locale locale = Locale.getDefault();

    public String process(String value) {
        SimpleDateFormat dateFormat;
        if ("timestamp".equals(this.format)) {
            return Long.toString(System.currentTimeMillis() / 1000L);
        }
        try {
            dateFormat = new SimpleDateFormat(this.format, this.locale);
        }
        catch (IllegalArgumentException e) {
            throw new MorphBuildException("The date/time format '" + this.format + "' is not supported. ", (Throwable)e);
        }
        dateFormat.setTimeZone(TimeZone.getTimeZone(this.timezone));
        return dateFormat.format(new Date());
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public void setLanguage(String language) {
        if (!SUPPORTED_LANGUAGES.contains(language)) {
            throw new MorphBuildException("Language '" + language + "' not supported.");
        }
        this.locale = new Locale(language);
    }

    static {
        HashSet set = new HashSet();
        Collections.addAll(set, Locale.getISOLanguages());
        SUPPORTED_LANGUAGES = Collections.unmodifiableSet(set);
    }
}

