/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.metamorph.maps;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.metafacture.metamorph.api.helpers.AbstractReadOnlyMap;

public final class RestMap
extends AbstractReadOnlyMap<String, String> {
    public static final String CHARSET_NAME = "UTF-8";
    private static final Pattern VAR_PATTERN = Pattern.compile("${key}", 16);
    private String charsetName = "UTF-8";
    private String url;

    public RestMap() {
    }

    public RestMap(String url) {
        this.url = url;
    }

    public String get(Object key) {
        Matcher matcher = VAR_PATTERN.matcher(this.url);
        try {
            String urlString = matcher.replaceAll(key.toString());
            return this.readFromUrl(urlString);
        }
        catch (IOException | URISyntaxException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFromUrl(String targetUrl) throws IOException, URISyntaxException {
        try (InputStream inputStream = new URL(new URI(targetUrl.replace(" ", "%20")).toASCIIString()).openConnection().getInputStream();){
            int value;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, Charset.forName(this.charsetName)));
            StringBuilder stringBuffer = new StringBuilder();
            while ((value = reader.read()) != -1) {
                stringBuffer.append((char)value);
            }
            String string = stringBuffer.toString();
            return string;
        }
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setCharsetName(String name) {
        this.charsetName = name;
    }
}

