/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.metamorph.xml;

import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.metafacture.commons.ResourceUtil;
import org.metafacture.framework.MetafactureException;
import org.metafacture.metamorph.xml.CDataFilter;
import org.metafacture.metamorph.xml.CommentsFilter;
import org.metafacture.metamorph.xml.IgnorableWhitespaceFilter;
import org.metafacture.metamorph.xml.LocationAnnotator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public final class DomLoader {
    private static final ErrorHandler SAX_ERROR_HANDLER = new SaxErrorHandler();
    private static final ErrorListener TRANSFORMER_ERROR_HANDLER = new TransformerErrorHandler();

    private DomLoader() {
        throw new AssertionError((Object)"No instances allowed");
    }

    public static Document parse(String schemaFile, InputSource input) {
        Document document = DomLoader.createEmptyDocument();
        XMLReader pipeline = DomLoader.createXmlFilterPipeline(schemaFile, document);
        DomLoader.process(new SAXSource(pipeline, input), new DOMResult(document));
        DomLoader.removeEmptyTextNodes(document);
        return document;
    }

    private static Document createEmptyDocument() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new MetafactureException((Throwable)e);
        }
    }

    private static XMLReader createXmlFilterPipeline(String schemaFile, Document document) {
        XMLReader pipelineHead = DomLoader.createSaxReader(DomLoader.loadSchema(schemaFile));
        pipelineHead = new LocationAnnotator(pipelineHead, document);
        pipelineHead = new IgnorableWhitespaceFilter(pipelineHead);
        pipelineHead = new CommentsFilter(pipelineHead);
        pipelineHead = new CDataFilter(pipelineHead);
        pipelineHead.setErrorHandler(SAX_ERROR_HANDLER);
        return pipelineHead;
    }

    private static Schema loadSchema(String schemaFile) {
        try {
            return SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(DomLoader.getSchemaUrl(schemaFile));
        }
        catch (SAXException e) {
            throw new MetafactureException((Throwable)e);
        }
    }

    private static URL getSchemaUrl(String schemaFile) {
        try {
            return ResourceUtil.getUrl((String)schemaFile);
        }
        catch (MalformedURLException e) {
            throw new MetafactureException("'" + schemaFile + "' not found:", (Throwable)e);
        }
    }

    private static XMLReader createSaxReader(Schema schema) {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setSchema(schema);
        parserFactory.setNamespaceAware(true);
        parserFactory.setXIncludeAware(true);
        try {
            return parserFactory.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new MetafactureException((Throwable)e);
        }
    }

    private static void process(Source source, Result result) {
        Transformer transformer = DomLoader.createTransformer();
        try {
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new MetafactureException((Throwable)e);
        }
    }

    private static Transformer createTransformer() {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setErrorListener(TRANSFORMER_ERROR_HANDLER);
            return transformer;
        }
        catch (TransformerConfigurationException e) {
            throw new MetafactureException((Throwable)e);
        }
    }

    private static void removeEmptyTextNodes(Node node) {
        Node child = node.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 3) {
                Node old = child;
                child = child.getNextSibling();
                if (!old.getNodeValue().trim().isEmpty()) continue;
                node.removeChild(old);
                continue;
            }
            DomLoader.removeEmptyTextNodes(child);
            child = child.getNextSibling();
        }
    }

    private static class TransformerErrorHandler
    implements ErrorListener {
        TransformerErrorHandler() {
        }

        @Override
        public void warning(TransformerException exception) throws TransformerException {
            this.handle(exception);
        }

        @Override
        public void error(TransformerException exception) throws TransformerException {
            this.handle(exception);
        }

        @Override
        public void fatalError(TransformerException exception) throws TransformerException {
            this.handle(exception);
        }

        private void handle(TransformerException exception) {
            throw new MetafactureException("Error during DOM creation: " + exception.getMessage(), (Throwable)exception);
        }
    }

    private static class SaxErrorHandler
    implements ErrorHandler {
        SaxErrorHandler() {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            this.handle(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.handle(exception);
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.handle(exception);
        }

        private void handle(SAXParseException exception) {
            throw new MetafactureException("Error parsing xml: " + exception.getMessage(), (Throwable)exception);
        }
    }
}

