/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspectionresultprocessor.sort;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.metawidget.inspectionresultprocessor.iface.DomInspectionResultProcessor;
import org.metawidget.inspectionresultprocessor.iface.InspectionResultProcessorException;
import org.metawidget.util.ArrayUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComesAfterInspectionResultProcessor<M>
implements DomInspectionResultProcessor<Element, M> {
    @Override
    public String processInspectionResult(String inspectionResult, M metawidget) {
        Document document = XmlUtils.documentFromString(inspectionResult);
        Element inspectionResultRoot = document.getDocumentElement();
        Element newInspectionResultRoot = this.processInspectionResultAsDom(inspectionResultRoot, metawidget);
        return XmlUtils.documentToString(newInspectionResultRoot.getOwnerDocument(), false);
    }

    @Override
    public Element processInspectionResultAsDom(Element inspectionResultRoot, M metawidget) {
        try {
            Document newDocument = XmlUtils.newDocument();
            Element newInspectionResultRoot = newDocument.createElementNS("http://metawidget.org/inspection-result", "inspection-result");
            XmlUtils.setMapAsAttributes(newInspectionResultRoot, XmlUtils.getAttributesAsMap(inspectionResultRoot));
            newDocument.appendChild(newInspectionResultRoot);
            Element entity = XmlUtils.getElementAt(inspectionResultRoot, 0);
            Element newEntity = newDocument.createElementNS("http://metawidget.org/inspection-result", "entity");
            XmlUtils.setMapAsAttributes(newEntity, XmlUtils.getAttributesAsMap(entity));
            newInspectionResultRoot.appendChild(newEntity);
            LinkedHashMap<Element, String[]> traitsWithComesAfter = new LinkedHashMap<Element, String[]>();
            NodeList traits = entity.getChildNodes();
            int length = traits.getLength();
            for (int loop = 0; loop < length; ++loop) {
                Node node = traits.item(loop);
                if (!(node instanceof Element)) continue;
                Element trait = (Element)node;
                if (!this.hasComesAfter(trait, metawidget)) {
                    newEntity.appendChild(XmlUtils.importElement(newDocument, trait));
                    continue;
                }
                traitsWithComesAfter.put(trait, ArrayUtils.fromString(this.getComesAfter(trait, metawidget)));
            }
            int infiniteLoop = traitsWithComesAfter.size();
            infiniteLoop *= infiniteLoop;
            while (!traitsWithComesAfter.isEmpty()) {
                if (--infiniteLoop < 0) {
                    ArrayList names = CollectionUtils.newArrayList();
                    for (Map.Entry entry : traitsWithComesAfter.entrySet()) {
                        String value = ((String[])entry.getValue()).length == 0 ? "at the end" : new StringBuffer().append("after ").append(ArrayUtils.toString(entry.getValue(), " and ")).toString();
                        names.add(new StringBuffer().append(((Element)entry.getKey()).getAttribute("name")).append(" comes ").append(value).toString());
                    }
                    Collections.sort(names);
                    throw InspectionResultProcessorException.newException(new StringBuffer().append("Infinite loop detected when sorting comes-after: ").append(CollectionUtils.toString(names, ", but ")).toString());
                }
                Iterator i = traitsWithComesAfter.entrySet().iterator();
                block5: while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    Element traitWithComesAfter = (Element)entry.getKey();
                    String[] comesAfter = (String[])entry.getValue();
                    if (comesAfter.length == 0) {
                        for (String[] traitWithComesAfterExisting : traitsWithComesAfter.values()) {
                            if (traitWithComesAfterExisting.length <= 0) continue;
                            continue block5;
                        }
                        newEntity.appendChild(XmlUtils.importElement(newDocument, traitWithComesAfter));
                    } else {
                        String name = traitWithComesAfter.getAttribute("name");
                        for (String comeAfter : comesAfter) {
                            if (name.equals(comeAfter)) {
                                throw InspectionResultProcessorException.newException(new StringBuffer().append("'").append(comeAfter).append("' ").append("comes-after").append(" itself").toString());
                            }
                            for (Element traitExisting : traitsWithComesAfter.keySet()) {
                                if (!comeAfter.equals(traitExisting.getAttribute("name"))) continue;
                                continue block5;
                            }
                        }
                        NodeList newTraits = newEntity.getChildNodes();
                        Node insertBefore = newTraits.item(0);
                        int last = newTraits.getLength() - 1;
                        for (int loop = 0; loop <= last; ++loop) {
                            Element trait;
                            Node node = newTraits.item(loop);
                            if (!(node instanceof Element) || !ArrayUtils.contains(comesAfter, (trait = (Element)node).getAttribute("name"))) continue;
                            insertBefore = loop == last ? null : trait.getNextSibling();
                        }
                        if (insertBefore == null) {
                            newEntity.appendChild(XmlUtils.importElement(newDocument, traitWithComesAfter));
                        } else {
                            newEntity.insertBefore(XmlUtils.importElement(newDocument, traitWithComesAfter), insertBefore);
                        }
                    }
                    i.remove();
                }
            }
            return newInspectionResultRoot;
        }
        catch (Exception e) {
            throw InspectionResultProcessorException.newException(e);
        }
    }

    protected boolean hasComesAfter(Element element, M metawidget) {
        return element.hasAttribute("comes-after");
    }

    protected String getComesAfter(Element element, M metawidget) {
        return element.getAttribute("comes-after");
    }

    @Override
    public /* synthetic */ Object processInspectionResultAsDom(Object x0, Object x1) {
        return this.processInspectionResultAsDom((Element)x0, x1);
    }
}

