/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.annotation;

import java.util.HashMap;
import java.util.Map;
import org.metawidget.inspector.annotation.UiAction;
import org.metawidget.inspector.annotation.UiAttribute;
import org.metawidget.inspector.annotation.UiAttributes;
import org.metawidget.inspector.annotation.UiComesAfter;
import org.metawidget.inspector.annotation.UiDontExpand;
import org.metawidget.inspector.annotation.UiHidden;
import org.metawidget.inspector.annotation.UiLabel;
import org.metawidget.inspector.annotation.UiLarge;
import org.metawidget.inspector.annotation.UiLookup;
import org.metawidget.inspector.annotation.UiMasked;
import org.metawidget.inspector.annotation.UiReadOnly;
import org.metawidget.inspector.annotation.UiRequired;
import org.metawidget.inspector.annotation.UiSection;
import org.metawidget.inspector.annotation.UiWide;
import org.metawidget.inspector.impl.BaseObjectInspector;
import org.metawidget.inspector.impl.BaseObjectInspectorConfig;
import org.metawidget.inspector.impl.Trait;
import org.metawidget.inspector.impl.actionstyle.Action;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.util.ArrayUtils;
import org.metawidget.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetawidgetAnnotationInspector
extends BaseObjectInspector {
    public MetawidgetAnnotationInspector() {
        this(new BaseObjectInspectorConfig());
    }

    public MetawidgetAnnotationInspector(BaseObjectInspectorConfig config) {
        super(config);
    }

    @Override
    protected Map<String, String> inspectTrait(Trait trait) throws Exception {
        UiAttributes uiAttributes;
        UiAttribute attribute;
        UiLabel label;
        UiSection uiSection;
        UiReadOnly readOnly;
        UiComesAfter comesAfter;
        HashMap<String, String> attributes = CollectionUtils.newHashMap();
        if (trait.isAnnotationPresent(UiHidden.class)) {
            attributes.put("hidden", "true");
        }
        if ((comesAfter = trait.getAnnotation(UiComesAfter.class)) != null) {
            attributes.put("comes-after", ArrayUtils.toString(comesAfter.value()));
        }
        if ((readOnly = trait.getAnnotation(UiReadOnly.class)) != null) {
            attributes.put("read-only", "true");
        }
        if ((uiSection = trait.getAnnotation(UiSection.class)) != null) {
            attributes.put("section", ArrayUtils.toString(uiSection.value()));
        }
        if ((label = trait.getAnnotation(UiLabel.class)) != null) {
            attributes.put("label", label.value());
        }
        if ((attribute = trait.getAnnotation(UiAttribute.class)) != null) {
            attributes.put(attribute.name(), attribute.value());
        }
        if ((uiAttributes = trait.getAnnotation(UiAttributes.class)) != null) {
            for (UiAttribute nestedAttribute : uiAttributes.value()) {
                attributes.put(nestedAttribute.name(), nestedAttribute.value());
            }
        }
        return attributes;
    }

    @Override
    protected Map<String, String> inspectProperty(Property property) throws Exception {
        UiDontExpand dontExpand;
        UiLookup lookup;
        HashMap<String, String> attributes = CollectionUtils.newHashMap();
        if (property.isAnnotationPresent(UiRequired.class)) {
            attributes.put("required", "true");
        }
        if ((lookup = property.getAnnotation(UiLookup.class)) != null) {
            attributes.put("lookup", ArrayUtils.toString(lookup.value()));
            if (lookup.labels().length > 0) {
                attributes.put("lookup-labels", ArrayUtils.toString(lookup.labels()));
            }
        }
        if (property.isAnnotationPresent(UiMasked.class)) {
            attributes.put("masked", "true");
        }
        if (property.isAnnotationPresent(UiLarge.class)) {
            attributes.put("large", "true");
        }
        if (property.isAnnotationPresent(UiWide.class)) {
            attributes.put("wide", "true");
        }
        if ((dontExpand = property.getAnnotation(UiDontExpand.class)) != null) {
            attributes.put("dont-expand", "true");
        }
        return attributes;
    }

    @Override
    protected Map<String, String> inspectAction(Action action) throws Exception {
        HashMap<String, String> attributes = CollectionUtils.newHashMap();
        if (action.isAnnotationPresent(UiAction.class)) {
            attributes.put("name", action.getName());
        }
        return attributes;
    }
}

