/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl;

import org.metawidget.inspector.impl.actionstyle.ActionStyle;
import org.metawidget.inspector.impl.propertystyle.PropertyStyle;
import org.metawidget.inspector.impl.propertystyle.javabean.JavaBeanPropertyStyle;
import org.metawidget.util.simple.ObjectUtils;

public class BaseObjectInspectorConfig {
    private static PropertyStyle DEFAULT_PROPERTY_STYLE;
    private static ActionStyle DEFAULT_ACTION_STYLE;
    protected PropertyStyle mPropertyStyle;
    protected boolean mNullPropertyStyle;
    protected ActionStyle mActionStyle;
    protected boolean mNullActionStyle;

    public BaseObjectInspectorConfig setPropertyStyle(PropertyStyle propertyStyle) {
        this.mPropertyStyle = propertyStyle;
        if (propertyStyle == null) {
            this.mNullPropertyStyle = true;
        }
        return this;
    }

    public BaseObjectInspectorConfig setActionStyle(ActionStyle actionStyle) {
        this.mActionStyle = actionStyle;
        if (actionStyle == null) {
            this.mNullActionStyle = true;
        }
        return this;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.getClass() != that.getClass()) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mPropertyStyle, ((BaseObjectInspectorConfig)that).mPropertyStyle)) {
            return false;
        }
        if (this.mNullPropertyStyle != ((BaseObjectInspectorConfig)that).mNullPropertyStyle) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mActionStyle, ((BaseObjectInspectorConfig)that).mActionStyle)) {
            return false;
        }
        return this.mNullActionStyle == ((BaseObjectInspectorConfig)that).mNullActionStyle;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.mPropertyStyle);
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(new Boolean(this.mNullPropertyStyle));
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.mActionStyle);
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(new Boolean(this.mNullActionStyle));
        return hashCode;
    }

    protected PropertyStyle getPropertyStyle() {
        if (this.mPropertyStyle == null && !this.mNullPropertyStyle) {
            if (DEFAULT_PROPERTY_STYLE == null) {
                DEFAULT_PROPERTY_STYLE = new JavaBeanPropertyStyle();
            }
            return DEFAULT_PROPERTY_STYLE;
        }
        return this.mPropertyStyle;
    }

    protected ActionStyle getActionStyle() {
        if (this.mActionStyle == null && !this.mNullActionStyle) {
            if (DEFAULT_ACTION_STYLE == null) {
                try {
                    DEFAULT_ACTION_STYLE = (ActionStyle)Class.forName(ActionStyle.class.getPackage().getName() + ".metawidget.MetawidgetActionStyle").newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return DEFAULT_ACTION_STYLE;
        }
        return this.mActionStyle;
    }
}

