/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl.actionstyle;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.metawidget.inspector.impl.actionstyle.Action;
import org.metawidget.inspector.impl.actionstyle.ActionStyle;
import org.metawidget.util.CollectionUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseActionStyle
implements ActionStyle {
    private final Map<Class<?>, Map<String, Action>> mActionCache = CollectionUtils.newHashMap();
    static /* synthetic */ Class class$java$lang$Object;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Action> getActions(Class<?> clazz) {
        Map<Class<?>, Map<String, Action>> map = this.mActionCache;
        synchronized (map) {
            Map<String, Action> actions = this.getCachedActions(clazz);
            if (actions == null) {
                if (!this.isProxy(clazz)) {
                    actions = this.inspectActions(clazz);
                } else {
                    Class<?> superclass = clazz.getSuperclass();
                    if (!superclass.equals(class$java$lang$Object == null ? (class$java$lang$Object = BaseActionStyle.class$("java.lang.Object")) : class$java$lang$Object)) {
                        actions = this.getCachedActions(superclass);
                        if (actions == null) {
                            actions = this.inspectActions(superclass);
                            this.cacheActions(superclass, actions);
                        }
                    } else {
                        actions = this.inspectActions(clazz.getInterfaces());
                    }
                }
                this.cacheActions(clazz, actions);
            }
            return actions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        Map<Class<?>, Map<String, Action>> map = this.mActionCache;
        synchronized (map) {
            this.mActionCache.clear();
        }
    }

    protected boolean isProxy(Class<?> clazz) {
        String name = clazz.getName();
        if (name.indexOf("_$$_javassist_") != -1) {
            return true;
        }
        return name.indexOf("ByCGLIB$$") != -1;
    }

    protected Map<String, Action> inspectActions(Class<?>[] classes) {
        TreeMap<String, Action> actionsToReturn = CollectionUtils.newTreeMap();
        for (Class<?> clazz : classes) {
            Map<String, Action> actions = this.getCachedActions(clazz);
            if (actions == null) {
                actions = this.inspectActions(clazz);
                this.cacheActions(clazz, actions);
            }
            actionsToReturn.putAll(actions);
        }
        return actionsToReturn;
    }

    protected abstract Map<String, Action> inspectActions(Class<?> var1);

    protected Map<String, Action> getCachedActions(Class<?> clazz) {
        return this.mActionCache.get(clazz);
    }

    protected void cacheActions(Class<?> clazz, Map<String, Action> actions) {
        this.mActionCache.put(clazz, Collections.unmodifiableMap(actions));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

