/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl.propertystyle;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.metawidget.inspector.impl.propertystyle.BasePropertyStyleConfig;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.inspector.impl.propertystyle.PropertyStyle;
import org.metawidget.util.CollectionUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasePropertyStyle
implements PropertyStyle {
    private final Map<Class<?>, Map<String, Property>> mPropertiesCache = CollectionUtils.newHashMap();
    private Pattern mExcludeBaseType;
    static /* synthetic */ Class class$java$lang$Object;

    protected BasePropertyStyle(BasePropertyStyleConfig config) {
        this.mExcludeBaseType = config.getExcludeBaseType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Property> getProperties(Class<?> clazz) {
        Map<Class<?>, Map<String, Property>> map = this.mPropertiesCache;
        synchronized (map) {
            Map<String, Property> properties = this.getCachedProperties(clazz);
            if (properties == null) {
                if (!this.isProxy(clazz)) {
                    properties = this.inspectProperties(clazz);
                } else {
                    Class<?> superclass = clazz.getSuperclass();
                    if (!superclass.equals(class$java$lang$Object == null ? (class$java$lang$Object = BasePropertyStyle.class$("java.lang.Object")) : class$java$lang$Object)) {
                        properties = this.getCachedProperties(superclass);
                        if (properties == null) {
                            properties = this.inspectProperties(superclass);
                            this.cacheProperties(superclass, properties);
                        }
                    } else {
                        properties = this.inspectProperties(clazz.getInterfaces());
                    }
                }
                this.cacheProperties(clazz, properties);
            }
            return properties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        Map<Class<?>, Map<String, Property>> map = this.mPropertiesCache;
        synchronized (map) {
            this.mPropertiesCache.clear();
        }
    }

    protected boolean isExcluded(Class<?> classToExclude, String propertyName, Class<?> propertyType) {
        if (this.isExcludedBaseType(classToExclude)) {
            return true;
        }
        if (this.isExcludedReturnType(propertyType)) {
            return true;
        }
        return this.isExcludedName(propertyName);
    }

    protected boolean isExcludedBaseType(Class<?> classToExclude) {
        String className = classToExclude.getName();
        return this.mExcludeBaseType != null && this.mExcludeBaseType.matcher(className).matches();
    }

    protected boolean isExcludedName(String name) {
        return false;
    }

    protected boolean isExcludedReturnType(Class<?> clazz) {
        return false;
    }

    protected boolean isProxy(Class<?> clazz) {
        String name = clazz.getName();
        if (name.indexOf("_$$_javassist_") != -1) {
            return true;
        }
        return name.indexOf("ByCGLIB$$") != -1;
    }

    protected Map<String, Property> inspectProperties(Class<?>[] classes) {
        TreeMap<String, Property> propertiesToReturn = CollectionUtils.newTreeMap();
        for (Class<?> clazz : classes) {
            Map<String, Property> properties = this.getCachedProperties(clazz);
            if (properties == null) {
                properties = this.inspectProperties(clazz);
                this.cacheProperties(clazz, properties);
            }
            propertiesToReturn.putAll(properties);
        }
        return propertiesToReturn;
    }

    protected abstract Map<String, Property> inspectProperties(Class<?> var1);

    protected Map<String, Property> getCachedProperties(Class<?> clazz) {
        return this.mPropertiesCache.get(clazz);
    }

    protected void cacheProperties(Class<?> clazz, Map<String, Property> properties) {
        this.mPropertiesCache.put(clazz, Collections.unmodifiableMap(properties));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

