/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.jsp;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.el.ExpressionEvaluator;
import javax.servlet.jsp.el.VariableResolver;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.BaseObjectInspector;
import org.metawidget.inspector.impl.BaseObjectInspectorConfig;
import org.metawidget.inspector.impl.Trait;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.inspector.jsp.UiJspAttribute;
import org.metawidget.inspector.jsp.UiJspAttributes;
import org.metawidget.inspector.jsp.UiJspLookup;
import org.metawidget.jsp.JspUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.InspectorUtils;
import org.metawidget.util.ThreadUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JspAnnotationInspector
extends BaseObjectInspector {
    private static final ThreadLocal<PageContext> LOCAL_PAGE_CONTEXT = ThreadUtils.newThreadLocal();

    public static void setThreadLocalPageContext(PageContext pageContext) {
        LOCAL_PAGE_CONTEXT.set(pageContext);
    }

    public JspAnnotationInspector() {
        this(new BaseObjectInspectorConfig());
    }

    public JspAnnotationInspector(BaseObjectInspectorConfig config) {
        super(config);
    }

    @Override
    protected Map<String, String> inspectTrait(Trait trait) throws Exception {
        ExpressionEvaluator expressionEvaluator;
        UiJspAttributes jspAttributes = trait.getAnnotation(UiJspAttributes.class);
        UiJspAttribute jspAttribute = trait.getAnnotation(UiJspAttribute.class);
        if (jspAttributes == null && jspAttribute == null) {
            return null;
        }
        HashMap<String, String> attributes = CollectionUtils.newHashMap();
        PageContext pageContext = LOCAL_PAGE_CONTEXT.get();
        if (pageContext == null) {
            throw InspectorException.newException("ThreadLocalPageContext not set");
        }
        try {
            expressionEvaluator = pageContext.getExpressionEvaluator();
        }
        catch (Exception e) {
            throw InspectorException.newException("ExpressionEvaluator requires JSP 2.0");
        }
        VariableResolver variableResolver = pageContext.getVariableResolver();
        if (jspAttribute != null) {
            this.putJspAttribute(expressionEvaluator, variableResolver, attributes, jspAttribute);
        }
        if (jspAttributes != null) {
            for (UiJspAttribute nestedJspAttribute : jspAttributes.value()) {
                this.putJspAttribute(expressionEvaluator, variableResolver, attributes, nestedJspAttribute);
            }
        }
        return attributes;
    }

    @Override
    protected Map<String, String> inspectProperty(Property property) throws Exception {
        HashMap<String, String> attributes = CollectionUtils.newHashMap();
        UiJspLookup jspLookup = property.getAnnotation(UiJspLookup.class);
        if (jspLookup != null) {
            attributes.put("jsp-lookup", jspLookup.value());
        }
        return attributes;
    }

    protected void putJspAttribute(ExpressionEvaluator expressionEvaluator, VariableResolver variableResolver, Map<String, String> attributes, UiJspAttribute jspAttribute) throws Exception {
        String expression = jspAttribute.expression();
        if (!JspUtils.isExpression(expression)) {
            throw InspectorException.newException("Expression '" + expression + "' is not of the form ${...}");
        }
        Object value = expressionEvaluator.evaluate(expression, Object.class, variableResolver, null);
        if (value == null) {
            return;
        }
        for (String attributeName : jspAttribute.name()) {
            InspectorUtils.putAttributeValue(attributes, attributeName, value);
        }
    }
}

