/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.jsp;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.regex.Pattern;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.el.ExpressionEvaluator;
import javax.servlet.jsp.el.VariableResolver;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.IterationTag;
import javax.servlet.jsp.tagext.Tag;

public final class JspUtils {
    private static final Pattern PATTERN_BINDING = Pattern.compile("^\\$\\{(.*)\\}$");
    private static final Pattern PATTERN_HIDDEN_FIELDS = Pattern.compile("(\\s*<\\s*(input)\\s+[^>]*?(type)\\s*=\\s*\"\\s*hidden\\s*\"[^>]*?>\\s*)+?");

    public static boolean isExpression(String binding) {
        return PATTERN_BINDING.matcher(binding).matches();
    }

    public static boolean isJustHiddenFields(String html) {
        return PATTERN_HIDDEN_FIELDS.matcher(html).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeTag(PageContext context, Tag tag, Tag parentTag, BodyPreparer generator) throws JspException {
        PageContextDelegate pageContext = new PageContextDelegate(context);
        tag.setPageContext((PageContext)pageContext);
        tag.setParent(parentTag);
        try {
            int returnCode = tag.doStartTag();
            if (returnCode != 0) {
                if (generator != null) {
                    if (tag instanceof BodyTag) {
                        ((BodyTag)tag).setBodyContent((BodyContent)new BufferedContent());
                    }
                    try {
                        generator.prepareBody(pageContext);
                    }
                    catch (IOException e) {
                        throw new JspException((Throwable)e);
                    }
                    if (tag instanceof BodyTag) {
                        ((BodyTag)tag).doInitBody();
                    }
                }
                if (tag instanceof IterationTag) {
                    returnCode = 2;
                    while (returnCode == 2) {
                        returnCode = ((IterationTag)tag).doAfterBody();
                    }
                }
            }
            tag.doEndTag();
        }
        finally {
            tag.release();
        }
        return pageContext.getOut().toString();
    }

    private JspUtils() {
    }

    private static class BufferedContent
    extends BodyContent {
        private StringWriter mStringWriter;
        private PrintWriter mPrintWriter;

        public BufferedContent() {
            super(null);
            this.clear();
        }

        public void clear() {
            this.mStringWriter = new StringWriter();
            this.mPrintWriter = new PrintWriter(this.mStringWriter);
        }

        public void clearBuffer() {
        }

        public void close() {
            this.mPrintWriter.close();
        }

        public void flush() {
            this.mPrintWriter.flush();
        }

        public int getRemaining() {
            return 0;
        }

        public void newLine() {
            this.mPrintWriter.println();
        }

        public void print(boolean value) {
            this.mPrintWriter.print(value);
        }

        public void print(char value) {
            this.mPrintWriter.print(value);
        }

        public void print(int value) {
            this.mPrintWriter.print(value);
        }

        public void print(long value) {
            this.mPrintWriter.print(value);
        }

        public void print(float value) {
            this.mPrintWriter.print(value);
        }

        public void print(double value) {
            this.mPrintWriter.print(value);
        }

        public void print(char[] value) {
            this.mPrintWriter.print(value);
        }

        public void print(String value) {
            this.mPrintWriter.print(value);
        }

        public void print(Object value) {
            this.mPrintWriter.print(value);
        }

        public void println() {
            this.mPrintWriter.println();
        }

        public void println(boolean value) {
            this.mPrintWriter.println(value);
        }

        public void println(char value) {
            this.mPrintWriter.println(value);
        }

        public void println(int value) {
            this.mPrintWriter.println(value);
        }

        public void println(long value) {
            this.mPrintWriter.println(value);
        }

        public void println(float value) {
            this.mPrintWriter.println(value);
        }

        public void println(double value) {
            this.mPrintWriter.println(value);
        }

        public void println(char[] value) {
            this.mPrintWriter.println(value);
        }

        public void println(String value) {
            this.mPrintWriter.println(value);
        }

        public void println(Object value) {
            this.mPrintWriter.println(value);
        }

        public void write(char[] cbuf, int off, int len) {
            this.mPrintWriter.write(cbuf, off, len);
        }

        public String toString() {
            return this.getString();
        }

        public Reader getReader() {
            return new StringReader(this.getString());
        }

        public String getString() {
            return this.mStringWriter.toString();
        }

        public void writeOut(Writer writer) throws IOException {
            writer.write(this.getString());
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PageContextDelegate
    extends PageContext {
        private PageContext mContext;
        private JspWriter mWriter;

        public PageContextDelegate(PageContext context) {
            this.mContext = context;
            this.mWriter = new BufferedContent();
        }

        public JspWriter getOut() {
            return this.mWriter;
        }

        public Object findAttribute(String attribute) {
            return this.mContext.findAttribute(attribute);
        }

        public void forward(String relativeUrlPath) throws ServletException, IOException {
            this.mContext.forward(relativeUrlPath);
        }

        public Object getAttribute(String name, int scope) {
            return this.mContext.getAttribute(name, scope);
        }

        public Object getAttribute(String name) {
            return this.mContext.getAttribute(name);
        }

        public Enumeration<?> getAttributeNamesInScope(int scope) {
            return this.mContext.getAttributeNamesInScope(scope);
        }

        public int getAttributesScope(String name) {
            return this.mContext.getAttributesScope(name);
        }

        public Exception getException() {
            return this.mContext.getException();
        }

        public ExpressionEvaluator getExpressionEvaluator() {
            return this.mContext.getExpressionEvaluator();
        }

        public Object getPage() {
            return this.mContext.getPage();
        }

        public ServletRequest getRequest() {
            return this.mContext.getRequest();
        }

        public ServletResponse getResponse() {
            return this.mContext.getResponse();
        }

        public ServletConfig getServletConfig() {
            return this.mContext.getServletConfig();
        }

        public ServletContext getServletContext() {
            return this.mContext.getServletContext();
        }

        public HttpSession getSession() {
            return this.mContext.getSession();
        }

        public VariableResolver getVariableResolver() {
            return this.mContext.getVariableResolver();
        }

        public void handlePageException(Exception exception) throws ServletException, IOException {
            this.mContext.handlePageException(exception);
        }

        public void handlePageException(Throwable throwable) throws ServletException, IOException {
            this.mContext.handlePageException(throwable);
        }

        public void include(String relativeUrlPath, boolean flush) throws ServletException, IOException {
            this.mContext.include(relativeUrlPath, flush);
        }

        public void include(String relativeUrlPath) throws ServletException, IOException {
            this.mContext.include(relativeUrlPath);
        }

        public void initialize(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageUrl, boolean needsSession, int bufferSize, boolean autoFlush) throws IOException, IllegalStateException, IllegalArgumentException {
            this.mContext.initialize(servlet, request, response, errorPageUrl, needsSession, bufferSize, autoFlush);
        }

        public void release() {
            this.mContext.release();
        }

        public void removeAttribute(String name, int scope) {
            this.mContext.removeAttribute(name, scope);
        }

        public void removeAttribute(String name) {
            this.mContext.removeAttribute(name);
        }

        public void setAttribute(String name, Object value, int scope) {
            this.mContext.setAttribute(name, value, scope);
        }

        public void setAttribute(String name, Object value) {
            this.mContext.setAttribute(name, value);
        }
    }

    public static interface BodyPreparer {
        public void prepareBody(PageContext var1) throws JspException, IOException;
    }
}

