/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.jsp.tagext.html.layout;

import org.metawidget.layout.iface.LayoutException;
import org.metawidget.util.simple.ObjectUtils;

public class HtmlTableLayoutConfig {
    private int mNumberOfColumns = 1;
    private String mTableStyle;
    private String mTableStyleClass;
    private String[] mColumnStyleClasses;
    private String mFooterStyle;
    private String mFooterStyleClass;

    public HtmlTableLayoutConfig setNumberOfColumns(int numberOfColumns) {
        if (numberOfColumns < 0) {
            throw LayoutException.newException("numberOfColumns must be >= 0");
        }
        this.mNumberOfColumns = numberOfColumns;
        return this;
    }

    public HtmlTableLayoutConfig setTableStyle(String tableStyle) {
        this.mTableStyle = tableStyle;
        return this;
    }

    public HtmlTableLayoutConfig setTableStyleClass(String tableStyleClass) {
        this.mTableStyleClass = tableStyleClass;
        return this;
    }

    public HtmlTableLayoutConfig setColumnStyleClasses(String[] columnStyleClasses) {
        this.mColumnStyleClasses = columnStyleClasses;
        return this;
    }

    public void setFooterStyle(String footerStyle) {
        this.mFooterStyle = footerStyle;
    }

    public HtmlTableLayoutConfig setFooterStyleClass(String footerStyleClass) {
        this.mFooterStyleClass = footerStyleClass;
        return this;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.getClass() != that.getClass()) {
            return false;
        }
        if (this.mNumberOfColumns != ((HtmlTableLayoutConfig)that).mNumberOfColumns) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mTableStyle, ((HtmlTableLayoutConfig)that).mTableStyle)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mTableStyleClass, ((HtmlTableLayoutConfig)that).mTableStyleClass)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mColumnStyleClasses, ((HtmlTableLayoutConfig)that).mColumnStyleClasses)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mFooterStyle, ((HtmlTableLayoutConfig)that).mFooterStyle)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals(this.mFooterStyleClass, ((HtmlTableLayoutConfig)that).mFooterStyleClass);
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + this.mNumberOfColumns;
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.mTableStyle);
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.mTableStyleClass);
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.mColumnStyleClasses);
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.mFooterStyle);
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.mFooterStyleClass);
        return hashCode;
    }

    protected int getNumberOfColumns() {
        return this.mNumberOfColumns;
    }

    protected String getTableStyle() {
        return this.mTableStyle;
    }

    protected String getTableStyleClass() {
        return this.mTableStyleClass;
    }

    protected String[] getColumnStyleClasses() {
        return this.mColumnStyleClasses;
    }

    protected String getFooterStyle() {
        return this.mFooterStyle;
    }

    protected String getFooterStyleClass() {
        return this.mFooterStyleClass;
    }
}

