/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.util;

import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.util.regex.Pattern;
import org.metawidget.util.simple.StringUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassUtils {
    public static final String JAVABEAN_SET_PREFIX = "set";
    public static final String JAVABEAN_GET_PREFIX = "get";
    public static final String JAVABEAN_IS_PREFIX = "is";
    private static final Pattern PROXY_PATTERN = Pattern.compile("ByCGLIB\\$\\$|_\\$\\$_javassist_");
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$metawidget$util$ClassUtils;

    public static Method getReadMethod(Class<?> clazz, String property) {
        String propertyUppercased = StringUtils.uppercaseFirstLetter(property);
        try {
            return clazz.getMethod(new StringBuffer().append(JAVABEAN_GET_PREFIX).append(propertyUppercased).toString(), new Class[0]);
        }
        catch (Exception e1) {
            try {
                Method method = clazz.getMethod(new StringBuffer().append(JAVABEAN_IS_PREFIX).append(propertyUppercased).toString(), new Class[0]);
                if (Boolean.TYPE.equals(method.getReturnType())) {
                    return method;
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw new RuntimeException(new StringBuffer().append("No such method get").append(propertyUppercased).append(" (or boolean ").append(JAVABEAN_IS_PREFIX).append(propertyUppercased).append(") on ").append(clazz).toString());
        }
    }

    public static Method getWriteMethod(Class<?> clazz, String property, Class<?> type) {
        String propertyUppercased = StringUtils.uppercaseFirstLetter(property);
        for (Class<?> typeSuper = type; typeSuper != null; typeSuper = typeSuper.getSuperclass()) {
            try {
                return clazz.getMethod(new StringBuffer().append(JAVABEAN_SET_PREFIX).append(propertyUppercased).toString(), typeSuper);
            }
            catch (Exception e) {
                continue;
            }
        }
        for (Class<?> anInterface : type.getInterfaces()) {
            try {
                return clazz.getMethod(new StringBuffer().append(JAVABEAN_SET_PREFIX).append(propertyUppercased).toString(), anInterface);
            }
            catch (Exception e) {
            }
        }
        throw new RuntimeException(new StringBuffer().append("No such method set").append(propertyUppercased).append("( ").append(type.getName()).append(" ) on ").append(clazz).toString());
    }

    public static <T> T getProperty(Object base, String property) {
        try {
            Method method = ClassUtils.getReadMethod(base.getClass(), property);
            return (T)method.invoke(base, new Object[0]);
        }
        catch (Exception e) {
            if (base == null) {
                throw new RuntimeException(new StringBuffer().append("Unable to get '").append(property).append("' because base is null").toString(), e);
            }
            throw new RuntimeException(new StringBuffer().append("Unable to get '").append(property).append("' of '").append(base).append("' (").append(base.getClass()).append(")").toString(), e);
        }
    }

    public static void setProperty(Object base, String property, Object value) {
        try {
            Class<?> baseClass = base.getClass();
            Method method = ClassUtils.getReadMethod(baseClass, property);
            method = ClassUtils.getWriteMethod(baseClass, property, method.getReturnType());
            method.invoke(base, value);
        }
        catch (Exception e) {
            throw new RuntimeException(new StringBuffer().append("Unable to set '").append(property).append("' of '").append(base).append("' to '").append(value).append("'").toString(), e);
        }
    }

    public static boolean isPrimitiveWrapper(Class<?> clazz) {
        if ((class$java$lang$Number == null ? (class$java$lang$Number = ClassUtils.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(clazz)) {
            return true;
        }
        if ((class$java$lang$Boolean == null ? (class$java$lang$Boolean = ClassUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(clazz)) {
            return true;
        }
        return (class$java$lang$Character == null ? (class$java$lang$Character = ClassUtils.class$("java.lang.Character")) : class$java$lang$Character).isAssignableFrom(clazz);
    }

    public static Class<?> getWrapperClass(Class<?> clazz) {
        if (clazz.equals(Byte.TYPE)) {
            return class$java$lang$Byte == null ? (class$java$lang$Byte = ClassUtils.class$("java.lang.Byte")) : class$java$lang$Byte;
        }
        if (clazz.equals(Short.TYPE)) {
            return class$java$lang$Short == null ? (class$java$lang$Short = ClassUtils.class$("java.lang.Short")) : class$java$lang$Short;
        }
        if (clazz.equals(Integer.TYPE)) {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = ClassUtils.class$("java.lang.Integer")) : class$java$lang$Integer;
        }
        if (clazz.equals(Long.TYPE)) {
            return class$java$lang$Long == null ? (class$java$lang$Long = ClassUtils.class$("java.lang.Long")) : class$java$lang$Long;
        }
        if (clazz.equals(Float.TYPE)) {
            return class$java$lang$Float == null ? (class$java$lang$Float = ClassUtils.class$("java.lang.Float")) : class$java$lang$Float;
        }
        if (clazz.equals(Double.TYPE)) {
            return class$java$lang$Double == null ? (class$java$lang$Double = ClassUtils.class$("java.lang.Double")) : class$java$lang$Double;
        }
        if (clazz.equals(Boolean.TYPE)) {
            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = ClassUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        }
        if (clazz.equals(Character.TYPE)) {
            return class$java$lang$Character == null ? (class$java$lang$Character = ClassUtils.class$("java.lang.Character")) : class$java$lang$Character;
        }
        throw new RuntimeException(new StringBuffer().append(clazz).append(" is not a primitive type").toString());
    }

    public static boolean classExists(String clazz) {
        try {
            Class.forName(clazz, false, null);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    public static Class<?> getUnproxiedClass(Class<?> clazz) {
        return ClassUtils.getUnproxiedClass(clazz, PROXY_PATTERN);
    }

    public static Class<?> getUnproxiedClass(Class<?> clazz, Pattern proxyPattern) {
        Class<?> superclass;
        if (proxyPattern == null || !proxyPattern.matcher(clazz.getName()).find()) {
            return clazz;
        }
        if ((class$java$lang$Object == null ? (class$java$lang$Object = ClassUtils.class$("java.lang.Object")) : class$java$lang$Object).equals(superclass = clazz.getSuperclass())) {
            return clazz;
        }
        return superclass;
    }

    public static Class<?> niceForName(String className) {
        return ClassUtils.niceForName(className, Thread.currentThread().getContextClassLoader());
    }

    public static Class<?> niceForName(String className, ClassLoader classLoader) {
        try {
            if (classLoader != null) {
                return Class.forName(className, false, classLoader);
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            return Class.forName(className, false, (class$org$metawidget$util$ClassUtils == null ? (class$org$metawidget$util$ClassUtils = ClassUtils.class$("org.metawidget.util.ClassUtils")) : class$org$metawidget$util$ClassUtils).getClassLoader());
        }
        catch (ClassNotFoundException e) {
            if ("byte".equals(className)) {
                return Byte.TYPE;
            }
            if ("short".equals(className)) {
                return Short.TYPE;
            }
            if ("int".equals(className)) {
                return Integer.TYPE;
            }
            if ("long".equals(className)) {
                return Long.TYPE;
            }
            if ("float".equals(className)) {
                return Float.TYPE;
            }
            if ("double".equals(className)) {
                return Double.TYPE;
            }
            if ("boolean".equals(className)) {
                return Boolean.TYPE;
            }
            if ("char".equals(className)) {
                return Character.TYPE;
            }
            return null;
        }
    }

    public static String getSimpleName(Class<?> clazz) {
        String className = clazz.getName();
        int lastIndexOf = className.lastIndexOf(46);
        if (lastIndexOf != -1) {
            className = className.substring(lastIndexOf + 1);
        }
        return className;
    }

    private ClassUtils() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

