/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.util.simple;

public final class StringUtils {
    public static final char SEPARATOR_FORWARD_SLASH_CHAR = '/';
    public static final String SEPARATOR_FORWARD_SLASH = String.valueOf('/');
    public static final char SEPARATOR_DOT_CHAR = '.';
    public static final String SEPARATOR_DOT = String.valueOf('.');
    public static final char SEPARATOR_COMMA_CHAR = ',';
    public static final String SEPARATOR_COMMA = String.valueOf(',');
    public static final String RESOURCE_KEY_NOT_FOUND_PREFIX = "???";
    public static final String RESOURCE_KEY_NOT_FOUND_SUFFIX = "???";

    public static String lowercaseFirstLetter(String in) {
        return Character.toLowerCase(in.charAt(0)) + in.substring(1);
    }

    public static String uppercaseFirstLetter(String in) {
        return Character.toUpperCase(in.charAt(0)) + in.substring(1);
    }

    public static boolean isFirstLetterUppercase(String in) {
        if (in.length() == 0) {
            return false;
        }
        return Character.isUpperCase(in.charAt(0));
    }

    public static String uncamelCase(String camelCase) {
        return StringUtils.uncamelCase(camelCase, ' ');
    }

    public static String uncamelCase(String camelCase, char separator) {
        if (camelCase == null) {
            return null;
        }
        int length = camelCase.length();
        StringBuffer buffer = new StringBuffer(length);
        boolean first = true;
        char lastChar = separator;
        char[] chars = camelCase.toCharArray();
        for (int loop = 0; loop < length; ++loop) {
            char c = chars[loop];
            if (first) {
                buffer.append(Character.toUpperCase(c));
                first = false;
            } else if (Character.isUpperCase(c) && (!Character.isUpperCase(lastChar) || loop < chars.length - 1 && chars[loop + 1] != separator && !Character.isUpperCase(chars[loop + 1]))) {
                if (Character.isLetter(lastChar)) {
                    buffer.append(separator);
                }
                if (loop + 1 < length && !Character.isUpperCase(chars[loop + 1])) {
                    buffer.append(Character.toLowerCase(c));
                } else {
                    buffer.append(c);
                }
            } else if (Character.isDigit(c) && Character.isLetter(lastChar) && lastChar != separator) {
                buffer.append(separator);
                buffer.append(c);
            } else {
                buffer.append(c);
            }
            lastChar = c;
        }
        return buffer.toString();
    }

    public static String camelCase(String text) {
        return StringUtils.camelCase(text, ' ');
    }

    public static String camelCase(String text, char separator) {
        char[] chars;
        StringBuffer buffer = new StringBuffer(text.length());
        boolean lastWasSeparator = false;
        char[] arr$ = chars = text.toCharArray();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            char c = arr$[i$];
            if (c == separator) {
                lastWasSeparator = true;
                continue;
            }
            if (!Character.isLetter(c) && !Character.isDigit(c)) continue;
            if (buffer.length() == 0) {
                buffer.append(Character.toLowerCase(c));
                continue;
            }
            if (lastWasSeparator) {
                buffer.append(Character.toUpperCase(c));
                lastWasSeparator = false;
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static String quietValueOf(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    private StringUtils() {
    }
}

