/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.android;

import android.content.Context;
import android.content.res.Resources;
import java.io.InputStream;
import org.metawidget.config.ConfigReader;
import org.metawidget.iface.MetawidgetException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndroidConfigReader
extends ConfigReader {
    private Context mContext;

    public AndroidConfigReader(Context context) {
        this.mContext = context;
    }

    @Override
    public InputStream openResource(String resource) {
        if (!resource.startsWith("@")) {
            throw MetawidgetException.newException("Resource name does not start with '@': " + resource);
        }
        Resources resources = this.mContext.getResources();
        int id = resources.getIdentifier(resource, null, null);
        if (id == 0) {
            throw MetawidgetException.newException("Resource.getIdentifier returns 0 for " + resource);
        }
        return resources.openRawResource(id);
    }

    @Override
    protected Object createNative(String name, Class<?> namespace, String recordedText) throws Exception {
        if ("int".equals(name) && recordedText.startsWith("@")) {
            Resources resources = this.mContext.getResources();
            int id = resources.getIdentifier(recordedText, null, null);
            if (id == 0) {
                throw MetawidgetException.newException("Resource.getIdentifier returns 0 for " + recordedText);
            }
            return id;
        }
        return super.createNative(name, namespace, recordedText);
    }
}

