/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.config;

import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParserFactory;
import org.metawidget.config.NeedsResourceResolver;
import org.metawidget.config.ResourceResolver;
import org.metawidget.config.SimpleResourceResolver;
import org.metawidget.iface.Immutable;
import org.metawidget.iface.MetawidgetException;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.util.ArrayUtils;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.LogUtils;
import org.metawidget.util.XmlUtils;
import org.metawidget.util.simple.SimpleClassUtils;
import org.metawidget.util.simple.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigReader
implements ResourceResolver,
Immutable {
    static final String IMMUTABLE_NO_CONFIG = "no-config";
    static final LogUtils.Log LOG = LogUtils.getLog(class$org$metawidget$config$ConfigReader == null ? (class$org$metawidget$config$ConfigReader = ConfigReader.class$("org.metawidget.config.ConfigReader")) : class$org$metawidget$config$ConfigReader);
    static final String JAVA_NAMESPACE_PREFIX = "java:";
    protected final SAXParserFactory mFactory;
    final Map<String, XmlUtils.CachingContentHandler> mResourceCache = CollectionUtils.newHashMap();
    final Map<String, Map<Integer, Immutable>> mImmutableByLocationCache = CollectionUtils.newHashMap();
    final Map<Class<?>, Map<Object, Immutable>> mImmutableByClassCache = CollectionUtils.newWeakHashMap();
    final Map<String, Immutable> mImmutableByIdCache = CollectionUtils.newHashMap();
    final Map<String, Pattern> mPatternCache = CollectionUtils.newHashMap();
    static /* synthetic */ Class class$org$metawidget$config$ConfigReader;
    static /* synthetic */ Class class$org$metawidget$iface$Immutable;
    static /* synthetic */ Class class$java$lang$Object;

    public ConfigReader() {
        this.mFactory = SAXParserFactory.newInstance();
        this.mFactory.setNamespaceAware(true);
    }

    public <T> T configure(String resource, Class<T> toConfigure, String[] names) {
        return (T)this.configure(resource, (Object)toConfigure, names);
    }

    public Object configure(String resource, Object toConfigure, String[] names) {
        ConfigHandler configHandler = new ConfigHandler(toConfigure, names);
        String locationKey = new StringBuffer().append(resource).append(StringUtils.SEPARATOR_FORWARD_SLASH).toString();
        if (toConfigure instanceof Class) {
            locationKey = new StringBuffer().append(locationKey).append(((Class)toConfigure).getName()).toString();
        } else if (toConfigure != null) {
            locationKey = new StringBuffer().append(locationKey).append(toConfigure.getClass().getName()).toString();
        }
        locationKey = new StringBuffer().append(locationKey).append(ArrayUtils.toString(names, StringUtils.SEPARATOR_FORWARD_SLASH, true, false)).toString();
        Map<Integer, Immutable> immutableByLocationCache = this.mImmutableByLocationCache.get(locationKey);
        if (immutableByLocationCache == null) {
            immutableByLocationCache = CollectionUtils.newHashMap();
        }
        configHandler.setImmutableForThisLocationCache(immutableByLocationCache);
        try {
            XmlUtils.CachingContentHandler cachingContentHandler = this.mResourceCache.get(locationKey);
            if (cachingContentHandler != null) {
                cachingContentHandler.replay(configHandler);
            } else {
                LOG.debug("Reading resource from {0}", new Object[]{locationKey});
                cachingContentHandler = new XmlUtils.CachingContentHandler(configHandler);
                configHandler.setCachingContentHandler(cachingContentHandler);
                this.mFactory.newSAXParser().parse(this.openResource(resource), (DefaultHandler)cachingContentHandler);
                this.mResourceCache.put(locationKey, cachingContentHandler);
                this.mImmutableByLocationCache.put(locationKey, immutableByLocationCache);
            }
            return configHandler.getConfigured();
        }
        catch (Exception e) {
            throw MetawidgetException.newException(e);
        }
    }

    public <T> T configure(InputStream stream, Class<T> toConfigure, String[] names) {
        return (T)this.configure(stream, (Object)toConfigure, names);
    }

    public Object configure(InputStream stream, Object toConfigure, String[] names) {
        if (stream == null) {
            throw MetawidgetException.newException("No input stream specified");
        }
        try {
            ConfigHandler configHandler = new ConfigHandler(toConfigure, names);
            this.mFactory.newSAXParser().parse(stream, (DefaultHandler)configHandler);
            return configHandler.getConfigured();
        }
        catch (Exception e) {
            throw MetawidgetException.newException(e);
        }
    }

    @Override
    public InputStream openResource(String resource) {
        return new SimpleResourceResolver().openResource(resource);
    }

    protected boolean isNative(String name) {
        if ("null".equals(name)) {
            return true;
        }
        if ("string".equals(name)) {
            return true;
        }
        if ("class".equals(name)) {
            return true;
        }
        if ("pattern".equals(name)) {
            return true;
        }
        if ("format".equals(name)) {
            return true;
        }
        if ("int".equals(name)) {
            return true;
        }
        if ("boolean".equals(name)) {
            return true;
        }
        if ("resource".equals(name)) {
            return true;
        }
        if ("url".equals(name)) {
            return true;
        }
        if ("file".equals(name)) {
            return true;
        }
        if ("bundle".equals(name)) {
            return true;
        }
        return "constant".equals(name);
    }

    protected boolean isLazyResolvingNative(String name) {
        return "enum".equals(name);
    }

    protected Object createNative(String name, Class<?> namespace, String recordedText) throws Exception {
        if ("null".equals(name)) {
            return null;
        }
        if ("string".equals(name)) {
            return recordedText;
        }
        if ("class".equals(name)) {
            if ("".equals(recordedText)) {
                return null;
            }
            return Class.forName(recordedText);
        }
        if ("pattern".equals(name)) {
            Pattern pattern = this.mPatternCache.get(recordedText);
            if (pattern == null) {
                pattern = Pattern.compile(recordedText);
                this.mPatternCache.put(recordedText, pattern);
            }
            return pattern;
        }
        if ("format".equals(name)) {
            return new MessageFormat(recordedText);
        }
        if ("int".equals(name)) {
            return new Integer(recordedText);
        }
        if ("boolean".equals(name)) {
            return new Boolean(recordedText);
        }
        if ("bundle".equals(name)) {
            return ResourceBundle.getBundle(recordedText);
        }
        if ("enum".equals(name)) {
            return recordedText;
        }
        if ("constant".equals(name)) {
            int lastIndexOf = recordedText.lastIndexOf(46);
            if (lastIndexOf != -1) {
                return Class.forName(recordedText.substring(0, lastIndexOf)).getDeclaredField(recordedText.substring(lastIndexOf + 1)).get(null);
            }
            return namespace.getDeclaredField(recordedText).get(null);
        }
        if ("resource".equals(name)) {
            return this.openResource(recordedText);
        }
        if ("url".equals(name)) {
            return new URL(recordedText).openStream();
        }
        if ("file".equals(name)) {
            return new FileInputStream(recordedText);
        }
        throw MetawidgetException.newException(new StringBuffer().append("Don't know how to convert '").append(recordedText).append("' to a ").append(name).toString());
    }

    protected Object createNativeCollection(String name) {
        if ("array".equals(name)) {
            return new Object[0];
        }
        if ("list".equals(name)) {
            return CollectionUtils.newArrayList();
        }
        if ("set".equals(name)) {
            return CollectionUtils.newHashSet();
        }
        return null;
    }

    protected Object createLazyResolvingNative(Object nativeValue, Class<?> toResolveTo) {
        if (toResolveTo.isArray() && nativeValue.getClass().isArray()) {
            Object[] array = (Object[])nativeValue;
            Object[] compatibleArray = (Object[])Array.newInstance(toResolveTo.getComponentType(), array.length);
            try {
                System.arraycopy(array, 0, compatibleArray, 0, array.length);
                return compatibleArray;
            }
            catch (ArrayStoreException e) {
                return null;
            }
        }
        if (toResolveTo.isEnum() && nativeValue instanceof String) {
            try {
                Object enumValue = Enum.valueOf(toResolveTo, (String)nativeValue);
                return enumValue;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    protected Class<?> lookupClass(String uri, String localName) throws SAXException {
        String innerClassToConstruct;
        if (!uri.startsWith(JAVA_NAMESPACE_PREFIX)) {
            throw new SAXException(new StringBuffer().append("Namespace '").append(uri).append("' of element <").append(localName).append("> must start with ").append(JAVA_NAMESPACE_PREFIX).toString());
        }
        String packagePrefix = uri.substring(JAVA_NAMESPACE_PREFIX.length());
        String uppercasedLocalName = StringUtils.uppercaseFirstLetter(localName);
        String classToConstruct = new StringBuffer().append(packagePrefix).append('.').append(uppercasedLocalName).toString();
        Class<?> clazz = ClassUtils.niceForName(classToConstruct);
        if (clazz == null && (clazz = ClassUtils.niceForName(innerClassToConstruct = new StringBuffer().append(packagePrefix).append('$').append(uppercasedLocalName).toString())) == null) {
            throw MetawidgetException.newException(new StringBuffer().append("No such class ").append(classToConstruct).append(" or supported tag <").append(localName).append(">").toString());
        }
        return clazz;
    }

    protected boolean isImmutable(Class<?> clazz) {
        return (class$org$metawidget$iface$Immutable == null ? (class$org$metawidget$iface$Immutable = ConfigReader.class$("org.metawidget.iface.Immutable")) : class$org$metawidget$iface$Immutable).isAssignableFrom(clazz);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    private static class ConfigAndId {
        private Object mConfig;
        private String mId;

        public ConfigAndId(Object config, String id) {
            this.mConfig = config;
            this.mId = id;
        }

        public Object getConfig() {
            return this.mConfig;
        }

        public String getId() {
            return this.mId;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConfigHandler
    extends DefaultHandler {
        private static final int ENCOUNTERED_METHOD = 0;
        private static final int ENCOUNTERED_NATIVE_TYPE = 1;
        private static final int ENCOUNTERED_NATIVE_COLLECTION_TYPE = 2;
        private static final int ENCOUNTERED_CONFIGURED_TYPE = 3;
        private static final int ENCOUNTERED_JAVA_OBJECT = 4;
        private static final int ENCOUNTERED_ALREADY_CACHED_IMMUTABLE = 5;
        private static final int ENCOUNTERED_WRONG_TYPE = 6;
        private static final int ENCOUNTERED_WRONG_NAME = 7;
        private static final int EXPECTING_ROOT = 0;
        private static final int EXPECTING_TO_CONFIGURE = 1;
        private static final int EXPECTING_OBJECT = 2;
        private static final int EXPECTING_METHOD = 3;
        private static final int EXPECTING_CLOSE_OBJECT_WITH_REFID = 4;
        private Object mToConfigure;
        private String[] mNames;
        private int mLocationIndex;
        private Map<Integer, Immutable> mImmutableForThisLocationCache;
        private int mDepth;
        private int mIgnoreTypeAfterDepth = -1;
        private int mIgnoreNameAfterDepth = -1;
        private int mIgnoreImmutableAfterDepth = -1;
        private Stack<Object> mConstructing = CollectionUtils.newStack();
        private int mExpecting = 0;
        private Stack<Integer> mEncountered = CollectionUtils.newStack();
        private StringBuffer mBufferValue;
        private XmlUtils.CachingContentHandler mCachingContentHandler;

        public ConfigHandler(Object toConfigure, String[] names) {
            this.mToConfigure = toConfigure;
            this.mNames = names;
        }

        public void setImmutableForThisLocationCache(Map<Integer, Immutable> immutableForThisLocationCache) {
            this.mImmutableForThisLocationCache = immutableForThisLocationCache;
        }

        public void setCachingContentHandler(XmlUtils.CachingContentHandler cachingContentHandler) {
            this.mCachingContentHandler = cachingContentHandler;
        }

        public Object getConfigured() {
            if (this.mConstructing.isEmpty()) {
                throw MetawidgetException.newException(new StringBuffer().append("No match for ").append(this.mToConfigure).append(" within config").toString());
            }
            if (this.mConstructing.size() > 1) {
                throw MetawidgetException.newException("Config still processing");
            }
            return this.mConstructing.peek();
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            ++this.mDepth;
            if (this.mIgnoreTypeAfterDepth != -1 && this.mDepth > this.mIgnoreTypeAfterDepth) {
                return;
            }
            if (this.mIgnoreNameAfterDepth != -1 && this.mDepth > this.mIgnoreNameAfterDepth) {
                return;
            }
            if (Character.isUpperCase(localName.charAt(0))) {
                throw MetawidgetException.newException(new StringBuffer().append("XML node '").append(localName).append("' should start with a lowercase letter").toString());
            }
            try {
                switch (this.mExpecting) {
                    case 0: {
                        if (this.mToConfigure == null) {
                            this.mExpecting = 2;
                            break;
                        }
                        this.mExpecting = 1;
                        break;
                    }
                    case 1: {
                        if (this.mDepth != 2) {
                            return;
                        }
                        Class<?> toConfigureClass = ConfigReader.this.lookupClass(uri, localName);
                        if (this.mToConfigure instanceof Class) {
                            if (!((Class)this.mToConfigure).isAssignableFrom(toConfigureClass)) {
                                this.mEncountered.push(new Integer(6));
                                this.mIgnoreTypeAfterDepth = 2;
                                if (this.mCachingContentHandler != null) {
                                    this.mCachingContentHandler.pause(false);
                                }
                                return;
                            }
                            if (!this.mConstructing.isEmpty()) {
                                throw MetawidgetException.newException(new StringBuffer().append("Already configured a ").append(this.mConstructing.peek().getClass()).append(", ambiguous match with ").append(toConfigureClass).toString());
                            }
                            this.handleNonNativeObject(uri, localName, attributes);
                        } else {
                            if (!toConfigureClass.isAssignableFrom(this.mToConfigure.getClass())) {
                                this.mEncountered.push(new Integer(6));
                                this.mIgnoreTypeAfterDepth = 2;
                                if (this.mCachingContentHandler != null) {
                                    this.mCachingContentHandler.pause(false);
                                }
                                return;
                            }
                            if (!this.mConstructing.isEmpty()) {
                                throw MetawidgetException.newException(new StringBuffer().append("Already configured a ").append(this.mConstructing.peek().getClass()).append(", ambiguous match with ").append(toConfigureClass).toString());
                            }
                            this.mConstructing.push(this.mToConfigure);
                            this.mEncountered.push(new Integer(4));
                        }
                        this.mExpecting = 3;
                        break;
                    }
                    case 2: {
                        if (this.mCachingContentHandler == null || !this.mCachingContentHandler.isPaused()) {
                            ++this.mLocationIndex;
                        }
                        if (ConfigReader.this.isNative(localName) || ConfigReader.this.isLazyResolvingNative(localName)) {
                            this.mEncountered.push(new Integer(1));
                            this.startRecording();
                            this.mExpecting = 3;
                            return;
                        }
                        Object collection = ConfigReader.this.createNativeCollection(localName);
                        if (collection != null) {
                            this.mConstructing.push(collection);
                            this.mEncountered.push(new Integer(2));
                            this.mExpecting = 2;
                            return;
                        }
                        if (this.isJdk14Hack(uri, localName)) {
                            this.mEncountered.push(new Integer(6));
                            this.mExpecting = 2;
                            return;
                        }
                        this.mExpecting = this.handleNonNativeObject(uri, localName, attributes);
                        break;
                    }
                    case 3: {
                        String expectingName;
                        int nameIndex;
                        if (this.mNames != null && (nameIndex = this.mDepth - 3) < this.mNames.length && !localName.equals(expectingName = this.mNames[nameIndex])) {
                            this.mEncountered.push(new Integer(7));
                            this.mIgnoreNameAfterDepth = this.mDepth;
                            if (this.mCachingContentHandler != null) {
                                this.mCachingContentHandler.pause(false);
                            }
                            return;
                        }
                        this.mConstructing.push(new ArrayList());
                        this.mEncountered.push(new Integer(0));
                        this.mExpecting = 2;
                        break;
                    }
                    case 4: {
                        throw InspectorException.newException(new StringBuffer().append("<").append(name).append("> not expected here. Elements with a 'refId' must have an empty body").toString());
                    }
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }

        public void startRecording() {
            this.mBufferValue = new StringBuffer();
        }

        @Override
        public void characters(char[] characters, int start, int length) {
            if (this.mBufferValue == null) {
                return;
            }
            this.mBufferValue.append(characters, start, length);
        }

        public String endRecording() {
            String value = this.mBufferValue.toString();
            this.mBufferValue = null;
            return value;
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            --this.mDepth;
            if (this.mIgnoreTypeAfterDepth != -1) {
                if (this.mDepth >= this.mIgnoreTypeAfterDepth) {
                    return;
                }
                this.mIgnoreTypeAfterDepth = -1;
                if (this.mCachingContentHandler != null) {
                    this.mCachingContentHandler.unpause(false);
                }
            }
            if (this.mIgnoreNameAfterDepth != -1) {
                if (this.mDepth >= this.mIgnoreNameAfterDepth) {
                    return;
                }
                this.mIgnoreNameAfterDepth = -1;
                if (this.mCachingContentHandler != null) {
                    this.mCachingContentHandler.unpause(false);
                }
            }
            if (this.mDepth == 0) {
                return;
            }
            if (this.mConstructing.isEmpty()) {
                return;
            }
            try {
                int encountered = this.mEncountered.pop();
                switch (encountered) {
                    case 1: {
                        Object methodParameters = this.mConstructing.pop();
                        Object constructing = this.mConstructing.peek();
                        if (constructing instanceof ConfigAndId) {
                            constructing = ((ConfigAndId)this.mConstructing.peek()).getConfig();
                        }
                        this.mConstructing.push(methodParameters);
                        this.addToConstructing(ConfigReader.this.createNative(localName, constructing.getClass(), this.endRecording()));
                        this.mExpecting = 2;
                        return;
                    }
                    case 2: {
                        Object nativeCollectionType = this.mConstructing.pop();
                        Collection parameters = (Collection)this.mConstructing.peek();
                        parameters.add(nativeCollectionType);
                        this.mExpecting = 2;
                        return;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        Object object = this.mConstructing.pop();
                        if (encountered == 3) {
                            Class<?> classToConstruct = ConfigReader.this.lookupClass(uri, localName);
                            String id = ((ConfigAndId)object).getId();
                            object = ((ConfigAndId)object).getConfig();
                            Object configuredObject = null;
                            if (ConfigReader.this.isImmutable(classToConstruct)) {
                                configuredObject = this.getImmutableByClass(classToConstruct, object);
                            }
                            if (configuredObject == null) {
                                try {
                                    Constructor<?> constructor = classToConstruct.getConstructor(object.getClass());
                                    configuredObject = constructor.newInstance(object);
                                }
                                catch (NoSuchMethodException e) {
                                    String likelyConfig = this.getLikelyConfig(classToConstruct);
                                    if ("".equals(likelyConfig)) {
                                        throw MetawidgetException.newException(new StringBuffer().append(classToConstruct).append(" does not have a constructor that takes a ").append(object.getClass()).append(", as specified by your config attribute. It only has a config-less constructor").toString());
                                    }
                                    if (likelyConfig != null) {
                                        throw MetawidgetException.newException(new StringBuffer().append(classToConstruct).append(" does not have a constructor that takes a ").append(object.getClass()).append(", as specified by your config attribute. Did you mean config=\"").append(likelyConfig).append("\"?").toString());
                                    }
                                    throw MetawidgetException.newException(new StringBuffer().append(classToConstruct).append(" does not have a constructor that takes a ").append(object.getClass()).append(", as specified by your config attribute").toString());
                                }
                                if (ConfigReader.this.isImmutable(classToConstruct)) {
                                    LOG.debug("\tInstantiated immutable {0} (config hashCode {1})", new Object[]{classToConstruct, new Integer(object.hashCode())});
                                    Immutable immutable = (Immutable)configuredObject;
                                    this.putImmutableByClass(immutable, object);
                                    if (id != null) {
                                        this.putImmutableById(id, immutable);
                                    }
                                }
                            } else if (ConfigReader.this.isImmutable(classToConstruct) && this.mCachingContentHandler != null && this.mDepth < this.mIgnoreImmutableAfterDepth) {
                                this.mCachingContentHandler.unpause(true);
                                this.mIgnoreImmutableAfterDepth = -1;
                                this.putImmutableByLocation((Immutable)configuredObject);
                            }
                            object = configuredObject;
                        }
                        if (this.mDepth == 1) {
                            this.mConstructing.push(object);
                            this.mExpecting = 1;
                            return;
                        }
                        this.addToConstructing(object);
                        this.mExpecting = 2;
                        return;
                    }
                    case 0: {
                        List parameters = (List)this.mConstructing.pop();
                        Object constructing = this.mConstructing.peek();
                        if (constructing instanceof ConfigAndId) {
                            constructing = ((ConfigAndId)constructing).getConfig();
                        }
                        Class<?> constructingClass = constructing.getClass();
                        String methodName = new StringBuffer().append("set").append(StringUtils.uppercaseFirstLetter(localName)).toString();
                        try {
                            Method method = this.classGetMethod(constructingClass, methodName, parameters);
                            method.invoke(constructing, parameters.toArray());
                        }
                        catch (NoSuchMethodException e) {
                            for (Constructor<?> constructor : constructingClass.getConstructors()) {
                                String parameterClassName;
                                Class<?>[] parameterTypes = constructor.getParameterTypes();
                                if (parameterTypes.length != 1 || !(parameterClassName = SimpleClassUtils.getSimpleName(parameterTypes[0].getClass())).endsWith("Config")) continue;
                                throw MetawidgetException.newException(new StringBuffer().append("No such method ").append(methodName).append(" on ").append(constructingClass).append(". Did you forget config=\"").append(parameterClassName).append("\"?").toString());
                            }
                            throw e;
                        }
                        this.mExpecting = 3;
                        return;
                    }
                    case 6: {
                        return;
                    }
                    case 7: {
                        return;
                    }
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                if (e instanceof InvocationTargetException) {
                    Throwable t = ((InvocationTargetException)e).getTargetException();
                    if (!(t instanceof Exception)) {
                        throw new RuntimeException(t);
                    }
                    e = (Exception)t;
                }
                throw new SAXException(e);
            }
        }

        @Override
        public void warning(SAXParseException exception) {
            LOG.warn(exception.getMessage(), new Object[0]);
        }

        @Override
        public void error(SAXParseException exception) {
            throw MetawidgetException.newException(exception);
        }

        private int handleNonNativeObject(String uri, String localName, Attributes attributes) throws Exception {
            String refId = attributes.getValue("refId");
            String configClassName = attributes.getValue("config");
            if (refId != null) {
                if (configClassName != null) {
                    throw InspectorException.newException(new StringBuffer().append("Elements with 'refId' attributes (refId=\"").append(refId).append("\") cannot also have 'config' attributes (config=\"").append(configClassName).append("\")").toString());
                }
                Object immutable = this.getImmutableByRefId(refId);
                Class<?> actualClass = immutable.getClass();
                if (!StringUtils.lowercaseFirstLetter(actualClass.getSimpleName()).equals(localName)) {
                    throw InspectorException.newException(new StringBuffer().append("refId=\"").append(refId).append("\" points to an object of ").append(actualClass).append(", not a <").append(localName).append(">").toString());
                }
                this.mConstructing.push(immutable);
                this.mEncountered.push(new Integer(4));
                return 4;
            }
            Object object = null;
            Class<?> classToConstruct = ConfigReader.this.lookupClass(uri, localName);
            if (ConfigReader.this.isImmutable(classToConstruct)) {
                object = this.getImmutableByLocation();
            }
            if (object == null && configClassName != null) {
                String configToConstruct = configClassName.indexOf(46) == -1 ? new StringBuffer().append(classToConstruct.getPackage().getName()).append('.').append(configClassName).toString() : configClassName;
                Class<?> configClass = ClassUtils.niceForName(configToConstruct);
                if (configClass == null) {
                    throw MetawidgetException.newException(new StringBuffer().append("No such configuration class ").append(configToConstruct).toString());
                }
                Object config = configClass.newInstance();
                if (config instanceof NeedsResourceResolver) {
                    ((NeedsResourceResolver)config).setResourceResolver(ConfigReader.this);
                }
                this.mConstructing.push(new ConfigAndId(config, attributes.getValue("id")));
                this.mEncountered.push(new Integer(3));
                if (this.mIgnoreImmutableAfterDepth == -1 && this.mCachingContentHandler != null && ConfigReader.this.isImmutable(classToConstruct)) {
                    this.mCachingContentHandler.pause(true);
                    this.mIgnoreImmutableAfterDepth = this.mDepth;
                }
                return 3;
            }
            if (object == null && ConfigReader.this.isImmutable(classToConstruct)) {
                object = this.getImmutableByClass(classToConstruct, ConfigReader.IMMUTABLE_NO_CONFIG);
            }
            if (object == null) {
                try {
                    Constructor<?> defaultConstructor = classToConstruct.getConstructor(new Class[0]);
                    object = defaultConstructor.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    String likelyConfig = this.getLikelyConfig(classToConstruct);
                    if (likelyConfig != null) {
                        throw MetawidgetException.newException(new StringBuffer().append(classToConstruct).append(" does not have a default constructor. Did you mean config=\"").append(likelyConfig).append("\"?").toString());
                    }
                    throw MetawidgetException.newException(new StringBuffer().append(classToConstruct).append(" does not have a default constructor").toString());
                }
                if (ConfigReader.this.isImmutable(classToConstruct)) {
                    LOG.debug("\tInstantiated immutable {0} (no config)", new Object[]{classToConstruct});
                    Immutable immutable = (Immutable)object;
                    this.putImmutableByClass(immutable, null);
                    String id = attributes.getValue("id");
                    if (id != null) {
                        this.putImmutableById(id, immutable);
                    }
                }
            }
            this.mConstructing.push(object);
            this.mEncountered.push(new Integer(4));
            return 3;
        }

        private void addToConstructing(Object toAdd) {
            Object parameters = this.mConstructing.peek();
            if (parameters instanceof Collection) {
                Collection collection = (Collection)parameters;
                collection.add(toAdd);
                return;
            }
            if (parameters.getClass().isArray()) {
                Object[] array = (Object[])this.mConstructing.pop();
                Object[] newArray = new Object[array.length + 1];
                System.arraycopy(array, 0, newArray, 0, array.length);
                newArray[array.length] = toAdd;
                this.mConstructing.push(newArray);
                return;
            }
            throw MetawidgetException.newException(new StringBuffer().append("Don't know how to add to a ").append(parameters.getClass()).toString());
        }

        private Object getImmutableByLocation() {
            if (this.mImmutableForThisLocationCache == null) {
                return null;
            }
            return this.mImmutableForThisLocationCache.get(new Integer(this.mLocationIndex));
        }

        private void putImmutableByLocation(Immutable immutable) {
            if (this.mImmutableForThisLocationCache == null) {
                return;
            }
            if (this.mImmutableForThisLocationCache.containsKey(new Integer(this.mLocationIndex))) {
                throw InspectorException.newException(new StringBuffer().append("Location ").append(this.mLocationIndex).append(" already cached").toString());
            }
            this.mImmutableForThisLocationCache.put(new Integer(this.mLocationIndex), immutable);
        }

        private Object getImmutableByRefId(String refId) {
            if (!ConfigReader.this.mImmutableByIdCache.containsKey(refId)) {
                throw InspectorException.newException(new StringBuffer().append("Attribute refId=\"").append(refId).append("\" refers to non-existent id").toString());
            }
            return ConfigReader.this.mImmutableByIdCache.get(refId);
        }

        private void putImmutableById(String id, Immutable immutable) {
            if (ConfigReader.this.mImmutableByIdCache.containsKey(id)) {
                throw InspectorException.newException(new StringBuffer().append("Attribute id=\"").append(id).append("\" appears more than once").toString());
            }
            ConfigReader.this.mImmutableByIdCache.put(id, immutable);
        }

        private Object getImmutableByClass(Class<?> clazz, Object config) {
            Map<Object, Immutable> configs = ConfigReader.this.mImmutableByClassCache.get(clazz);
            if (configs == null) {
                return null;
            }
            Object configToLookup = config;
            if (configToLookup == null) {
                configToLookup = ConfigReader.IMMUTABLE_NO_CONFIG;
            }
            return configs.get(configToLookup);
        }

        private void putImmutableByClass(Immutable immutable, Object config) {
            Object configToStoreUnder;
            Map<Object, Immutable> configs;
            block15: {
                Class<?> clazz = immutable.getClass();
                configs = ConfigReader.this.mImmutableByClassCache.get(clazz);
                if (configs == null) {
                    configs = CollectionUtils.newHashMap();
                    ConfigReader.this.mImmutableByClassCache.put(clazz, configs);
                }
                if ((configToStoreUnder = config) == null) {
                    configToStoreUnder = ConfigReader.IMMUTABLE_NO_CONFIG;
                } else {
                    try {
                        Class<?> hashCodeDeclaringClass;
                        Class<?> configClass = configToStoreUnder.getClass();
                        Class<?> equalsDeclaringClass = configClass.getMethod("equals", class$java$lang$Object == null ? (class$java$lang$Object = ConfigReader.class$("java.lang.Object")) : class$java$lang$Object).getDeclaringClass();
                        if ((class$java$lang$Object == null ? (class$java$lang$Object = ConfigReader.class$("java.lang.Object")) : class$java$lang$Object).equals(equalsDeclaringClass)) {
                            throw MetawidgetException.newException(new StringBuffer().append(configClass).append(" does not override .equals(), so cannot cache reliably").toString());
                        }
                        if ((class$java$lang$Object == null ? (class$java$lang$Object = ConfigReader.class$("java.lang.Object")) : class$java$lang$Object).equals(hashCodeDeclaringClass = configClass.getMethod("hashCode", new Class[0]).getDeclaringClass())) {
                            throw MetawidgetException.newException(new StringBuffer().append(configClass).append(" does not override .hashCode(), so cannot cache reliably").toString());
                        }
                        if (System.identityHashCode(configToStoreUnder) == configToStoreUnder.hashCode()) {
                            LOG.warn("{0} overrides .hashCode(), but it returns the same as System.identityHashCode, so cannot be cached reliably", new Object[]{configClass});
                        }
                        if (!equalsDeclaringClass.equals(hashCodeDeclaringClass)) {
                            throw MetawidgetException.newException(new StringBuffer().append(equalsDeclaringClass).append(" implements .equals(), but .hashCode() is implemented by ").append(hashCodeDeclaringClass).append(", so cannot cache reliably").toString());
                        }
                        if (configClass.equals(equalsDeclaringClass)) break block15;
                        for (Method declaredMethod : configClass.getMethods()) {
                            if (!configClass.equals(declaredMethod.getDeclaringClass())) continue;
                            for (Method equalsDeclaredMethod : equalsDeclaringClass.getMethods()) {
                                if (!equalsDeclaredMethod.getName().equals(declaredMethod.getName())) {
                                    continue;
                                }
                                break block15;
                            }
                            LOG.warn("{0} does not override .equals() (only its super{1} does), so may not be cached reliably", new Object[]{configClass, equalsDeclaringClass});
                            break;
                        }
                    }
                    catch (Exception e) {
                        throw MetawidgetException.newException(e);
                    }
                }
            }
            if (configs.containsKey(configToStoreUnder)) {
                throw InspectorException.newException(new StringBuffer().append("Config '").append(configToStoreUnder).append("' already cached").toString());
            }
            configs.put(configToStoreUnder, immutable);
            if (this.mCachingContentHandler != null && this.mDepth < this.mIgnoreImmutableAfterDepth) {
                this.mCachingContentHandler.unpause(true);
                this.mIgnoreImmutableAfterDepth = -1;
                if (config != null) {
                    this.putImmutableByLocation(immutable);
                }
            }
        }

        protected boolean isJdk14Hack(String uri, String localName) {
            if (!"java:org.metawidget.inspector.annotation".equals(uri)) {
                return false;
            }
            if (!"metawidgetAnnotationInspector".equals(localName)) {
                return false;
            }
            try {
                ClassUtils.niceForName("org.metawidget.inspector.annotation.MetawidgetAnnotationInspector");
                return false;
            }
            catch (UnsupportedClassVersionError e) {
                LOG.debug("\tNot instantiating org.metawidget.inspector.annotation.MetawidgetAnnotationInspector - wrong Java version", new Object[0]);
                return true;
            }
        }

        private Method classGetMethod(Class<?> clazz, String name, List<Object> args) throws NoSuchMethodException {
            int numberOfParameterTypes = args.size();
            Method likelyMatch = null;
            block0: for (Method method : clazz.getMethods()) {
                if (!method.getName().equals(name)) continue;
                likelyMatch = method;
                Class<?>[] methodParameterTypes = method.getParameterTypes();
                if (methodParameterTypes.length != numberOfParameterTypes) continue;
                ArrayList<Object> compatibleArgs = CollectionUtils.newArrayList(args);
                for (int loop = 0; loop < numberOfParameterTypes; ++loop) {
                    Object arg = compatibleArgs.get(loop);
                    Class<?> parameterType = methodParameterTypes[loop];
                    if (parameterType.isPrimitive()) {
                        parameterType = ClassUtils.getWrapperClass(parameterType);
                    } else if (arg == null) continue;
                    if (parameterType.isInstance(arg)) continue;
                    Object resolvedValue = ConfigReader.this.createLazyResolvingNative(arg, parameterType);
                    if (resolvedValue == null) continue block0;
                    compatibleArgs.remove(loop);
                    compatibleArgs.add(loop, resolvedValue);
                }
                args.clear();
                args.addAll(compatibleArgs);
                return method;
            }
            if (likelyMatch != null) {
                throw new NoSuchMethodException(new StringBuffer().append(this.methodToString(clazz, name, args)).append(". Did you mean ").append(this.methodToString(likelyMatch)).append("?").toString());
            }
            throw new NoSuchMethodException(this.methodToString(clazz, name, args));
        }

        private String getLikelyConfig(Class<?> clazz) {
            Constructor<?>[] constructors = clazz.getConstructors();
            if (constructors.length != 1) {
                return null;
            }
            if (constructors[0].getParameterTypes().length == 0) {
                return "";
            }
            if (constructors[0].getParameterTypes().length > 1) {
                return null;
            }
            Class<?> likelyConfigClass = constructors[0].getParameterTypes()[0];
            if (likelyConfigClass.getPackage().equals(clazz.getPackage())) {
                return SimpleClassUtils.getSimpleName(likelyConfigClass);
            }
            return likelyConfigClass.getName();
        }

        private String methodToString(Method method) {
            StringBuffer buffer = new StringBuffer();
            for (Class<?> parameterType : method.getParameterTypes()) {
                if (buffer.length() > 0) {
                    buffer.append(", ");
                }
                if (parameterType.isArray()) {
                    buffer.append(SimpleClassUtils.getSimpleName(parameterType.getComponentType()));
                    buffer.append("[]");
                    continue;
                }
                buffer.append(SimpleClassUtils.getSimpleName(parameterType));
            }
            buffer.insert(0, "(");
            buffer.insert(0, method.getName());
            buffer.append(")");
            return buffer.toString();
        }

        private String methodToString(Class<?> clazz, String methodName, List<Object> args) {
            StringBuffer buffer = new StringBuffer();
            for (Object obj : args) {
                if (buffer.length() > 0) {
                    buffer.append(", ");
                }
                if (obj == null) {
                    buffer.append("null");
                    continue;
                }
                buffer.append(SimpleClassUtils.getSimpleName(obj.getClass()));
            }
            buffer.insert(0, "(");
            buffer.insert(0, methodName);
            buffer.insert(0, '.');
            buffer.insert(0, clazz);
            buffer.append(")");
            return buffer.toString();
        }
    }
}

