/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.faces;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FacesUtils {
    private static final Pattern PATTERN_EXPRESSION = Pattern.compile("((#|\\$)\\{)(.*)(\\})");
    private static final String EXPRESSION_START = "#{";
    private static final String EXPRESSION_END = "}";

    public static boolean isExpression(String string) {
        return PATTERN_EXPRESSION.matcher(string).matches();
    }

    public static String unwrapExpression(String string) {
        Matcher matcher = PATTERN_EXPRESSION.matcher(string);
        if (!matcher.matches()) {
            return string;
        }
        return matcher.group(3);
    }

    public static String wrapExpression(String string) {
        if (FacesUtils.isExpression(string)) {
            return string;
        }
        return new StringBuffer().append(EXPRESSION_START).append(FacesUtils.unwrapExpression(string)).append(EXPRESSION_END).toString();
    }

    public static void render(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        if (uIComponent == null || !uIComponent.isRendered()) {
            return;
        }
        uIComponent.encodeBegin(facesContext);
        if (uIComponent.getRendersChildren()) {
            uIComponent.encodeChildren(facesContext);
        } else {
            FacesUtils.renderChildren(facesContext, uIComponent);
        }
        uIComponent.encodeEnd(facesContext);
    }

    public static boolean isJsf2() {
        try {
            Class.forName("javax.faces.event.PreRenderViewEvent");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static boolean isPartialStateSavingDisabled() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return "false".equals(facesContext.getExternalContext().getInitParameter("javax.faces.PARTIAL_STATE_SAVING"));
    }

    public static <T extends UIComponent> T createComponent(String string, String string2) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        if (FacesUtils.isJsf2()) {
            return (T)application.createComponent(facesContext, string, string2);
        }
        return (T)application.createComponent(string);
    }

    private static void renderChildren(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        for (UIComponent uIComponent2 : uIComponent.getChildren()) {
            FacesUtils.render(facesContext, uIComponent2);
        }
    }

    private FacesUtils() {
    }
}

