/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.faces.renderkit.html;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.component.html.HtmlInputHidden;
import javax.faces.component.html.HtmlMessage;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.metawidget.faces.FacesUtils;
import org.metawidget.faces.component.UIMetawidget;
import org.metawidget.faces.component.UIStub;
import org.metawidget.faces.renderkit.html.HtmlLayoutRenderer;
import org.metawidget.util.simple.StringUtils;

public class HtmlDivLayoutRenderer
extends HtmlLayoutRenderer {
    public void encodeBegin(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        UIMetawidget uIMetawidget = (UIMetawidget)uIComponent;
        uIMetawidget.putClientProperty(HtmlDivLayoutRenderer.class, null);
        super.encodeBegin(facesContext, (UIComponent)uIMetawidget);
        State state = this.getState((UIComponent)uIMetawidget);
        state.outerStyle = uIMetawidget.getParameter("outerStyle");
        state.labelStyle = uIMetawidget.getParameter("labelStyle");
        state.componentStyle = uIMetawidget.getParameter("componentStyle");
        state.requiredStyle = uIMetawidget.getParameter("requiredStyle");
        String string = uIMetawidget.getParameter("divStyleClasses");
        if (string != null) {
            state.divStyleClasses = string.split(StringUtils.SEPARATOR_COMMA);
        }
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.startElement("div", (UIComponent)uIMetawidget);
        responseWriter.writeAttribute("id", (Object)uIMetawidget.getClientId(facesContext), "id");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        List list = uIComponent.getChildren();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            UIComponent uIComponent2 = (UIComponent)iterator.next();
            if (uIComponent2 instanceof UIStub && uIComponent2.getChildCount() == 0 || uIComponent2 instanceof UIParameter || !uIComponent2.isRendered()) continue;
            if (uIComponent2 instanceof HtmlInputHidden) {
                FacesUtils.render(facesContext, uIComponent2);
                continue;
            }
            this.layoutBeforeChild(facesContext, uIComponent, uIComponent2);
            this.layoutChild(facesContext, uIComponent, uIComponent2);
            this.layoutAfterChild(facesContext, uIComponent, uIComponent2);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        super.encodeEnd(facesContext, uIComponent);
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        UIComponent uIComponent2 = uIComponent.getFacet("footer");
        if (uIComponent2 != null) {
            responseWriter.startElement("div", uIComponent);
            this.writeStyleAndClass((UIMetawidget)uIComponent, responseWriter, "footer");
            FacesUtils.render(facesContext, uIComponent2);
            responseWriter.endElement("div");
        }
        responseWriter.endElement("div");
    }

    protected HtmlMessage createInlineMessage(FacesContext facesContext, UIComponent uIComponent, String string) {
        HtmlMessage htmlMessage = super.createInlineMessage(facesContext, uIComponent, string);
        if (htmlMessage.getStyleClass() == null) {
            State state = this.getState(uIComponent);
            if (state.divStyleClasses != null && state.divStyleClasses.length > 4) {
                htmlMessage.setStyleClass(state.divStyleClasses[4]);
            }
        }
        return htmlMessage;
    }

    protected void layoutBeforeChild(FacesContext facesContext, UIComponent uIComponent, UIComponent uIComponent2) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        State state = this.getState(uIComponent);
        responseWriter.startElement("div", uIComponent);
        if (state.outerStyle != null) {
            responseWriter.writeAttribute("style", (Object)state.outerStyle, null);
        }
        this.writeStyleClass(uIComponent, responseWriter, 0);
        this.layoutLabel(facesContext, uIComponent, uIComponent2);
        responseWriter.startElement("div", uIComponent);
        if (state.componentStyle != null) {
            responseWriter.writeAttribute("style", (Object)state.componentStyle, null);
        }
        this.writeStyleClass(uIComponent, responseWriter, 3);
    }

    protected boolean layoutLabel(FacesContext facesContext, UIComponent uIComponent, UIComponent uIComponent2) throws IOException {
        if (this.getLabelText(uIComponent2) == null) {
            return false;
        }
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.startElement("div", uIComponent);
        State state = this.getState(uIComponent);
        if (state.labelStyle != null) {
            responseWriter.writeAttribute("style", (Object)state.labelStyle, null);
        }
        this.writeStyleClass(uIComponent, responseWriter, 1);
        super.layoutLabel(facesContext, uIComponent, uIComponent2);
        this.layoutRequired(facesContext, uIComponent, uIComponent2);
        responseWriter.endElement("div");
        return true;
    }

    protected void layoutRequired(FacesContext facesContext, UIComponent uIComponent, UIComponent uIComponent2) throws IOException {
        Map map = (Map)uIComponent2.getAttributes().get("metawidget-metadata");
        if (map == null) {
            return;
        }
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        if ("true".equals(map.get("required")) && !"true".equals(map.get("read-only")) && !((UIMetawidget)uIComponent).isReadOnly()) {
            responseWriter.startElement("span", uIComponent);
            State state = this.getState(uIComponent);
            String string = (String)map.get(state.requiredStyle);
            if (string != null) {
                responseWriter.writeAttribute("style", (Object)string, null);
            }
            this.writeStyleClass(uIComponent, responseWriter, 2);
            responseWriter.write("*");
            responseWriter.endElement("span");
        }
    }

    protected void layoutAfterChild(FacesContext facesContext, UIComponent uIComponent, UIComponent uIComponent2) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.endElement("div");
        responseWriter.endElement("div");
    }

    protected void writeStyleClass(UIComponent uIComponent, ResponseWriter responseWriter, int n) throws IOException {
        State state = this.getState(uIComponent);
        if (state.divStyleClasses == null || state.divStyleClasses.length <= n) {
            return;
        }
        String string = state.divStyleClasses[n];
        if (string.length() == 0) {
            return;
        }
        responseWriter.writeAttribute("class", (Object)string.trim(), null);
    }

    private State getState(UIComponent uIComponent) {
        State state = (State)((UIMetawidget)uIComponent).getClientProperty(HtmlDivLayoutRenderer.class);
        if (state == null) {
            state = new State();
            ((UIMetawidget)uIComponent).putClientProperty(HtmlDivLayoutRenderer.class, state);
        }
        return state;
    }

    static class State {
        String outerStyle;
        String labelStyle;
        String requiredStyle;
        String componentStyle;
        String[] divStyleClasses;

        State() {
        }
    }
}

