/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.commons.validator;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.metawidget.config.ResourceResolver;
import org.metawidget.inspector.commons.validator.CommonsValidatorInspectorConfig;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.BaseXmlInspector;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonsValidatorInspector
extends BaseXmlInspector {
    private static final String FORMSET_ELEMENT = "formset";
    private static final String FIELD_ELEMENT = "field";

    public CommonsValidatorInspector(CommonsValidatorInspectorConfig config) {
        super(config);
    }

    @Override
    protected Element getDocumentElement(ResourceResolver resolver, InputStream ... files) throws Exception {
        Document document = XmlUtils.newDocument();
        Element root = document.createElement(FORMSET_ELEMENT);
        document.appendChild(root);
        for (InputStream file : files) {
            Document documentParsed = XmlUtils.parse(file);
            Element formSet = XmlUtils.getChildNamed(documentParsed.getDocumentElement(), new String[]{FORMSET_ELEMENT});
            if (formSet == null) continue;
            XmlUtils.combineElements(root, formSet, this.getTopLevelTypeAttribute(), this.getNameAttribute());
        }
        return root;
    }

    @Override
    protected Map<String, String> inspectProperty(Element toInspect) {
        if (!FIELD_ELEMENT.equals(toInspect.getNodeName())) {
            return null;
        }
        HashMap<String, String> attributes = CollectionUtils.newHashMap();
        String name = toInspect.getAttribute(this.getNameAttribute());
        attributes.put("name", name);
        if (toInspect.hasAttribute("depends")) {
            StringTokenizer tokenizer = new StringTokenizer(toInspect.getAttribute("depends"), ",");
            Element firstVar = XmlUtils.getChildNamed(toInspect, new String[]{"var"});
            while (tokenizer.hasMoreTokens()) {
                String depends = tokenizer.nextToken();
                if ("required".equals(depends)) {
                    attributes.put("required", "true");
                }
                if ("intRange".equals(depends) || "floatRange".equals(depends) || "doubleRange".equals(depends)) {
                    String max;
                    String min = this.getVarValue(firstVar, "min");
                    if (min != null) {
                        attributes.put("minimum-value", min);
                    }
                    if ((max = this.getVarValue(firstVar, "max")) != null) {
                        attributes.put("maximum-value", max);
                    }
                    if (min == null && max == null) {
                        throw InspectorException.newException("Property '" + name + "' depends on " + depends + " but has no var-name of min or max");
                    }
                }
                if ("minlength".equals(depends)) {
                    attributes.put("minimum-length", this.getVarValue(firstVar, "minlength", name, depends));
                }
                if (!"maxlength".equals(depends)) continue;
                attributes.put("maximum-length", this.getVarValue(firstVar, "maxlength", name, depends));
            }
        }
        return attributes;
    }

    @Override
    protected String getTopLevelTypeAttribute() {
        return "name";
    }

    @Override
    protected String getNameAttribute() {
        return "property";
    }

    private String getVarValue(Element firstVar, String varName, String propertyName, String depend) {
        String varValue = this.getVarValue(firstVar, varName);
        if (varValue == null) {
            throw InspectorException.newException("Property '" + propertyName + "' depends on " + depend + " but has no var-name of " + varName);
        }
        return varValue;
    }

    private String getVarValue(Element firstVar, String varName) {
        Element var = firstVar;
        while (var != null) {
            Element varNameElement = XmlUtils.getChildNamed(var, new String[]{"var-name"});
            if (varName.equals(varNameElement.getTextContent())) {
                Element varValueElement = XmlUtils.getChildNamed(var, new String[]{"var-value"});
                if (varValueElement == null) {
                    throw InspectorException.newException("Variable named '" + varName + "' has no var-value");
                }
                return varValueElement.getTextContent();
            }
            var = XmlUtils.getSiblingNamed(var, "var");
        }
        return null;
    }
}

