/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.faces;

import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.metawidget.faces.FacesUtils;
import org.metawidget.inspector.faces.FacesInspectorConfig;
import org.metawidget.inspector.faces.UiFacesAjax;
import org.metawidget.inspector.faces.UiFacesAttribute;
import org.metawidget.inspector.faces.UiFacesAttributes;
import org.metawidget.inspector.faces.UiFacesComponent;
import org.metawidget.inspector.faces.UiFacesConverter;
import org.metawidget.inspector.faces.UiFacesDateTimeConverter;
import org.metawidget.inspector.faces.UiFacesLookup;
import org.metawidget.inspector.faces.UiFacesNumberConverter;
import org.metawidget.inspector.faces.UiFacesSuggest;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.BaseObjectInspector;
import org.metawidget.inspector.impl.Trait;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.InspectorUtils;
import org.metawidget.util.simple.StringUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesInspector
extends BaseObjectInspector {
    private static final String THIS_ATTRIBUTE = "this";
    private static final String UNDERSCORE_THIS_ATTRIBUTE = "_this";
    private boolean mInjectThis;

    public FacesInspector() {
        this(new FacesInspectorConfig());
    }

    public FacesInspector(FacesInspectorConfig config) {
        super(config);
        this.mInjectThis = config.isInjectThis();
    }

    @Override
    protected Map<String, String> inspectParent(Object parentToInspect, Property propertyInParent) throws Exception {
        if (this.mInjectThis) {
            Map requestMap = FacesContext.getCurrentInstance().getExternalContext().getRequestMap();
            requestMap.put(THIS_ATTRIBUTE, parentToInspect);
            requestMap.put(UNDERSCORE_THIS_ATTRIBUTE, parentToInspect);
        }
        return super.inspectParent(parentToInspect, propertyInParent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void inspect(Object toInspect, Class<?> classToInspect, Element toAddTo) throws Exception {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context == null) {
            throw InspectorException.newException("FacesContext not available to FacesInspector");
        }
        Map requestMap = context.getExternalContext().getRequestMap();
        try {
            if (this.mInjectThis) {
                requestMap.put(THIS_ATTRIBUTE, toInspect);
                requestMap.put(UNDERSCORE_THIS_ATTRIBUTE, toInspect);
            }
            super.inspect(toInspect, classToInspect, toAddTo);
        }
        finally {
            if (this.mInjectThis) {
                requestMap.remove(THIS_ATTRIBUTE);
                requestMap.remove(UNDERSCORE_THIS_ATTRIBUTE);
            }
        }
    }

    @Override
    protected Map<String, String> inspectTrait(Trait trait) throws Exception {
        HashMap<String, String> attributes = CollectionUtils.newHashMap();
        UiFacesAttributes facesAttributes = trait.getAnnotation(UiFacesAttributes.class);
        UiFacesAttribute facesAttribute = trait.getAnnotation(UiFacesAttribute.class);
        if (facesAttributes == null && facesAttribute == null) {
            return null;
        }
        if (facesAttribute != null) {
            this.evaluateAndPutExpression(attributes, facesAttribute);
        }
        if (facesAttributes != null) {
            for (UiFacesAttribute nestedFacesAttribute : facesAttributes.value()) {
                this.evaluateAndPutExpression(attributes, nestedFacesAttribute);
            }
        }
        return attributes;
    }

    @Override
    protected Map<String, String> inspectProperty(Property property) throws Exception {
        UiFacesDateTimeConverter dateTimeConverter;
        UiFacesNumberConverter numberConverter;
        UiFacesConverter converter;
        UiFacesAjax ajax;
        UiFacesComponent component;
        UiFacesSuggest facesSuggest;
        HashMap<String, String> attributes = CollectionUtils.newHashMap();
        UiFacesLookup facesLookup = property.getAnnotation(UiFacesLookup.class);
        if (facesLookup != null) {
            this.putExpression(attributes, "faces-lookup", facesLookup.value());
        }
        if ((facesSuggest = property.getAnnotation(UiFacesSuggest.class)) != null) {
            this.putExpression(attributes, "faces-suggest", facesSuggest.value());
        }
        if ((component = property.getAnnotation(UiFacesComponent.class)) != null) {
            attributes.put("faces-component", component.value());
        }
        if ((ajax = property.getAnnotation(UiFacesAjax.class)) != null) {
            attributes.put("faces-ajax-event", ajax.event());
            this.putExpression(attributes, "faces-ajax-action", ajax.action());
        }
        if ((converter = property.getAnnotation(UiFacesConverter.class)) != null) {
            attributes.put("faces-converter-id", converter.value());
        }
        if ((numberConverter = property.getAnnotation(UiFacesNumberConverter.class)) != null) {
            if (!"".equals(numberConverter.currencyCode())) {
                attributes.put("currency-code", numberConverter.currencyCode());
            }
            if (!"".equals(numberConverter.currencySymbol())) {
                attributes.put("currency-symbol", numberConverter.currencySymbol());
            }
            if (numberConverter.groupingUsed()) {
                attributes.put("number-uses-grouping-separators", "true");
            }
            if (numberConverter.minIntegerDigits() != -1) {
                attributes.put("minimum-integer-digits", String.valueOf(numberConverter.minIntegerDigits()));
            }
            if (numberConverter.maxIntegerDigits() != -1) {
                attributes.put("maximum-integer-digits", String.valueOf(numberConverter.maxIntegerDigits()));
            }
            if (numberConverter.minFractionDigits() != -1) {
                attributes.put("minimum-fractional-digits", String.valueOf(numberConverter.minFractionDigits()));
            }
            if (numberConverter.maxFractionDigits() != -1) {
                attributes.put("maximum-fractional-digits", String.valueOf(numberConverter.maxFractionDigits()));
            }
            if (!"".equals(numberConverter.locale())) {
                attributes.put("locale", numberConverter.locale());
            }
            if (!"".equals(numberConverter.pattern())) {
                attributes.put("number-pattern", numberConverter.pattern());
            }
            if (!"".equals(numberConverter.type())) {
                attributes.put("number-type", numberConverter.type());
            }
        }
        if ((dateTimeConverter = property.getAnnotation(UiFacesDateTimeConverter.class)) != null) {
            if (!"".equals(dateTimeConverter.dateStyle())) {
                attributes.put("date-style", dateTimeConverter.dateStyle());
            }
            if (!"".equals(dateTimeConverter.locale())) {
                attributes.put("locale", dateTimeConverter.locale());
            }
            if (!"".equals(dateTimeConverter.pattern())) {
                attributes.put("datetime-pattern", dateTimeConverter.pattern());
            }
            if (!"".equals(dateTimeConverter.timeStyle())) {
                attributes.put("time-style", dateTimeConverter.timeStyle());
            }
            if (!"".equals(dateTimeConverter.timeZone())) {
                attributes.put("time-zone", dateTimeConverter.timeZone());
            }
            if (!"".equals(dateTimeConverter.type())) {
                attributes.put("datetime-type", dateTimeConverter.type());
            }
        }
        return attributes;
    }

    private void putExpression(Map<String, String> attributes, String attributeName, String expression) {
        if ("".equals(expression)) {
            return;
        }
        if (!FacesUtils.isExpression(expression)) {
            throw InspectorException.newException("Expression '" + expression + "' (for '" + attributeName + "') is not of the form #{...}");
        }
        if (this.mInjectThis) {
            String unwrappedExpression = FacesUtils.unwrapExpression(expression);
            if (unwrappedExpression.startsWith(THIS_ATTRIBUTE + StringUtils.SEPARATOR_DOT)) {
                throw InspectorException.newException("Expression '" + expression + "' (for '" + attributeName + "') must not contain '" + THIS_ATTRIBUTE + "' (see Metawidget Reference Guide)");
            }
            if (unwrappedExpression.startsWith(UNDERSCORE_THIS_ATTRIBUTE + StringUtils.SEPARATOR_DOT)) {
                throw InspectorException.newException("Expression '" + expression + "' (for '" + attributeName + "') must not contain '" + UNDERSCORE_THIS_ATTRIBUTE + "' (see Metawidget Reference Guide)");
            }
        }
        attributes.put(attributeName, expression);
    }

    private void evaluateAndPutExpression(Map<String, String> attributes, UiFacesAttribute facesAttribute) {
        Object value;
        String expression = facesAttribute.expression();
        if ("".equals(expression)) {
            return;
        }
        if (!FacesUtils.isExpression(expression)) {
            throw InspectorException.newException("Expression '" + expression + "' is not of the form #{...}");
        }
        if (!this.mInjectThis) {
            String unwrappedExpression = FacesUtils.unwrapExpression(expression);
            if (unwrappedExpression.startsWith(THIS_ATTRIBUTE + StringUtils.SEPARATOR_DOT)) {
                throw InspectorException.newException("Expression for '" + expression + "' contains '" + THIS_ATTRIBUTE + "', but " + FacesInspectorConfig.class.getSimpleName() + ".setInjectThis is 'false'");
            }
            if (unwrappedExpression.startsWith(UNDERSCORE_THIS_ATTRIBUTE + StringUtils.SEPARATOR_DOT)) {
                throw InspectorException.newException("Expression for '" + expression + "' contains '" + UNDERSCORE_THIS_ATTRIBUTE + "', but " + FacesInspectorConfig.class.getSimpleName() + ".setInjectThis is 'false'");
            }
        }
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            value = context.getApplication().createValueBinding(expression).getValue(context);
        }
        catch (Exception e) {
            throw InspectorException.newException("Unable to getValue of " + expression, e);
        }
        if (value == null) {
            return;
        }
        for (String attributeName : facesAttribute.name()) {
            InspectorUtils.putAttributeValue(attributes, attributeName, value);
        }
    }
}

