/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.faces;

import java.util.Map;
import javax.faces.context.FacesContext;
import org.metawidget.faces.FacesUtils;
import org.metawidget.inspector.faces.FacesXmlInspectorConfig;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.BaseXmlInspector;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.XmlUtils;
import org.metawidget.util.simple.StringUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesXmlInspector
extends BaseXmlInspector {
    private static final String THIS_ATTRIBUTE = "this";
    private static final String UNDERSCORE_THIS_ATTRIBUTE = "_this";
    private boolean mInjectThis;
    static /* synthetic */ Class class$org$metawidget$inspector$faces$FacesXmlInspectorConfig;

    public FacesXmlInspector(FacesXmlInspectorConfig facesXmlInspectorConfig) {
        super(facesXmlInspectorConfig);
        this.mInjectThis = facesXmlInspectorConfig.isInjectThis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element inspectAsDom(Object object, String string, String[] stringArray) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            throw InspectorException.newException("FacesContext not available to FacesXmlInspector");
        }
        Map map = facesContext.getExternalContext().getRequestMap();
        try {
            if (this.mInjectThis) {
                map.put(THIS_ATTRIBUTE, object);
                map.put(UNDERSCORE_THIS_ATTRIBUTE, object);
            }
            Element element = super.inspectAsDom(object, string, stringArray);
            return element;
        }
        finally {
            if (this.mInjectThis) {
                map.remove(THIS_ATTRIBUTE);
                map.remove(UNDERSCORE_THIS_ATTRIBUTE);
            }
        }
    }

    @Override
    protected Map<String, String> inspectProperty(Element element) {
        if ("property".equals(element.getNodeName())) {
            return this.inspect(element);
        }
        return null;
    }

    @Override
    protected Map<String, String> inspectAction(Element element) {
        if ("action".equals(element.getNodeName())) {
            return this.inspect(element);
        }
        return null;
    }

    private Map<String, String> inspect(Element element) {
        Map<String, String> map = XmlUtils.getAttributesAsMap(element);
        for (Map.Entry<String, String> entry : CollectionUtils.newArrayList(map.entrySet())) {
            String string;
            String string2 = entry.getKey();
            String string3 = entry.getValue();
            if ("faces-lookup".equals(string2) || "faces-suggest".equals(string2) || "faces-expression".equals(string2) || "faces-ajax-action".equals(string2)) {
                if (!this.mInjectThis) continue;
                string = FacesUtils.unwrapExpression(string3);
                if (string.startsWith(new StringBuffer().append(THIS_ATTRIBUTE).append(StringUtils.SEPARATOR_DOT).toString())) {
                    throw InspectorException.newException(new StringBuffer().append("Expression '").append(string3).append("' (for '").append(string2).append("') must not contain '").append(THIS_ATTRIBUTE).append("' (see Metawidget Reference Guide)").toString());
                }
                if (!string.startsWith(new StringBuffer().append(UNDERSCORE_THIS_ATTRIBUTE).append(StringUtils.SEPARATOR_DOT).toString())) continue;
                throw InspectorException.newException(new StringBuffer().append("Expression '").append(string3).append("' (for '").append(string2).append("') must not contain '").append(UNDERSCORE_THIS_ATTRIBUTE).append("' (see Metawidget Reference Guide)").toString());
            }
            if (!FacesUtils.isExpression(string3)) continue;
            if (!this.mInjectThis) {
                string = FacesUtils.unwrapExpression(string3);
                if (string.startsWith(new StringBuffer().append(THIS_ATTRIBUTE).append(StringUtils.SEPARATOR_DOT).toString())) {
                    throw InspectorException.newException(new StringBuffer().append("Expression for '").append(string3).append("' contains '").append(THIS_ATTRIBUTE).append("', but ").append((class$org$metawidget$inspector$faces$FacesXmlInspectorConfig == null ? (class$org$metawidget$inspector$faces$FacesXmlInspectorConfig = FacesXmlInspector.class$("org.metawidget.inspector.faces.FacesXmlInspectorConfig")) : class$org$metawidget$inspector$faces$FacesXmlInspectorConfig).getSimpleName()).append(".setInjectThis is 'false'").toString());
                }
                if (string.startsWith(new StringBuffer().append(UNDERSCORE_THIS_ATTRIBUTE).append(StringUtils.SEPARATOR_DOT).toString())) {
                    throw InspectorException.newException(new StringBuffer().append("Expression for '").append(string3).append("' contains '").append(UNDERSCORE_THIS_ATTRIBUTE).append("', but ").append((class$org$metawidget$inspector$faces$FacesXmlInspectorConfig == null ? (class$org$metawidget$inspector$faces$FacesXmlInspectorConfig = FacesXmlInspector.class$("org.metawidget.inspector.faces.FacesXmlInspectorConfig")) : class$org$metawidget$inspector$faces$FacesXmlInspectorConfig).getSimpleName()).append(".setInjectThis is 'false'").toString());
                }
            }
            try {
                string = FacesContext.getCurrentInstance();
                string3 = StringUtils.quietValueOf(string.getApplication().createValueBinding(string3).getValue((FacesContext)string));
            }
            catch (Exception exception) {
                throw InspectorException.newException(new StringBuffer().append("Unable to getValue of ").append(string3).toString(), exception);
            }
            map.put(string2, string3);
        }
        return map;
    }

    @Override
    public /* synthetic */ Object inspectAsDom(Object object, String string, String[] stringArray) {
        return this.inspectAsDom(object, string, stringArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

