/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl;

import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import org.metawidget.config.ResourceResolver;
import org.metawidget.inspector.iface.DomInspector;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.BaseXmlInspectorConfig;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.inspector.impl.propertystyle.PropertyStyle;
import org.metawidget.util.ArrayUtils;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.LogUtils;
import org.metawidget.util.XmlUtils;
import org.metawidget.util.simple.SimpleClassUtils;
import org.metawidget.util.simple.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseXmlInspector
implements DomInspector<Element> {
    protected LogUtils.Log mLog = LogUtils.getLog(this.getClass());
    protected Element mRoot;
    private final PropertyStyle mRestrictAgainstObject;

    protected BaseXmlInspector(BaseXmlInspectorConfig config) {
        try {
            InputStream[] files = config.getInputStreams();
            if (files != null && files.length > 0) {
                this.mRoot = this.getDocumentElement(config.getResourceResolver(), config.getInputStreams());
            }
            if (this.mRoot == null) {
                throw InspectorException.newException("No XML input file specified");
            }
            if (this.mLog.isTraceEnabled()) {
                this.mLog.trace(XmlUtils.documentToString(this.mRoot.getOwnerDocument(), false), new Object[0]);
            }
            this.mRestrictAgainstObject = config.getRestrictAgainstObject();
        }
        catch (Exception e) {
            throw InspectorException.newException(e);
        }
    }

    @Override
    public final String inspect(Object toInspect, String type, String[] names) {
        Element element = this.inspectAsDom(toInspect, type, names);
        if (element == null) {
            return null;
        }
        return XmlUtils.nodeToString((Node)element, false);
    }

    @Override
    public Element inspectAsDom(Object toInspect, String type, String[] names) {
        if (type == null) {
            return null;
        }
        if (this.mRestrictAgainstObject != null && this.isRestrictedAgainstObject(toInspect, type, names)) {
            return null;
        }
        try {
            Element elementToInspect = null;
            Map<String, String> parentAttributes = null;
            if (names != null && names.length > 0) {
                Element propertyInParent = this.traverse(type, true, names);
                if (propertyInParent == null) {
                    return null;
                }
                parentAttributes = this.inspectProperty(propertyInParent);
                String typeAttribute = this.getTypeAttribute();
                if (!propertyInParent.hasAttribute(typeAttribute)) {
                    throw InspectorException.newException(new StringBuffer().append("Property ").append(names[names.length - 1]).append(" has no @").append(typeAttribute).append(" attribute in the XML, so cannot navigate to ").append(type).append(ArrayUtils.toString(names, StringUtils.SEPARATOR_DOT, true, false)).toString());
                }
                elementToInspect = this.traverse(propertyInParent.getAttribute(typeAttribute), false, new String[0]);
            } else {
                elementToInspect = this.traverse(type, false, names);
                if (elementToInspect == null) {
                    return null;
                }
            }
            Document document = XmlUtils.newDocument();
            Element entity = document.createElementNS("http://metawidget.org/inspection-result", "entity");
            this.inspect(elementToInspect, entity);
            if (!entity.hasChildNodes() && (parentAttributes == null || parentAttributes.isEmpty())) {
                return null;
            }
            Element root = document.createElementNS("http://metawidget.org/inspection-result", "inspection-result");
            root.setAttribute("version", "1.0");
            document.appendChild(root);
            root.appendChild(entity);
            if (parentAttributes == null) {
                entity.setAttribute("type", type);
            } else {
                XmlUtils.setMapAsAttributes(entity, parentAttributes);
            }
            return root;
        }
        catch (Exception e) {
            throw InspectorException.newException(e);
        }
    }

    protected Element getDocumentElement(ResourceResolver resolver, InputStream[] files) throws Exception {
        Document documentMaster = null;
        for (InputStream file : files) {
            Document documentParsed = XmlUtils.parse(file);
            if (!documentParsed.hasChildNodes()) continue;
            this.preprocessDocument(documentParsed);
            if (documentMaster == null || !documentMaster.hasChildNodes()) {
                documentMaster = documentParsed;
                continue;
            }
            XmlUtils.combineElements(documentMaster.getDocumentElement(), documentParsed.getDocumentElement(), this.getTopLevelTypeAttribute(), this.getNameAttribute());
        }
        if (documentMaster == null) {
            return null;
        }
        return documentMaster.getDocumentElement();
    }

    protected void preprocessDocument(Document document) {
    }

    protected void inspect(Element toInspect, Element toAddTo) {
        if (toInspect == null) {
            return;
        }
        Document document = toAddTo.getOwnerDocument();
        String extendsAttribute = this.getExtendsAttribute();
        if (extendsAttribute != null && toInspect.hasAttribute(extendsAttribute)) {
            this.inspect(this.traverse(toInspect.getAttribute(extendsAttribute), false, new String[0]), toAddTo);
        }
        Element element = document.createElementNS("http://metawidget.org/inspection-result", "entity");
        NodeList children = toInspect.getChildNodes();
        int length = children.getLength();
        for (int loop = 0; loop < length; ++loop) {
            Element inspected;
            Node child = children.item(loop);
            if (!(child instanceof Element) || (inspected = this.inspect(document, (Element)child)) == null) continue;
            element.appendChild(inspected);
        }
        XmlUtils.combineElements(toAddTo, element, "name", "name");
    }

    protected Element inspect(Document toAddTo, Element toInspect) {
        Map<String, String> propertyAttributes = this.inspectProperty(toInspect);
        if (propertyAttributes != null && !propertyAttributes.isEmpty()) {
            Element child = toAddTo.createElementNS("http://metawidget.org/inspection-result", "property");
            XmlUtils.setMapAsAttributes(child, propertyAttributes);
            return child;
        }
        Map<String, String> actionAttributes = this.inspectAction(toInspect);
        if (actionAttributes != null && !actionAttributes.isEmpty()) {
            if (propertyAttributes != null) {
                throw InspectorException.newException(new StringBuffer().append("Ambigious match: ").append(toInspect.getNodeName()).append(" matches as both a property and an action").toString());
            }
            Element child = toAddTo.createElementNS("http://metawidget.org/inspection-result", "action");
            XmlUtils.setMapAsAttributes(child, actionAttributes);
            return child;
        }
        return null;
    }

    protected Map<String, String> inspectProperty(Element toInspect) {
        return null;
    }

    protected Map<String, String> inspectAction(Element toInspect) {
        return null;
    }

    protected Element traverse(String type, boolean onlyToParent, String[] names) {
        String topLevelTypeAttribute = this.getTopLevelTypeAttribute();
        Element entityElement = XmlUtils.getChildWithAttributeValue(this.mRoot, topLevelTypeAttribute, type);
        if (entityElement == null) {
            return null;
        }
        if (names == null) {
            return entityElement;
        }
        int length = names.length;
        if (length == 0) {
            return entityElement;
        }
        String extendsAttribute = this.getExtendsAttribute();
        String nameAttribute = this.getNameAttribute();
        String typeAttribute = this.getTypeAttribute();
        for (int loop = 0; loop < length; ++loop) {
            String name = names[loop];
            Element property = XmlUtils.getChildWithAttributeValue(entityElement, nameAttribute, name);
            if (property == null) {
                if (extendsAttribute == null) {
                    return null;
                }
                do {
                    if (!entityElement.hasAttribute(extendsAttribute)) {
                        return null;
                    }
                    String childExtends = entityElement.getAttribute(extendsAttribute);
                    if ((entityElement = XmlUtils.getChildWithAttributeValue(this.mRoot, topLevelTypeAttribute, childExtends)) != null) continue;
                    return null;
                } while ((property = XmlUtils.getChildWithAttributeValue(entityElement, nameAttribute, name)) == null);
                if (property == null) {
                    throw new NullPointerException("property");
                }
            }
            if (onlyToParent && loop >= length - 1) {
                return property;
            }
            if (!property.hasAttribute(typeAttribute)) {
                throw InspectorException.newException(new StringBuffer().append("Property ").append(name).append(" in entity ").append(entityElement.getAttribute(typeAttribute)).append(" has no @").append(typeAttribute).append(" attribute in the XML, so cannot navigate to ").append(type).append(ArrayUtils.toString(names, StringUtils.SEPARATOR_DOT, true, false)).toString());
            }
            String propertyType = property.getAttribute(typeAttribute);
            entityElement = XmlUtils.getChildWithAttributeValue(this.mRoot, topLevelTypeAttribute, propertyType);
            if (entityElement == null) break;
        }
        return entityElement;
    }

    protected String getTopLevelTypeAttribute() {
        return "type";
    }

    protected String getNameAttribute() {
        return "name";
    }

    protected String getTypeAttribute() {
        return "type";
    }

    protected String getExtendsAttribute() {
        return null;
    }

    private boolean isRestrictedAgainstObject(Object toTraverse, String type, String[] names) {
        if (toTraverse == null) {
            if (names != null && names.length > 0) {
                return true;
            }
            Class<?> clazz = ClassUtils.niceForName(type);
            if (clazz == null) {
                return false;
            }
            return false;
        }
        Class<?> traverseDeclaredType = ClassUtils.niceForName(type, toTraverse.getClass().getClassLoader());
        if (traverseDeclaredType == null || !traverseDeclaredType.isAssignableFrom(toTraverse.getClass())) {
            return false;
        }
        Object traverse = toTraverse;
        if (names != null && names.length > 0) {
            HashSet traversed = CollectionUtils.newHashSet();
            traversed.add(traverse);
            int length = names.length;
            for (int loop = 0; loop < length; ++loop) {
                String name = names[loop];
                Property property = this.mRestrictAgainstObject.getProperties(traverse.getClass()).get(name);
                if (property == null || !property.isReadable()) {
                    return true;
                }
                if (!traversed.add(traverse = property.read(traverse))) {
                    this.mLog.trace("{0} prevented infinite recursion on {1}{2}. Consider marking {3} as hidden=''true''", new Object[]{SimpleClassUtils.getSimpleName(this.getClass()), type, ArrayUtils.toString(names, StringUtils.SEPARATOR_FORWARD_SLASH, true, false), name});
                    return true;
                }
                if (traverse == null) {
                    return true;
                }
                traverseDeclaredType = property.getType();
            }
        }
        return false;
    }

    @Override
    public /* synthetic */ Object inspectAsDom(Object x0, String x1, String[] x2) {
        return this.inspectAsDom(x0, x1, x2);
    }
}

