/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl.propertystyle;

import java.util.regex.Pattern;
import org.metawidget.util.simple.ObjectUtils;

public class BasePropertyStyleConfig {
    private static Pattern DEFAULT_EXCLUDE_BASE_TYPE;
    private boolean mCacheProperties = true;
    private Pattern mExcludeBaseType;
    private boolean mNullExcludeBaseType;

    public BasePropertyStyleConfig setCacheProperties(boolean cacheProperties) {
        this.mCacheProperties = cacheProperties;
        return this;
    }

    public BasePropertyStyleConfig setExcludeBaseType(Pattern excludeBaseType) {
        this.mExcludeBaseType = excludeBaseType;
        if (excludeBaseType == null) {
            this.mNullExcludeBaseType = true;
        }
        return this;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.getClass() != that.getClass()) {
            return false;
        }
        if (this.mCacheProperties != ((BasePropertyStyleConfig)that).mCacheProperties) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mExcludeBaseType, ((BasePropertyStyleConfig)that).mExcludeBaseType)) {
            return false;
        }
        return this.mNullExcludeBaseType == ((BasePropertyStyleConfig)that).mNullExcludeBaseType;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(new Boolean(this.mCacheProperties));
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.mExcludeBaseType);
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(new Boolean(this.mNullExcludeBaseType));
        return hashCode;
    }

    protected boolean isCacheProperties() {
        return this.mCacheProperties;
    }

    protected Pattern getExcludeBaseType() {
        if (this.mExcludeBaseType == null && !this.mNullExcludeBaseType) {
            if (DEFAULT_EXCLUDE_BASE_TYPE == null) {
                DEFAULT_EXCLUDE_BASE_TYPE = Pattern.compile("^(java|javax)\\..*$");
            }
            return DEFAULT_EXCLUDE_BASE_TYPE;
        }
        return this.mExcludeBaseType;
    }
}

