/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.struts;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.metawidget.config.ResourceResolver;
import org.metawidget.inspector.impl.BaseXmlInspector;
import org.metawidget.inspector.struts.StrutsInspectorConfig;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrutsInspector
extends BaseXmlInspector {
    private static final String FORM_BEANS_ELEMENT = "form-beans";
    private static final String FORM_PROPERTY_ELEMENT = "form-property";

    public StrutsInspector(StrutsInspectorConfig strutsInspectorConfig) {
        super(strutsInspectorConfig);
    }

    @Override
    protected Element getDocumentElement(ResourceResolver resourceResolver, InputStream[] inputStreamArray) throws Exception {
        Document document = XmlUtils.newDocument();
        Element element = document.createElement(FORM_BEANS_ELEMENT);
        document.appendChild(element);
        for (InputStream inputStream : inputStreamArray) {
            Document document2 = XmlUtils.parse(inputStream);
            Element element2 = XmlUtils.getChildNamed(document2.getDocumentElement(), new String[]{FORM_BEANS_ELEMENT});
            if (element2 == null) continue;
            XmlUtils.combineElements(element, element2, this.getTopLevelTypeAttribute(), this.getNameAttribute());
        }
        return element;
    }

    @Override
    protected Map<String, String> inspectProperty(Element element) {
        if (!FORM_PROPERTY_ELEMENT.equals(element.getNodeName())) {
            return null;
        }
        HashMap<String, String> hashMap = CollectionUtils.newHashMap();
        if (element.hasAttribute(this.getNameAttribute())) {
            hashMap.put("name", element.getAttribute(this.getNameAttribute()));
        }
        if (element.hasAttribute(this.getTypeAttribute())) {
            hashMap.put("type", element.getAttribute(this.getTypeAttribute()));
        }
        return hashMap;
    }

    @Override
    protected String getTopLevelTypeAttribute() {
        return "name";
    }
}

