/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swing.layout;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.metawidget.layout.iface.AdvancedLayout;
import org.metawidget.swing.Facet;
import org.metawidget.swing.Stub;
import org.metawidget.swing.SwingMetawidget;
import org.metawidget.swing.layout.GridBagLayoutConfig;
import org.metawidget.util.simple.Pair;
import org.metawidget.util.simple.SimpleLayoutUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridBagLayout
implements AdvancedLayout<JComponent, JComponent, SwingMetawidget> {
    private static final int SMALL_GAP = 3;
    private static final Insets INSETS_COMPONENT = new Insets(0, 0, 3, 0);
    private static final String LABEL_NAME_SUFFIX = "_label";
    private final int mNumberOfColumns;
    private final int mLabelAlignment;
    private final Font mLabelFont;
    private final Color mLabelForeground;
    private final boolean mSupportMnemonics;
    private final String mLabelSuffix;
    private final int mRequiredAlignment;
    private final String mRequiredText;
    static /* synthetic */ Class class$org$metawidget$swing$layout$GridBagLayout;

    public GridBagLayout() {
        this(new GridBagLayoutConfig());
    }

    public GridBagLayout(GridBagLayoutConfig gridBagLayoutConfig) {
        this.mNumberOfColumns = gridBagLayoutConfig.getNumberOfColumns();
        this.mLabelAlignment = gridBagLayoutConfig.getLabelAlignment();
        this.mLabelForeground = gridBagLayoutConfig.getLabelForeground();
        this.mLabelFont = gridBagLayoutConfig.getLabelFont();
        this.mSupportMnemonics = gridBagLayoutConfig.isSupportMnemonics();
        this.mLabelSuffix = gridBagLayoutConfig.getLabelSuffix();
        this.mRequiredAlignment = gridBagLayoutConfig.getRequiredAlignment();
        this.mRequiredText = gridBagLayoutConfig.getRequiredText();
    }

    @Override
    public void onStartBuild(SwingMetawidget swingMetawidget) {
    }

    @Override
    public void startContainerLayout(JComponent jComponent, SwingMetawidget swingMetawidget) {
        jComponent.putClientProperty(class$org$metawidget$swing$layout$GridBagLayout == null ? (class$org$metawidget$swing$layout$GridBagLayout = GridBagLayout.class$("org.metawidget.swing.layout.GridBagLayout")) : class$org$metawidget$swing$layout$GridBagLayout, null);
        State state = this.getState(jComponent);
        java.awt.GridBagLayout gridBagLayout = new java.awt.GridBagLayout();
        jComponent.setLayout(gridBagLayout);
        JTextField jTextField = new JTextField();
        jTextField.setLayout(gridBagLayout);
        double d = jTextField.getPreferredSize().getHeight();
        JLabel jLabel = new JLabel("X");
        jLabel.setLayout(gridBagLayout);
        double d2 = jLabel.getPreferredSize().getHeight();
        int n = (int)Math.max(0.0, Math.floor((d - d2) / 2.0));
        state.defaultLabelInsetsFirstColumn = new Insets(n, 0, n, 3);
        state.defaultLabelInsetsRemainderColumns = new Insets(n, 3, n, 3);
    }

    @Override
    public void layoutWidget(JComponent jComponent, String string, Map<String, String> map, JComponent jComponent2, SwingMetawidget swingMetawidget) {
        if (jComponent instanceof Stub && ((Stub)jComponent).getComponentCount() == 0) {
            return;
        }
        State state = this.getState(jComponent2);
        boolean bl = this.willFillHorizontally(jComponent, map);
        if (bl && state.currentColumn > 0) {
            state.currentColumn = 0;
            ++state.currentRow;
        }
        String string2 = null;
        if (map != null) {
            string2 = swingMetawidget.getLabelString(map);
        }
        this.layoutBeforeChild(jComponent, string2, string, map, jComponent2, swingMetawidget);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setFillConstraints(jComponent, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = state.currentColumn * (this.mRequiredAlignment == 4 ? 3 : 2);
        if (string2 != null) {
            ++gridBagConstraints.gridx;
        } else {
            gridBagConstraints.gridwidth = 2;
        }
        int n = this.getEffectiveNumberOfColumns(swingMetawidget);
        gridBagConstraints.gridy = state.currentRow;
        gridBagConstraints.weightx = 1.0f / (float)n;
        gridBagConstraints.insets = INSETS_COMPONENT;
        if (bl) {
            gridBagConstraints.gridwidth = this.mRequiredAlignment == 4 ? n * 3 - gridBagConstraints.gridx - 1 : 0;
            state.currentColumn = n - 1;
        }
        if (this.willFillVertically(jComponent, map)) {
            gridBagConstraints.weighty = 1.0;
            state.needSpacerRow = false;
        }
        jComponent2.add((Component)jComponent, gridBagConstraints);
        this.layoutAfterChild(jComponent, map, jComponent2, swingMetawidget);
        ++state.currentColumn;
        if (state.currentColumn >= n) {
            state.currentColumn = 0;
            ++state.currentRow;
        }
    }

    @Override
    public void endContainerLayout(JComponent jComponent, SwingMetawidget swingMetawidget) {
        State state = this.getState(jComponent);
        if (state.needSpacerRow) {
            if (state.currentColumn > 0) {
                state.currentColumn = 0;
                ++state.currentRow;
            }
            JPanel jPanel = new JPanel();
            jPanel.setOpaque(false);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = state.currentRow;
            gridBagConstraints.weighty = 1.0;
            jComponent.add((Component)jPanel, gridBagConstraints);
            state.currentColumn = this.mNumberOfColumns;
        }
    }

    @Override
    public void onEndBuild(SwingMetawidget swingMetawidget) {
        Facet facet = swingMetawidget.getFacet("buttons");
        if (facet != null) {
            State state = this.getState(swingMetawidget);
            if (state.currentColumn > 0) {
                state.currentColumn = 0;
                ++state.currentRow;
            }
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = state.currentRow;
            gridBagConstraints.gridwidth = 0;
            swingMetawidget.add((Component)facet, gridBagConstraints);
        }
    }

    protected void layoutBeforeChild(JComponent jComponent, String string, String string2, Map<String, String> map, JComponent jComponent2, SwingMetawidget swingMetawidget) {
        State state = this.getState(jComponent2);
        if (SimpleLayoutUtils.needsLabel(string, string2)) {
            JLabel jLabel = new JLabel();
            jLabel.setName(new StringBuffer().append(map.get("name")).append(LABEL_NAME_SUFFIX).toString());
            if (this.mLabelFont != null) {
                jLabel.setFont(this.mLabelFont);
            }
            if (this.mLabelForeground != null) {
                jLabel.setForeground(this.mLabelForeground);
            }
            jLabel.setHorizontalAlignment(this.mLabelAlignment);
            Pair<String, Integer> pair = SimpleLayoutUtils.stripMnemonic(string);
            String string3 = pair.getLeft();
            if (this.mRequiredText != null && "true".equals(map.get("required")) && !"true".equals(map.get("read-only")) && !swingMetawidget.isReadOnly()) {
                if (this.mRequiredAlignment == 0) {
                    string3 = new StringBuffer().append(string3).append(this.mRequiredText).toString();
                } else if (this.mRequiredAlignment == 2) {
                    string3 = new StringBuffer().append(this.mRequiredText).append(string3).toString();
                }
            }
            if (this.mLabelSuffix != null) {
                string3 = new StringBuffer().append(string3).append(this.mLabelSuffix).toString();
            }
            jLabel.setText(string3);
            jLabel.setLabelFor(jComponent);
            int n = pair.getRight();
            if (n != -1 && this.mSupportMnemonics) {
                jLabel.setDisplayedMnemonic(string3.charAt(n));
                jLabel.setDisplayedMnemonicIndex(n);
            }
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = state.currentColumn * (this.mRequiredAlignment == 4 ? 3 : 2);
            gridBagConstraints.gridy = state.currentRow;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.1f / (float)this.getEffectiveNumberOfColumns(swingMetawidget);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = state.currentColumn == 0 ? state.defaultLabelInsetsFirstColumn : state.defaultLabelInsetsRemainderColumns;
            jComponent2.add((Component)jLabel, gridBagConstraints);
        }
    }

    protected void layoutAfterChild(JComponent jComponent, Map<String, String> map, JComponent jComponent2, SwingMetawidget swingMetawidget) {
        State state = this.getState(jComponent2);
        if (this.mRequiredAlignment != 4) {
            return;
        }
        if (map == null || !"true".equals(map.get("required")) || "true".equals(map.get("read-only")) || swingMetawidget.isReadOnly()) {
            return;
        }
        JLabel jLabel = new JLabel();
        jLabel.setText(this.mRequiredText);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = state.currentColumn * 3 + 2;
        gridBagConstraints.gridy = state.currentRow;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = state.currentColumn == 0 ? state.defaultLabelInsetsFirstColumn : state.defaultLabelInsetsRemainderColumns;
        jComponent2.add((Component)jLabel, gridBagConstraints);
    }

    protected boolean willFillHorizontally(JComponent jComponent, Map<String, String> map) {
        if (jComponent instanceof JScrollPane) {
            return true;
        }
        if (jComponent instanceof SwingMetawidget) {
            return true;
        }
        return SimpleLayoutUtils.isSpanAllColumns(map);
    }

    protected boolean willFillVertically(JComponent jComponent, Map<String, String> map) {
        if (map != null && "true".equals(map.get("large"))) {
            return true;
        }
        return jComponent instanceof JScrollPane;
    }

    protected void setFillConstraints(JComponent jComponent, GridBagConstraints gridBagConstraints) {
        if (jComponent instanceof JButton) {
            return;
        }
        gridBagConstraints.fill = 1;
    }

    private int getEffectiveNumberOfColumns(SwingMetawidget swingMetawidget) {
        if (swingMetawidget.getParent() instanceof SwingMetawidget) {
            return 1;
        }
        return this.mNumberOfColumns;
    }

    private State getState(JComponent jComponent) {
        State state = (State)jComponent.getClientProperty(class$org$metawidget$swing$layout$GridBagLayout == null ? (class$org$metawidget$swing$layout$GridBagLayout = GridBagLayout.class$("org.metawidget.swing.layout.GridBagLayout")) : class$org$metawidget$swing$layout$GridBagLayout);
        if (state == null) {
            state = new State();
            jComponent.putClientProperty(class$org$metawidget$swing$layout$GridBagLayout == null ? (class$org$metawidget$swing$layout$GridBagLayout = GridBagLayout.class$("org.metawidget.swing.layout.GridBagLayout")) : class$org$metawidget$swing$layout$GridBagLayout, state);
        }
        return state;
    }

    @Override
    public /* synthetic */ void onEndBuild(Object object) {
        this.onEndBuild((SwingMetawidget)object);
    }

    @Override
    public /* synthetic */ void endContainerLayout(Object object, Object object2) {
        this.endContainerLayout((JComponent)object, (SwingMetawidget)object2);
    }

    @Override
    public /* synthetic */ void startContainerLayout(Object object, Object object2) {
        this.startContainerLayout((JComponent)object, (SwingMetawidget)object2);
    }

    @Override
    public /* synthetic */ void onStartBuild(Object object) {
        this.onStartBuild((SwingMetawidget)object);
    }

    @Override
    public /* synthetic */ void layoutWidget(Object object, String string, Map map, Object object2, Object object3) {
        this.layoutWidget((JComponent)object, string, (Map<String, String>)map, (JComponent)object2, (SwingMetawidget)object3);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static class State {
        int currentColumn;
        int currentRow;
        Insets defaultLabelInsetsFirstColumn;
        Insets defaultLabelInsetsRemainderColumns;
        boolean needSpacerRow = true;

        State() {
        }
    }
}

