/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.commons.jexl;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;
import org.metawidget.inspector.commons.jexl.UiJexlAttribute;
import org.metawidget.inspector.commons.jexl.UiJexlAttributes;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.BaseObjectInspector;
import org.metawidget.inspector.impl.BaseObjectInspectorConfig;
import org.metawidget.inspector.impl.Trait;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.InspectorUtils;
import org.metawidget.util.ThreadUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JexlInspector
extends BaseObjectInspector {
    private static final ThreadLocal<Object> LOCAL_TOINSPECT = ThreadUtils.newThreadLocal();
    private static final ThreadLocal<JexlContext> LOCAL_CONTEXT = ThreadUtils.newThreadLocal();

    public JexlInspector() {
        this(new BaseObjectInspectorConfig());
    }

    public JexlInspector(BaseObjectInspectorConfig config) {
        super(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, String> inspectParent(Object parentToInspect, Property propertyInParent) throws Exception {
        try {
            LOCAL_TOINSPECT.set(parentToInspect);
            Map<String, String> map = super.inspectParent(parentToInspect, propertyInParent);
            return map;
        }
        finally {
            LOCAL_CONTEXT.remove();
            LOCAL_TOINSPECT.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void inspect(Object toInspect, Class<?> classToInspect, Element toAddTo) throws Exception {
        try {
            LOCAL_TOINSPECT.set(toInspect);
            super.inspect(toInspect, classToInspect, toAddTo);
        }
        finally {
            LOCAL_CONTEXT.remove();
            LOCAL_TOINSPECT.remove();
        }
    }

    @Override
    protected Map<String, String> inspectTrait(Trait trait) throws Exception {
        HashMap<String, String> attributes = CollectionUtils.newHashMap();
        this.putJexlAttributes(attributes, trait.getAnnotation(UiJexlAttributes.class), trait.getAnnotation(UiJexlAttribute.class));
        return attributes;
    }

    protected void putJexlAttributes(Map<String, String> attributes, UiJexlAttributes jexlAttributes, UiJexlAttribute jexlAttribute) throws Exception {
        if (jexlAttribute != null) {
            this.putJexlAttribute(jexlAttribute, attributes);
        }
        if (jexlAttributes != null) {
            for (UiJexlAttribute nestedJexlAttribute : jexlAttributes.value()) {
                this.putJexlAttribute(nestedJexlAttribute, attributes);
            }
        }
    }

    protected void putJexlAttribute(UiJexlAttribute jexlAttribute, Map<String, String> attributes) throws Exception {
        String expression = jexlAttribute.expression();
        if (expression.startsWith("${")) {
            throw InspectorException.newException("Expression '" + expression + "' should be of the form 'foo.bar', not '${foo.bar}'");
        }
        Object value = ExpressionFactory.createExpression((String)expression).evaluate(this.getContext());
        if (value == null) {
            return;
        }
        for (String attributeName : jexlAttribute.name()) {
            InspectorUtils.putAttributeValue(attributes, attributeName, value);
        }
    }

    protected JexlContext getContext() {
        JexlContext context = LOCAL_CONTEXT.get();
        if (context == null) {
            context = this.createContext(LOCAL_TOINSPECT.get());
            LOCAL_CONTEXT.set(context);
        }
        return context;
    }

    protected JexlContext createContext(Object toInspect) {
        JexlContext context = JexlHelper.createContext();
        Map contextMap = context.getVars();
        if (toInspect != null) {
            contextMap.put("this", toInspect);
        }
        return context;
    }
}

