/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.faces;

import java.util.Map;
import javax.faces.context.FacesContext;
import org.metawidget.faces.FacesUtils;
import org.metawidget.inspector.faces.FacesXmlInspectorConfig;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.BaseXmlInspector;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.XmlUtils;
import org.metawidget.util.simple.StringUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesXmlInspector
extends BaseXmlInspector {
    private static final String THIS_ATTRIBUTE = "this";
    private static final String UNDERSCORE_THIS_ATTRIBUTE = "_this";
    private boolean mInjectThis;
    static /* synthetic */ Class class$org$metawidget$inspector$faces$FacesXmlInspectorConfig;

    public FacesXmlInspector(FacesXmlInspectorConfig config) {
        super(config);
        this.mInjectThis = config.isInjectThis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element inspectAsDom(Object toInspect, String type, String[] names) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context == null) {
            throw InspectorException.newException("FacesContext not available to FacesXmlInspector");
        }
        Map requestMap = context.getExternalContext().getRequestMap();
        try {
            if (this.mInjectThis) {
                requestMap.put(THIS_ATTRIBUTE, toInspect);
                requestMap.put(UNDERSCORE_THIS_ATTRIBUTE, toInspect);
            }
            Element element = super.inspectAsDom(toInspect, type, names);
            return element;
        }
        finally {
            if (this.mInjectThis) {
                requestMap.remove(THIS_ATTRIBUTE);
                requestMap.remove(UNDERSCORE_THIS_ATTRIBUTE);
            }
        }
    }

    @Override
    protected Map<String, String> inspectProperty(Element toInspect) {
        if ("property".equals(toInspect.getNodeName())) {
            return this.inspect(toInspect);
        }
        return null;
    }

    @Override
    protected Map<String, String> inspectAction(Element toInspect) {
        if ("action".equals(toInspect.getNodeName())) {
            return this.inspect(toInspect);
        }
        return null;
    }

    private Map<String, String> inspect(Element toInspect) {
        Map<String, String> attributes = XmlUtils.getAttributesAsMap(toInspect);
        for (Map.Entry<String, String> entry : CollectionUtils.newArrayList(attributes.entrySet())) {
            String unwrappedExpression;
            String key = entry.getKey();
            String value = entry.getValue();
            if ("faces-lookup".equals(key) || "faces-suggest".equals(key) || "faces-expression".equals(key) || "faces-ajax-action".equals(key)) {
                if (!this.mInjectThis) continue;
                unwrappedExpression = FacesUtils.unwrapExpression(value);
                if (unwrappedExpression.startsWith(new StringBuffer().append(THIS_ATTRIBUTE).append(StringUtils.SEPARATOR_DOT).toString())) {
                    throw InspectorException.newException(new StringBuffer().append("Expression '").append(value).append("' (for '").append(key).append("') must not contain '").append(THIS_ATTRIBUTE).append("' (see Metawidget Reference Guide)").toString());
                }
                if (!unwrappedExpression.startsWith(new StringBuffer().append(UNDERSCORE_THIS_ATTRIBUTE).append(StringUtils.SEPARATOR_DOT).toString())) continue;
                throw InspectorException.newException(new StringBuffer().append("Expression '").append(value).append("' (for '").append(key).append("') must not contain '").append(UNDERSCORE_THIS_ATTRIBUTE).append("' (see Metawidget Reference Guide)").toString());
            }
            if (!FacesUtils.isExpression(value)) continue;
            if (!this.mInjectThis) {
                unwrappedExpression = FacesUtils.unwrapExpression(value);
                if (unwrappedExpression.startsWith(new StringBuffer().append(THIS_ATTRIBUTE).append(StringUtils.SEPARATOR_DOT).toString())) {
                    throw InspectorException.newException(new StringBuffer().append("Expression for '").append(value).append("' contains '").append(THIS_ATTRIBUTE).append("', but ").append((class$org$metawidget$inspector$faces$FacesXmlInspectorConfig == null ? (class$org$metawidget$inspector$faces$FacesXmlInspectorConfig = FacesXmlInspector.class$("org.metawidget.inspector.faces.FacesXmlInspectorConfig")) : class$org$metawidget$inspector$faces$FacesXmlInspectorConfig).getSimpleName()).append(".setInjectThis is 'false'").toString());
                }
                if (unwrappedExpression.startsWith(new StringBuffer().append(UNDERSCORE_THIS_ATTRIBUTE).append(StringUtils.SEPARATOR_DOT).toString())) {
                    throw InspectorException.newException(new StringBuffer().append("Expression for '").append(value).append("' contains '").append(UNDERSCORE_THIS_ATTRIBUTE).append("', but ").append((class$org$metawidget$inspector$faces$FacesXmlInspectorConfig == null ? (class$org$metawidget$inspector$faces$FacesXmlInspectorConfig = FacesXmlInspector.class$("org.metawidget.inspector.faces.FacesXmlInspectorConfig")) : class$org$metawidget$inspector$faces$FacesXmlInspectorConfig).getSimpleName()).append(".setInjectThis is 'false'").toString());
                }
            }
            try {
                FacesContext context = FacesContext.getCurrentInstance();
                value = StringUtils.quietValueOf(context.getApplication().createValueBinding(value).getValue(context));
            }
            catch (Exception e) {
                throw InspectorException.newException(new StringBuffer().append("Unable to getValue of ").append(value).toString(), e);
            }
            attributes.put(key, value);
        }
        return attributes;
    }

    @Override
    public /* synthetic */ Object inspectAsDom(Object x0, String x1, String[] x2) {
        return this.inspectAsDom(x0, x1, x2);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

