/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.struts;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.metawidget.config.ResourceResolver;
import org.metawidget.inspector.impl.BaseXmlInspector;
import org.metawidget.inspector.struts.StrutsInspectorConfig;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrutsInspector
extends BaseXmlInspector {
    private static final String FORM_BEANS_ELEMENT = "form-beans";
    private static final String FORM_PROPERTY_ELEMENT = "form-property";

    public StrutsInspector(StrutsInspectorConfig config) {
        super(config);
    }

    @Override
    protected Element getDocumentElement(ResourceResolver resolver, InputStream[] files) throws Exception {
        Document document = XmlUtils.newDocument();
        Element root = document.createElement(FORM_BEANS_ELEMENT);
        document.appendChild(root);
        for (InputStream file : files) {
            Document documentParsed = XmlUtils.parse(file);
            Element formBeans = XmlUtils.getChildNamed(documentParsed.getDocumentElement(), new String[]{FORM_BEANS_ELEMENT});
            if (formBeans == null) continue;
            XmlUtils.combineElements(root, formBeans, this.getTopLevelTypeAttribute(), this.getNameAttribute());
        }
        return root;
    }

    @Override
    protected Map<String, String> inspectProperty(Element toInspect) {
        if (!FORM_PROPERTY_ELEMENT.equals(toInspect.getNodeName())) {
            return null;
        }
        HashMap<String, String> attributes = CollectionUtils.newHashMap();
        if (toInspect.hasAttribute(this.getNameAttribute())) {
            attributes.put("name", toInspect.getAttribute(this.getNameAttribute()));
        }
        if (toInspect.hasAttribute(this.getTypeAttribute())) {
            attributes.put("type", toInspect.getAttribute(this.getTypeAttribute()));
        }
        return attributes;
    }

    @Override
    protected String getTopLevelTypeAttribute() {
        return "name";
    }
}

