/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl;

import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;
import org.metawidget.inspector.impl.BaseTraitStyleConfig;
import org.metawidget.inspector.impl.Trait;
import org.metawidget.util.CollectionUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseTraitStyle<T extends Trait> {
    final Map<Class<?>, Map<String, T>> mCache;
    private Pattern mExcludeBaseType;

    protected BaseTraitStyle(BaseTraitStyleConfig config) {
        this.mCache = config.isCacheLookups() ? CollectionUtils.newWeakHashMap() : null;
        this.mExcludeBaseType = config.getExcludeBaseType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        if (this.mCache == null) {
            return;
        }
        Map<Class<?>, Map<String, T>> map = this.mCache;
        synchronized (map) {
            this.mCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Map<String, T> getTraits(Class<?> clazz) {
        if (this.mCache == null) {
            return this.getUncachedTraits(clazz);
        }
        Map<Class<?>, Map<String, T>> map = this.mCache;
        synchronized (map) {
            Map<String, T> traits = this.getCachedTraits(clazz);
            if (traits == null) {
                traits = this.getUncachedTraits(clazz);
                this.cacheTraits(clazz, traits);
            }
            return traits;
        }
    }

    protected final Map<String, T> getCachedTraits(Class<?> clazz) {
        return this.mCache.get(clazz);
    }

    protected final void cacheTraits(Class<?> clazz, Map<String, T> traits) {
        this.mCache.put(clazz, Collections.unmodifiableMap(traits));
    }

    protected abstract Map<String, T> getUncachedTraits(Class<?> var1);

    protected final boolean isExcluded(Class<?> classToExclude, String name, Class<?> returnType) {
        if (this.isExcludedBaseType(classToExclude)) {
            return true;
        }
        if (this.isExcludedReturnType(returnType)) {
            return true;
        }
        return this.isExcludedName(name);
    }

    protected boolean isExcludedBaseType(Class<?> classToExclude) {
        String className = classToExclude.getName();
        return this.mExcludeBaseType != null && this.mExcludeBaseType.matcher(className).matches();
    }

    protected boolean isExcludedReturnType(Class<?> clazz) {
        return false;
    }

    protected boolean isExcludedName(String name) {
        return false;
    }
}

