/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl;

import java.util.regex.Pattern;
import org.metawidget.util.simple.ObjectUtils;

public class BaseTraitStyleConfig {
    private static Pattern DEFAULT_EXCLUDE_BASE_TYPE;
    private boolean mCacheLookups = true;
    private Pattern mExcludeBaseType;
    private boolean mNullExcludeBaseType;

    public BaseTraitStyleConfig setCacheLookups(boolean cacheLookups) {
        this.mCacheLookups = cacheLookups;
        return this;
    }

    public BaseTraitStyleConfig setExcludeBaseType(Pattern excludeBaseType) {
        this.mExcludeBaseType = excludeBaseType;
        if (excludeBaseType == null) {
            this.mNullExcludeBaseType = true;
        }
        return this;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!ObjectUtils.nullSafeClassEquals(this, that)) {
            return false;
        }
        if (this.mCacheLookups != ((BaseTraitStyleConfig)that).mCacheLookups) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mExcludeBaseType, ((BaseTraitStyleConfig)that).mExcludeBaseType)) {
            return false;
        }
        return this.mNullExcludeBaseType == ((BaseTraitStyleConfig)that).mNullExcludeBaseType;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(new Boolean(this.mCacheLookups));
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.mExcludeBaseType);
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(new Boolean(this.mNullExcludeBaseType));
        return hashCode;
    }

    protected boolean isCacheLookups() {
        return this.mCacheLookups;
    }

    protected Pattern getExcludeBaseType() {
        if (this.mExcludeBaseType == null && !this.mNullExcludeBaseType) {
            if (DEFAULT_EXCLUDE_BASE_TYPE == null) {
                DEFAULT_EXCLUDE_BASE_TYPE = Pattern.compile("^(java|javax)\\..*$");
            }
            return DEFAULT_EXCLUDE_BASE_TYPE;
        }
        return this.mExcludeBaseType;
    }
}

