/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl;

import java.io.InputStream;
import java.util.Map;
import org.metawidget.config.ResourceResolver;
import org.metawidget.inspector.iface.DomInspector;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.BaseXmlInspectorConfig;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.inspector.impl.propertystyle.PropertyStyle;
import org.metawidget.util.ArrayUtils;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.InspectorUtils;
import org.metawidget.util.LogUtils;
import org.metawidget.util.XmlUtils;
import org.metawidget.util.simple.Pair;
import org.metawidget.util.simple.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseXmlInspector
implements DomInspector<Element> {
    protected LogUtils.Log mLog = LogUtils.getLog(this.getClass());
    private Element mRoot;
    private final PropertyStyle mRestrictAgainstObject;
    private final boolean mInferInheritanceHierarchy;

    protected BaseXmlInspector(BaseXmlInspectorConfig config) {
        try {
            InputStream[] files = config.getInputStreams();
            if (files != null && files.length > 0) {
                this.mRoot = this.getDocumentElement(config.getResourceResolver(), config.getInputStreams());
            }
            if (this.mRoot == null) {
                throw InspectorException.newException("No XML input file specified");
            }
            if (this.mLog.isTraceEnabled()) {
                this.mLog.trace(XmlUtils.documentToString(this.mRoot.getOwnerDocument(), false), new Object[0]);
            }
            this.mRestrictAgainstObject = config.getRestrictAgainstObject();
            this.mInferInheritanceHierarchy = config.isInferInheritanceHierarchy();
            PropertyStyle validateAgainstClasses = config.getValidateAgainstClasses();
            if (validateAgainstClasses != null) {
                String topLevelTypeAttribute = this.getTopLevelTypeAttribute();
                String extendsAttribute = this.getExtendsAttribute();
                String nameAttribute = this.getNameAttribute();
                String typeAttribute = this.getTypeAttribute();
                Element entity = XmlUtils.getChildWithAttribute(this.mRoot, topLevelTypeAttribute);
                while (entity != null) {
                    String topLevelType = entity.getAttribute(topLevelTypeAttribute);
                    Class<?> actualClass = ClassUtils.niceForName(topLevelType);
                    if (actualClass != null) {
                        String extendz = entity.getAttribute(extendsAttribute);
                        Class<?> actualSuperclass = actualClass.getSuperclass();
                        if (!"".equals(extendz) && !extendz.equals(actualSuperclass.getName())) {
                            throw InspectorException.newException(new StringBuffer().append(actualClass).append(" extends ").append(actualSuperclass).append(", not '").append(extendz).append("'").toString());
                        }
                        Map<String, Property> actualProperties = validateAgainstClasses.getProperties(actualClass);
                        Element property = XmlUtils.getChildWithAttribute(entity, nameAttribute);
                        while (property != null) {
                            String propertyName = property.getAttribute(nameAttribute);
                            Property actualProperty = actualProperties.get(propertyName);
                            if (actualProperty == null) {
                                throw InspectorException.newException(new StringBuffer().append(actualClass).append(" does not define a property '").append(propertyName).append("'").toString());
                            }
                            String propertyType = property.getAttribute(typeAttribute);
                            Class<?> actualType = actualProperty.getType();
                            if (!"".equals(propertyType) && !propertyType.equals(actualType.getName())) {
                                throw InspectorException.newException(new StringBuffer().append(actualClass).append(" defines property '").append(propertyName).append("' to be of ").append(actualType).append(", not '").append(propertyType).append("'").toString());
                            }
                            property = XmlUtils.getSiblingWithAttribute(property, nameAttribute);
                        }
                    }
                    entity = XmlUtils.getSiblingWithAttribute(entity, topLevelTypeAttribute);
                }
            }
        }
        catch (Exception e) {
            throw InspectorException.newException(e);
        }
    }

    @Override
    public final String inspect(Object toInspect, String type, String[] names) {
        Element element = this.inspectAsDom(toInspect, type, names);
        if (element == null) {
            return null;
        }
        return XmlUtils.nodeToString((Node)element, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element inspectAsDom(Object toInspect, String type, String[] names) {
        if (type == null) {
            return null;
        }
        try {
            Element entity;
            Document document;
            Pair<Element, String> pair;
            Map<String, String> parentAttributes = null;
            Element element = this.mRoot;
            synchronized (element) {
                Element propertyInParent;
                if (names != null && names.length > 0 && (propertyInParent = this.traverse(toInspect, type, true, names).getLeft()) != null) {
                    parentAttributes = this.inspectProperty(propertyInParent);
                }
                if ((pair = this.traverse(toInspect, type, false, names)).getLeft() == null) {
                    if (parentAttributes == null || parentAttributes.isEmpty()) {
                        return null;
                    }
                    document = XmlUtils.newDocument();
                    entity = document.createElementNS("http://metawidget.org/inspection-result", "entity");
                } else {
                    document = XmlUtils.newDocument();
                    entity = document.createElementNS("http://metawidget.org/inspection-result", "entity");
                    this.inspectTraits(pair.getLeft(), entity);
                    if (!entity.hasChildNodes()) {
                        return null;
                    }
                }
            }
            Element root = document.createElementNS("http://metawidget.org/inspection-result", "inspection-result");
            root.setAttribute("version", "1.0");
            document.appendChild(root);
            root.appendChild(entity);
            if (parentAttributes != null) {
                XmlUtils.setMapAsAttributes(entity, parentAttributes);
            } else {
                entity.setAttribute("type", pair.getRight());
            }
            return root;
        }
        catch (Exception e) {
            throw InspectorException.newException(e);
        }
    }

    protected Element getDocumentElement(ResourceResolver resolver, InputStream[] files) throws Exception {
        Document documentMaster = null;
        for (InputStream file : files) {
            Document documentParsed = XmlUtils.parse(file);
            if (!documentParsed.hasChildNodes()) continue;
            this.preprocessDocument(documentParsed);
            if (documentMaster == null || !documentMaster.hasChildNodes()) {
                documentMaster = documentParsed;
                continue;
            }
            XmlUtils.combineElements(documentMaster.getDocumentElement(), documentParsed.getDocumentElement(), this.getTopLevelTypeAttribute(), this.getNameAttribute());
        }
        if (documentMaster == null) {
            return null;
        }
        return documentMaster.getDocumentElement();
    }

    protected void preprocessDocument(Document document) {
    }

    protected void inspectTraits(Element entity, Element toAddTo) {
        if (entity == null) {
            return;
        }
        Document document = toAddTo.getOwnerDocument();
        String extendsAttribute = this.getExtendsAttribute();
        if (extendsAttribute != null && entity.hasAttribute(extendsAttribute)) {
            this.inspectTraits(this.traverse(null, entity.getAttribute(extendsAttribute), false, new String[0]).getLeft(), toAddTo);
        }
        Element element = document.createElementNS("http://metawidget.org/inspection-result", "entity");
        Element trait = XmlUtils.getFirstChildElement(entity);
        while (trait != null) {
            Element inspectedTrait = this.inspectTrait(document, trait);
            if (inspectedTrait != null) {
                element.appendChild(inspectedTrait);
            }
            trait = XmlUtils.getNextSiblingElement(trait);
        }
        XmlUtils.combineElements(toAddTo, element, "name", "name");
    }

    protected Element inspectTrait(Document toAddTo, Element toInspect) {
        Map<String, String> propertyAttributes = this.inspectProperty(toInspect);
        if (propertyAttributes != null && !propertyAttributes.isEmpty()) {
            Element child = toAddTo.createElementNS("http://metawidget.org/inspection-result", "property");
            XmlUtils.setMapAsAttributes(child, propertyAttributes);
            return child;
        }
        Map<String, String> actionAttributes = this.inspectAction(toInspect);
        if (actionAttributes != null && !actionAttributes.isEmpty()) {
            if (propertyAttributes != null) {
                throw InspectorException.newException(new StringBuffer().append("Ambigious match: ").append(toInspect.getNodeName()).append(" matches as both a property and an action").toString());
            }
            Element child = toAddTo.createElementNS("http://metawidget.org/inspection-result", "action");
            XmlUtils.setMapAsAttributes(child, actionAttributes);
            return child;
        }
        return null;
    }

    protected Map<String, String> inspectProperty(Element toInspect) {
        return null;
    }

    protected Map<String, String> inspectAction(Element toInspect) {
        return null;
    }

    protected Pair<Element, String> traverse(Object toTraverse, String type, boolean onlyToParent, String[] names) {
        String topLevelTypeAttribute;
        Element entityElement;
        String typeToInspect = type;
        Object namesToInspect = names;
        Object traverseAgainstObject = null;
        String declaredType = null;
        if (toTraverse != null && this.mRestrictAgainstObject != null) {
            Pair<Object, Class<?>> pair = InspectorUtils.traverse(this.mRestrictAgainstObject, toTraverse, typeToInspect, onlyToParent, namesToInspect);
            traverseAgainstObject = pair.getLeft();
            if (pair.getRight() != null) {
                declaredType = pair.getRight().getName();
            }
            if (traverseAgainstObject == null) {
                return new Pair<Object, String>(null, declaredType);
            }
            namesToInspect = onlyToParent ? new String[]{namesToInspect[((String[])namesToInspect).length - 1]} : null;
            typeToInspect = traverseAgainstObject.getClass().getName();
        }
        if (declaredType == null) {
            declaredType = typeToInspect;
        }
        if ((entityElement = XmlUtils.getChildWithAttributeValue(this.mRoot, topLevelTypeAttribute = this.getTopLevelTypeAttribute(), typeToInspect)) == null) {
            Class<?> actualClass;
            if (traverseAgainstObject == null && !this.mInferInheritanceHierarchy) {
                return new Pair<Object, String>(null, declaredType);
            }
            if (traverseAgainstObject != null) {
                actualClass = traverseAgainstObject.getClass();
            } else {
                actualClass = ClassUtils.niceForName(typeToInspect);
                if (actualClass == null) {
                    return new Pair<Object, String>(null, typeToInspect);
                }
            }
            while (entityElement == null && (actualClass = actualClass.getSuperclass()) != null) {
                entityElement = XmlUtils.getChildWithAttributeValue(this.mRoot, topLevelTypeAttribute, actualClass.getName());
            }
            if (entityElement == null) {
                return new Pair<Object, String>(null, declaredType);
            }
        }
        if (namesToInspect == null) {
            return new Pair<Element, String>(entityElement, declaredType);
        }
        int length = ((String[])namesToInspect).length;
        if (length == 0) {
            return new Pair<Element, String>(entityElement, declaredType);
        }
        String extendsAttribute = this.getExtendsAttribute();
        String nameAttribute = this.getNameAttribute();
        String typeAttribute = this.getTypeAttribute();
        for (int loop = 0; loop < length; ++loop) {
            String name = namesToInspect[loop];
            Element property = XmlUtils.getChildWithAttributeValue(entityElement, nameAttribute, name);
            if (property == null) {
                if (extendsAttribute == null) {
                    return new Pair<Object, Object>(null, null);
                }
                do {
                    if (!entityElement.hasAttribute(extendsAttribute)) {
                        return new Pair<Object, Object>(null, null);
                    }
                    String childExtends = entityElement.getAttribute(extendsAttribute);
                    if ((entityElement = XmlUtils.getChildWithAttributeValue(this.mRoot, topLevelTypeAttribute, childExtends)) != null) continue;
                    return new Pair<Object, Object>(null, null);
                } while ((property = XmlUtils.getChildWithAttributeValue(entityElement, nameAttribute, name)) == null);
                if (property == null) {
                    throw new NullPointerException("property");
                }
            }
            if (onlyToParent && loop >= length - 1) {
                return new Pair<Element, String>(property, property.getAttribute(typeAttribute));
            }
            if (!property.hasAttribute(typeAttribute)) {
                throw InspectorException.newException(new StringBuffer().append("Property ").append(name).append(" in entity ").append(entityElement.getAttribute(typeAttribute)).append(" has no @").append(typeAttribute).append(" attribute in the XML, so cannot navigate to ").append(type).append(ArrayUtils.toString(namesToInspect, StringUtils.SEPARATOR_FORWARD_SLASH, true, false)).toString());
            }
            declaredType = property.getAttribute(typeAttribute);
            entityElement = XmlUtils.getChildWithAttributeValue(this.mRoot, topLevelTypeAttribute, declaredType);
            if (entityElement == null) break;
        }
        return new Pair<Element, String>(entityElement, declaredType);
    }

    protected String getTopLevelTypeAttribute() {
        return "type";
    }

    protected String getNameAttribute() {
        return "name";
    }

    protected String getTypeAttribute() {
        return "type";
    }

    protected String getExtendsAttribute() {
        return null;
    }

    @Override
    public /* synthetic */ Object inspectAsDom(Object x0, String x1, String[] x2) {
        return this.inspectAsDom(x0, x1, x2);
    }
}

