/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl.propertystyle.javabean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.propertystyle.BaseProperty;
import org.metawidget.inspector.impl.propertystyle.BasePropertyStyle;
import org.metawidget.inspector.impl.propertystyle.BasePropertyStyleConfig;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.inspector.impl.propertystyle.javabean.JavaBeanPropertyStyleConfig;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.Java5ClassUtils;
import org.metawidget.util.simple.StringUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanPropertyStyle
extends BasePropertyStyle {
    private boolean mSupportPublicFields;
    private MessageFormat mPrivateFieldConvention;

    public JavaBeanPropertyStyle() {
        this(new JavaBeanPropertyStyleConfig());
    }

    @Deprecated
    public JavaBeanPropertyStyle(BasePropertyStyleConfig config) {
        super(config);
    }

    public JavaBeanPropertyStyle(JavaBeanPropertyStyleConfig config) {
        this((BasePropertyStyleConfig)config);
        this.mSupportPublicFields = config.isSupportPublicFields();
        this.mPrivateFieldConvention = config.getPrivateFieldConvention();
    }

    @Override
    protected Map<String, Property> inspectProperties(Class<?> clazz) {
        TreeMap<String, Property> properties = CollectionUtils.newTreeMap();
        this.lookupFields(properties, clazz);
        this.lookupGetters(properties, clazz);
        this.lookupSetters(properties, clazz);
        Iterator i = properties.entrySet().iterator();
        while (i.hasNext()) {
            if (i.next().getValue() != null) continue;
            i.remove();
        }
        return properties;
    }

    protected void lookupFields(Map<String, Property> properties, Class<?> clazz) {
        if (!this.mSupportPublicFields) {
            return;
        }
        for (Field field : clazz.getFields()) {
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers)) continue;
            String fieldName = field.getName();
            Class<?> type = field.getType();
            if (this.isExcluded(field.getDeclaringClass(), fieldName, type)) {
                properties.put(fieldName, null);
                continue;
            }
            properties.put(fieldName, new FieldProperty(fieldName, field));
        }
    }

    protected void lookupGetters(Map<String, Property> properties, Class<?> clazz) {
        for (Method method : clazz.getMethods()) {
            JavaBeanProperty existingJavaBeanProperty;
            String propertyName;
            Class<?> type;
            Class<?>[] parameters = method.getParameterTypes();
            if (parameters.length != 0 || Void.TYPE.equals(type = method.getReturnType()) || (propertyName = this.isGetter(method)) == null) continue;
            if (this.isExcluded(ClassUtils.getOriginalDeclaringClass(method), propertyName, type)) {
                properties.put(propertyName, null);
                continue;
            }
            Property existingProperty = properties.get(propertyName);
            if (existingProperty instanceof FieldProperty) {
                throw InspectorException.newException(new StringBuffer().append("JavaBeanProperty '").append(((FieldProperty)existingProperty).getField()).append("' has both a public member variable and a public getter method. Should be one or the other").toString());
            }
            if (existingProperty instanceof JavaBeanProperty && type.isAssignableFrom((existingJavaBeanProperty = (JavaBeanProperty)existingProperty).getType()) || existingProperty == null && properties.containsKey(propertyName)) continue;
            properties.put(propertyName, new JavaBeanProperty(propertyName, type, method, null, this.getPrivateField(clazz, propertyName)));
        }
    }

    protected String isGetter(Method method) {
        String propertyName;
        String methodName = method.getName();
        if (methodName.startsWith("get")) {
            propertyName = methodName.substring("get".length());
        } else if (methodName.startsWith("is") && Boolean.TYPE.equals(method.getReturnType())) {
            propertyName = methodName.substring("is".length());
        } else {
            return null;
        }
        if (!StringUtils.isFirstLetterUppercase(propertyName)) {
            return null;
        }
        return StringUtils.lowercaseFirstLetter(propertyName);
    }

    protected void lookupSetters(Map<String, Property> properties, Class<?> clazz) {
        for (Method method : clazz.getMethods()) {
            Class<?>[] parameters = method.getParameterTypes();
            if (parameters.length != 1) continue;
            Class<?> type = parameters[0];
            String propertyName = this.isSetter(method);
            if (propertyName == null) continue;
            if (this.isExcluded(ClassUtils.getOriginalDeclaringClass(method), propertyName, type)) {
                properties.put(propertyName, null);
                continue;
            }
            Property existingProperty = properties.get(propertyName);
            if (existingProperty instanceof FieldProperty) {
                throw InspectorException.newException(new StringBuffer().append("JavaBeanProperty '").append(((FieldProperty)existingProperty).getField()).append("' has both a public member variable and a public setter method. Should be one or the other").toString());
            }
            if (existingProperty instanceof JavaBeanProperty) {
                JavaBeanProperty existingJavaBeanProperty = (JavaBeanProperty)existingProperty;
                properties.put(propertyName, new JavaBeanProperty(propertyName, existingJavaBeanProperty.getType(), existingJavaBeanProperty.getReadMethod(), method, this.getPrivateField(clazz, propertyName)));
                continue;
            }
            if (existingProperty == null && properties.containsKey(propertyName)) continue;
            properties.put(propertyName, new JavaBeanProperty(propertyName, type, null, method, this.getPrivateField(clazz, propertyName)));
        }
    }

    protected String isSetter(Method method) {
        String methodName = method.getName();
        if (!methodName.startsWith("set")) {
            return null;
        }
        String propertyName = methodName.substring("set".length());
        if (!StringUtils.isFirstLetterUppercase(propertyName)) {
            return null;
        }
        return StringUtils.lowercaseFirstLetter(propertyName);
    }

    @Override
    protected boolean isExcludedName(String name) {
        if ("propertyChangeListeners".equals(name)) {
            return true;
        }
        if ("vetoableChangeListeners".equals(name)) {
            return true;
        }
        return super.isExcludedName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Field getPrivateField(Class<?> clazz, String propertyName) {
        String fieldName;
        if (this.mPrivateFieldConvention == null) {
            return null;
        }
        Object[] arguments = new String[]{propertyName, StringUtils.uppercaseFirstLetter(propertyName)};
        MessageFormat messageFormat = this.mPrivateFieldConvention;
        synchronized (messageFormat) {
            fieldName = this.mPrivateFieldConvention.format(arguments, new StringBuffer(), (FieldPosition)null).toString();
        }
        for (Class<?> currentClass = clazz; currentClass != null && !this.isExcludedBaseType(currentClass); currentClass = currentClass.getSuperclass()) {
            try {
                return currentClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JavaBeanProperty
    extends BaseProperty {
        private Method mReadMethod;
        private Method mWriteMethod;
        private Field mPrivateField;

        public JavaBeanProperty(String name, Class<?> clazz, Method readMethod, Method writeMethod, Field privateField) {
            super(name, clazz);
            this.mReadMethod = readMethod;
            this.mWriteMethod = writeMethod;
            if (this.mReadMethod == null && this.mWriteMethod == null) {
                throw InspectorException.newException(new StringBuffer().append("JavaBeanProperty '").append(name).append("' has no getter and no setter").toString());
            }
            this.mPrivateField = privateField;
        }

        @Override
        public boolean isReadable() {
            return this.mReadMethod != null;
        }

        @Override
        public Object read(Object obj) {
            try {
                return this.mReadMethod.invoke(obj, new Object[0]);
            }
            catch (Exception e) {
                throw InspectorException.newException(e);
            }
        }

        @Override
        public boolean isWritable() {
            return this.mWriteMethod != null;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            T annotation;
            if (this.mReadMethod != null && (annotation = Java5ClassUtils.getOriginalAnnotation(this.mReadMethod, annotationClass)) != null) {
                return annotation;
            }
            if (this.mWriteMethod != null && (annotation = Java5ClassUtils.getOriginalAnnotation(this.mWriteMethod, annotationClass)) != null) {
                return annotation;
            }
            if (this.mPrivateField != null) {
                annotation = this.mPrivateField.getAnnotation(annotationClass);
                if (annotation != null) {
                    return annotation;
                }
                return null;
            }
            return null;
        }

        @Override
        public Type getGenericType() {
            if (this.mReadMethod != null) {
                return Java5ClassUtils.getOriginalGenericReturnType(this.mReadMethod);
            }
            return Java5ClassUtils.getOriginalGenericParameterTypes(this.mWriteMethod)[0];
        }

        public Method getReadMethod() {
            return this.mReadMethod;
        }

        public Method getWriteMethod() {
            return this.mWriteMethod;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FieldProperty
    extends BaseProperty {
        private Field mField;

        public FieldProperty(String name, Field field) {
            super(name, field.getType());
            this.mField = field;
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public Object read(Object obj) {
            try {
                return this.mField.get(obj);
            }
            catch (Exception e) {
                throw InspectorException.newException(e);
            }
        }

        @Override
        public boolean isWritable() {
            return true;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotation) {
            return this.mField.getAnnotation(annotation);
        }

        @Override
        public Type getGenericType() {
            return this.mField.getGenericType();
        }

        public Field getField() {
            return this.mField;
        }
    }
}

