/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.jbpm;

import java.util.HashMap;
import java.util.Map;
import org.metawidget.inspector.impl.BaseXmlInspector;
import org.metawidget.inspector.impl.BaseXmlInspectorConfig;
import org.metawidget.util.CollectionUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageflowInspector
extends BaseXmlInspector {
    public PageflowInspector(BaseXmlInspectorConfig config) {
        super(config);
    }

    @Override
    protected String getTopLevelTypeAttribute() {
        return "name";
    }

    @Override
    protected String getTypeAttribute() {
        return "to";
    }

    @Override
    protected void preprocessDocument(Document document) {
        Element root = document.getDocumentElement();
        String pagePrefix = new StringBuffer().append(root.getAttribute("name")).append('.').toString();
        String topLevelTypeAttribute = this.getTopLevelTypeAttribute();
        NodeList rootChildren = root.getChildNodes();
        int loopPages = 0;
        int lengthPages = rootChildren.getLength();
        while (loopPages < lengthPages) {
            Node pageNode = rootChildren.item(loopPages);
            if (!"page".equals(pageNode.getNodeName())) {
                root.removeChild(pageNode);
                --lengthPages;
                continue;
            }
            ++loopPages;
            Element pageElement = (Element)pageNode;
            String pageName = pageElement.getAttribute(topLevelTypeAttribute);
            pageElement.setAttribute(topLevelTypeAttribute, new StringBuffer().append(pagePrefix).append(pageName).toString());
            NodeList pageChildren = pageNode.getChildNodes();
            int loopTransition = 0;
            int lengthTransitions = pageChildren.getLength();
            while (loopTransition < lengthTransitions) {
                Node transitionNode = pageChildren.item(loopTransition);
                if (!"transition".equals(transitionNode.getNodeName())) {
                    pageNode.removeChild(transitionNode);
                    --lengthTransitions;
                    continue;
                }
                ++loopTransition;
            }
        }
    }

    @Override
    protected Map<String, String> inspectAction(Element toInspect) {
        HashMap<String, String> attributes = CollectionUtils.newHashMap();
        attributes.put("name", toInspect.getAttribute("name"));
        return attributes;
    }
}

