/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.layout.decorator;

import java.util.Arrays;
import java.util.Map;
import org.metawidget.layout.decorator.LayoutDecorator;
import org.metawidget.layout.decorator.LayoutDecoratorConfig;
import org.metawidget.layout.decorator.NestedSectionLayoutDecorator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FlatSectionLayoutDecorator<W, C extends W, M extends C>
extends LayoutDecorator<W, C, M> {
    protected FlatSectionLayoutDecorator(LayoutDecoratorConfig<W, C, M> config) {
        super(config);
    }

    @Override
    public void startContainerLayout(C container, M metawidget) {
        super.startContainerLayout(container, metawidget);
        State state = this.getState(container, metawidget);
        state.currentSections = null;
    }

    @Override
    public void layoutWidget(W widget, String elementName, Map<String, String> attributes, C container, M metawidget) {
        State state = this.getState(container, metawidget);
        if (this.getDelegate() instanceof NestedSectionLayoutDecorator) {
            String section = this.stripSection(attributes);
            if (this.isEmptyStub(widget) || section == null || state.currentSections != null && section.equals(state.currentSections[0])) {
                super.layoutWidget(widget, elementName, attributes, container, metawidget);
                return;
            }
            if (state.currentSections != null && !section.equals(state.currentSections[0])) {
                super.endContainerLayout(container, metawidget);
            }
            state.currentSections = new String[]{section};
            if (!"".equals(section)) {
                this.addSectionWidget(section, 0, container, metawidget);
            }
        } else {
            Object[] sections = this.getSections(attributes);
            if (this.isEmptyStub(widget) || sections.length == 0 || Arrays.equals(sections, state.currentSections)) {
                super.layoutWidget(widget, elementName, attributes, container, metawidget);
                return;
            }
            for (int level = 0; level < sections.length; ++level) {
                Object section = sections[level];
                if ("".equals(section) || state.currentSections != null && level < state.currentSections.length && ((String)section).equals(state.currentSections[level])) continue;
                this.addSectionWidget((String)section, level, container, metawidget);
            }
            state.currentSections = sections;
        }
        super.layoutWidget(widget, elementName, attributes, container, metawidget);
    }

    protected abstract String stripSection(Map<String, String> var1);

    protected abstract String[] getSections(Map<String, String> var1);

    protected abstract State getState(C var1, M var2);

    protected abstract boolean isEmptyStub(W var1);

    protected abstract void addSectionWidget(String var1, int var2, C var3, M var4);

    public static class State {
        public String[] currentSections;
    }
}

