/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swing.widgetprocessor.binding.beanutils;

import java.awt.Component;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.metawidget.swing.SwingMetawidget;
import org.metawidget.swing.widgetprocessor.binding.BindingConverter;
import org.metawidget.swing.widgetprocessor.binding.beanutils.BeanUtilsBindingProcessorConfig;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.simple.PathUtils;
import org.metawidget.widgetprocessor.iface.AdvancedWidgetProcessor;
import org.metawidget.widgetprocessor.iface.WidgetProcessorException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanUtilsBindingProcessor
implements AdvancedWidgetProcessor<JComponent, SwingMetawidget>,
BindingConverter {
    private static final String SCALA_SET_SUFFIX = "_$eq";
    private final int mPropertyStyle;
    static /* synthetic */ Class class$org$metawidget$swing$widgetprocessor$binding$beanutils$BeanUtilsBindingProcessor;

    public BeanUtilsBindingProcessor() {
        this(new BeanUtilsBindingProcessorConfig());
    }

    public BeanUtilsBindingProcessor(BeanUtilsBindingProcessorConfig config) {
        this.mPropertyStyle = config.getPropertyStyle();
    }

    @Override
    public void onStartBuild(SwingMetawidget metawidget) {
        metawidget.putClientProperty(class$org$metawidget$swing$widgetprocessor$binding$beanutils$BeanUtilsBindingProcessor == null ? (class$org$metawidget$swing$widgetprocessor$binding$beanutils$BeanUtilsBindingProcessor = BeanUtilsBindingProcessor.class$("org.metawidget.swing.widgetprocessor.binding.beanutils.BeanUtilsBindingProcessor")) : class$org$metawidget$swing$widgetprocessor$binding$beanutils$BeanUtilsBindingProcessor, null);
    }

    @Override
    public JComponent processWidget(JComponent component, String elementName, Map<String, String> attributes, SwingMetawidget metawidget) {
        JComponent componentToBind = component;
        if (componentToBind instanceof JScrollPane) {
            componentToBind = (JComponent)((JScrollPane)componentToBind).getViewport().getView();
        }
        if (componentToBind instanceof SwingMetawidget) {
            State state = this.getState(metawidget);
            if (state.nestedMetawidgets == null) {
                state.nestedMetawidgets = CollectionUtils.newHashSet();
            }
            state.nestedMetawidgets.add((SwingMetawidget)component);
            return component;
        }
        String componentProperty = metawidget.getValueProperty(componentToBind);
        if (componentProperty == null) {
            return component;
        }
        String path = metawidget.getPath();
        if ("property".equals(elementName)) {
            path = new StringBuffer().append(path).append('/').append(attributes.get("name")).toString();
        }
        try {
            Object sourceValue;
            String names = PathUtils.parsePath(path, '/').getNames().replace('/', '.');
            try {
                sourceValue = this.retrieveValueFromObject(metawidget, metawidget.getToInspect(), names);
            }
            catch (NoSuchMethodException e) {
                throw WidgetProcessorException.newException(new StringBuffer().append("Property '").append(names).append("' has no getter").toString());
            }
            SavedBinding binding = new SavedBinding(componentToBind, componentProperty, names, "true".equals(attributes.get("no-setter")));
            this.saveValueToWidget(binding, sourceValue);
            State state = this.getState(metawidget);
            if (state.bindings == null) {
                state.bindings = CollectionUtils.newHashSet();
            }
            state.bindings.add(binding);
        }
        catch (Exception e) {
            throw WidgetProcessorException.newException(e);
        }
        return component;
    }

    public void rebind(Object toRebind, SwingMetawidget metawidget) {
        metawidget.updateToInspectWithoutInvalidate(toRebind);
        State state = this.getState(metawidget);
        if (state.bindings != null) {
            try {
                for (SavedBinding binding : state.bindings) {
                    Object sourceValue;
                    String names = binding.getNames();
                    try {
                        sourceValue = this.retrieveValueFromObject(metawidget, toRebind, names);
                    }
                    catch (NoSuchMethodException e) {
                        throw WidgetProcessorException.newException(new StringBuffer().append("Property '").append(names).append("' has no getter").toString());
                    }
                    this.saveValueToWidget(binding, sourceValue);
                }
            }
            catch (Exception e) {
                throw WidgetProcessorException.newException(e);
            }
        }
        if (state.nestedMetawidgets != null) {
            for (SwingMetawidget nestedMetawidget : state.nestedMetawidgets) {
                this.rebind(toRebind, nestedMetawidget);
            }
        }
    }

    public void save(SwingMetawidget metawidget) {
        State state = this.getState(metawidget);
        if (state.bindings != null) {
            try {
                for (SavedBinding binding : state.bindings) {
                    if (!binding.isSettable()) continue;
                    Object componentValue = this.retrieveValueFromWidget(binding);
                    this.saveValueToObject(metawidget, binding.getNames(), componentValue);
                }
            }
            catch (Exception e) {
                throw WidgetProcessorException.newException(e);
            }
        }
        if (state.nestedMetawidgets != null) {
            for (SwingMetawidget nestedMetawidget : state.nestedMetawidgets) {
                this.save(nestedMetawidget);
            }
        }
    }

    @Override
    public Object convertFromString(String value, Class<?> expectedType) {
        return ConvertUtils.convert((String)value, expectedType);
    }

    @Override
    public void onEndBuild(SwingMetawidget metawidget) {
    }

    protected Object retrieveValueFromObject(SwingMetawidget metawidget, Object source, String names) throws Exception {
        if (this.mPropertyStyle == 1) {
            return this.scalaTraverse(source, false, names.split("\\."));
        }
        return PropertyUtils.getProperty((Object)source, (String)names);
    }

    protected void saveValueToObject(SwingMetawidget metawidget, String names, Object componentValue) throws Exception {
        Object source = metawidget.getToInspect();
        if (this.mPropertyStyle == 1) {
            String[] namesAsArray = names.split("\\.");
            Object parent = this.scalaTraverse(source, true, namesAsArray);
            if (parent == null) {
                return;
            }
            Class<?> parentClass = parent.getClass();
            String lastName = namesAsArray[namesAsArray.length - 1];
            Class<?> propertyType = parentClass.getMethod(lastName, new Class[0]).getReturnType();
            Object convertedValue = ConvertUtils.convert((Object)componentValue, propertyType);
            Method writeMethod = parentClass.getMethod(new StringBuffer().append(lastName).append(SCALA_SET_SUFFIX).toString(), propertyType);
            writeMethod.invoke(parent, convertedValue);
        } else {
            BeanUtils.setProperty(source, (String)names, (Object)componentValue);
        }
    }

    protected Object retrieveValueFromWidget(SavedBinding binding) throws Exception {
        return PropertyUtils.getProperty((Object)binding.getComponent(), (String)binding.getComponentProperty());
    }

    protected void saveValueToWidget(SavedBinding binding, Object sourceValue) throws Exception {
        BeanUtils.setProperty((Object)binding.getComponent(), (String)binding.getComponentProperty(), (Object)sourceValue);
    }

    private Object scalaTraverse(Object toTraverse, boolean onlyToParent, String[] names) throws Exception {
        Method readMethod;
        if (toTraverse == null) {
            return null;
        }
        if (names == null) {
            return toTraverse;
        }
        int length = names.length;
        if (length == 0) {
            return toTraverse;
        }
        if (onlyToParent) {
            --length;
        }
        Object traverse = toTraverse;
        for (int loop = 0; loop < length && (traverse = (readMethod = traverse.getClass().getMethod(names[loop], new Class[0])).invoke(traverse, new Object[0])) != null; ++loop) {
        }
        return traverse;
    }

    private State getState(SwingMetawidget metawidget) {
        State state = (State)metawidget.getClientProperty(class$org$metawidget$swing$widgetprocessor$binding$beanutils$BeanUtilsBindingProcessor == null ? (class$org$metawidget$swing$widgetprocessor$binding$beanutils$BeanUtilsBindingProcessor = BeanUtilsBindingProcessor.class$("org.metawidget.swing.widgetprocessor.binding.beanutils.BeanUtilsBindingProcessor")) : class$org$metawidget$swing$widgetprocessor$binding$beanutils$BeanUtilsBindingProcessor);
        if (state == null) {
            state = new State();
            metawidget.putClientProperty(class$org$metawidget$swing$widgetprocessor$binding$beanutils$BeanUtilsBindingProcessor == null ? (class$org$metawidget$swing$widgetprocessor$binding$beanutils$BeanUtilsBindingProcessor = BeanUtilsBindingProcessor.class$("org.metawidget.swing.widgetprocessor.binding.beanutils.BeanUtilsBindingProcessor")) : class$org$metawidget$swing$widgetprocessor$binding$beanutils$BeanUtilsBindingProcessor, state);
        }
        return state;
    }

    @Override
    public /* synthetic */ void onEndBuild(Object x0) {
        this.onEndBuild((SwingMetawidget)x0);
    }

    @Override
    public /* synthetic */ void onStartBuild(Object x0) {
        this.onStartBuild((SwingMetawidget)x0);
    }

    @Override
    public /* synthetic */ Object processWidget(Object x0, String x1, Map x2, Object x3) {
        return this.processWidget((JComponent)x0, x1, (Map<String, String>)x2, (SwingMetawidget)x3);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static class SavedBinding {
        private Component mComponent;
        private String mComponentProperty;
        private String mNames;
        private boolean mNoSetter;

        public SavedBinding(Component component, String componentProperty, String names, boolean noSetter) {
            this.mComponent = component;
            this.mComponentProperty = componentProperty;
            this.mNames = names;
            this.mNoSetter = noSetter;
        }

        public Component getComponent() {
            return this.mComponent;
        }

        public String getComponentProperty() {
            return this.mComponentProperty;
        }

        public String getNames() {
            return this.mNames;
        }

        public boolean isSettable() {
            return !this.mNoSetter;
        }
    }

    static class State {
        Set<SavedBinding> bindings;
        Set<SwingMetawidget> nestedMetawidgets;

        State() {
        }
    }
}

