/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspectionresultprocessor.sort;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.metawidget.inspectionresultprocessor.iface.InspectionResultProcessorException;
import org.metawidget.inspectionresultprocessor.impl.BaseInspectionResultProcessor;
import org.metawidget.util.ArrayUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComesAfterInspectionResultProcessor<M>
extends BaseInspectionResultProcessor<M> {
    @Override
    public Element processInspectionResultAsDom(Element inspectionResult, M metawidget, Object toInspect, String type, String[] names) {
        try {
            Document newDocument = XmlUtils.newDocument();
            Element newInspectionResult = newDocument.createElementNS("http://metawidget.org/inspection-result", "inspection-result");
            XmlUtils.setMapAsAttributes(newInspectionResult, XmlUtils.getAttributesAsMap(inspectionResult));
            newDocument.appendChild(newInspectionResult);
            Element entity = XmlUtils.getFirstChildElement(inspectionResult);
            Element newEntity = newDocument.createElementNS("http://metawidget.org/inspection-result", "entity");
            XmlUtils.setMapAsAttributes(newEntity, XmlUtils.getAttributesAsMap(entity));
            newInspectionResult.appendChild(newEntity);
            LinkedHashMap<Element, String[]> traitsWithComesAfter = new LinkedHashMap<Element, String[]>();
            Element trait = XmlUtils.getFirstChildElement(entity);
            while (trait != null) {
                if (this.hasComesAfter(trait, metawidget)) {
                    traitsWithComesAfter.put(trait, ArrayUtils.fromString(this.getComesAfter(trait, metawidget)));
                } else {
                    newEntity.appendChild(XmlUtils.importElement(newDocument, trait));
                }
                trait = XmlUtils.getNextSiblingElement(trait);
            }
            int infiniteLoop = traitsWithComesAfter.size();
            infiniteLoop *= infiniteLoop;
            while (!traitsWithComesAfter.isEmpty()) {
                if (--infiniteLoop < 0) {
                    ArrayList comesAfterNames = CollectionUtils.newArrayList();
                    for (Map.Entry entry : traitsWithComesAfter.entrySet()) {
                        String value = ((String[])entry.getValue()).length == 0 ? "at the end" : new StringBuffer().append("after ").append(ArrayUtils.toString(entry.getValue(), " and ")).toString();
                        comesAfterNames.add(new StringBuffer().append(((Element)entry.getKey()).getAttribute("name")).append(" comes ").append(value).toString());
                    }
                    Collections.sort(comesAfterNames);
                    throw InspectionResultProcessorException.newException(new StringBuffer().append("Infinite loop detected when sorting comes-after: ").append(CollectionUtils.toString(comesAfterNames, ", but ")).toString());
                }
                Iterator i = traitsWithComesAfter.entrySet().iterator();
                block5: while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    Element traitWithComesAfter = (Element)entry.getKey();
                    String[] comesAfter = (String[])entry.getValue();
                    if (comesAfter.length == 0) {
                        for (String[] traitWithComesAfterExisting : traitsWithComesAfter.values()) {
                            if (traitWithComesAfterExisting.length <= 0) continue;
                            continue block5;
                        }
                        newEntity.appendChild(XmlUtils.importElement(newDocument, traitWithComesAfter));
                    } else {
                        Element newTrait;
                        String name = traitWithComesAfter.getAttribute("name");
                        for (String comeAfter : comesAfter) {
                            if (name.equals(comeAfter)) {
                                throw InspectionResultProcessorException.newException(new StringBuffer().append("'").append(comeAfter).append("' ").append("comes-after").append(" itself").toString());
                            }
                            for (Element traitExisting : traitsWithComesAfter.keySet()) {
                                if (!comeAfter.equals(traitExisting.getAttribute("name"))) continue;
                                continue block5;
                            }
                        }
                        Element insertBefore = newTrait = XmlUtils.getFirstChildElement(newEntity);
                        while (newTrait != null) {
                            if (ArrayUtils.contains(comesAfter, newTrait.getAttribute("name"))) {
                                insertBefore = newTrait = XmlUtils.getNextSiblingElement(newTrait);
                                continue;
                            }
                            newTrait = XmlUtils.getNextSiblingElement(newTrait);
                        }
                        if (insertBefore == null) {
                            newEntity.appendChild(XmlUtils.importElement(newDocument, traitWithComesAfter));
                        } else {
                            newEntity.insertBefore(XmlUtils.importElement(newDocument, traitWithComesAfter), insertBefore);
                        }
                    }
                    i.remove();
                }
            }
            return newInspectionResult;
        }
        catch (Exception e) {
            throw InspectionResultProcessorException.newException(e);
        }
    }

    protected boolean hasComesAfter(Element element, M metawidget) {
        return element.hasAttribute("comes-after");
    }

    protected String getComesAfter(Element element, M metawidget) {
        return element.getAttribute("comes-after");
    }

    @Override
    public /* synthetic */ Object processInspectionResultAsDom(Object x0, Object x1, Object x2, String x3, String[] x4) {
        return this.processInspectionResultAsDom((Element)x0, x1, x2, x3, x4);
    }
}

