/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl;

import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Map;
import org.metawidget.inspector.iface.DomInspector;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.BaseObjectInspectorConfig;
import org.metawidget.inspector.impl.Trait;
import org.metawidget.inspector.impl.actionstyle.Action;
import org.metawidget.inspector.impl.actionstyle.ActionStyle;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.inspector.impl.propertystyle.PropertyStyle;
import org.metawidget.inspector.impl.propertystyle.ValueAndDeclaredType;
import org.metawidget.util.ArrayUtils;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.LogUtils;
import org.metawidget.util.XmlUtils;
import org.metawidget.util.simple.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseObjectInspector
implements DomInspector<Element> {
    protected final LogUtils.Log mLog = LogUtils.getLog(this.getClass());
    private final PropertyStyle mPropertyStyle;
    private final ActionStyle mActionStyle;

    protected BaseObjectInspector() {
        this(new BaseObjectInspectorConfig());
    }

    protected BaseObjectInspector(BaseObjectInspectorConfig config) {
        this.mPropertyStyle = config.getPropertyStyle();
        this.mActionStyle = config.getActionStyle();
    }

    @Override
    public final String inspect(Object toInspect, String type, String[] names) {
        Element element = this.inspectAsDom(toInspect, type, names);
        if (element == null) {
            return null;
        }
        return XmlUtils.nodeToString((Node)element, false);
    }

    @Override
    public Element inspectAsDom(Object toInspect, String type, String[] names) {
        if (type == null) {
            return null;
        }
        try {
            Object childToInspect;
            Map<String, String> parentAttributes;
            String declaredChildType;
            String childName;
            boolean abortTraversingPastNull = false;
            if (toInspect != null) {
                ClassUtils.registerAlienClassLoader(toInspect.getClass().getClassLoader());
            }
            if (names != null && names.length > 0) {
                ValueAndDeclaredType valueAndDeclaredType = this.mPropertyStyle.traverse(toInspect, type, true, names);
                String parentType = valueAndDeclaredType.getDeclaredType();
                if (parentType == null) {
                    return null;
                }
                Object parent = valueAndDeclaredType.getValue();
                if (parent != null) {
                    parentType = parent.getClass().getName();
                }
                childName = names[names.length - 1];
                Property propertyInParent = this.mPropertyStyle.getProperties(parentType).get(childName);
                if (propertyInParent == null) {
                    throw InspectorException.newException(new StringBuffer().append("Parent of ").append(type).append(ArrayUtils.toString(names, StringUtils.SEPARATOR_FORWARD_SLASH, true, false)).append(" does not define a property '").append(childName).append("'").toString());
                }
                declaredChildType = propertyInParent.getType();
                parentAttributes = this.inspectParent(parent, propertyInParent);
                if (parent == null || !propertyInParent.isReadable()) {
                    childToInspect = null;
                } else {
                    childToInspect = propertyInParent.read(parent);
                    if (childToInspect == null) {
                        abortTraversingPastNull = true;
                    } else {
                        ClassUtils.registerAlienClassLoader(childToInspect.getClass().getClassLoader());
                    }
                }
            } else {
                childToInspect = toInspect;
                childName = null;
                declaredChildType = type;
                parentAttributes = null;
            }
            Document document = XmlUtils.newDocument();
            Element entity = document.createElementNS("http://metawidget.org/inspection-result", "entity");
            String actualChildType = childToInspect == null || ClassUtils.isPrimitive(declaredChildType) ? declaredChildType : childToInspect.getClass().getName();
            XmlUtils.setMapAsAttributes(entity, this.inspectEntity(declaredChildType, actualChildType));
            if (!abortTraversingPastNull) {
                this.inspectTraits(childToInspect, actualChildType, entity);
            }
            XmlUtils.setMapAsAttributes(entity, parentAttributes);
            if (this.isInspectionEmpty(entity)) {
                return null;
            }
            Element root = document.createElementNS("http://metawidget.org/inspection-result", "inspection-result");
            root.setAttribute("version", "1.0");
            document.appendChild(root);
            root.appendChild(entity);
            if (childName != null) {
                entity.setAttribute("name", childName);
            }
            entity.setAttribute("type", declaredChildType);
            return root;
        }
        catch (Exception e) {
            throw InspectorException.newException(e);
        }
    }

    protected Map<String, String> inspectParent(Object parentToInspect, Property propertyInParent) throws Exception {
        Map<String, String> traitAttributes = this.inspectTrait(propertyInParent);
        Map<String, String> propertyAttributes = this.inspectProperty(propertyInParent);
        if (traitAttributes == null) {
            return propertyAttributes;
        }
        if (propertyAttributes == null) {
            return traitAttributes;
        }
        traitAttributes.putAll(propertyAttributes);
        return traitAttributes;
    }

    protected void inspectTraits(Object toInspect, String type, Element toAddTo) throws Exception {
        Map<String, String> traitAttributes;
        Document document = toAddTo.getOwnerDocument();
        for (Property property : this.getProperties(type).values()) {
            traitAttributes = this.inspectTrait(property);
            Map<String, String> propertyAttributes = this.inspectProperty(property);
            Map<String, String> entityAttributes = this.inspectPropertyAsEntity(property, toInspect);
            if (!(traitAttributes != null && !traitAttributes.isEmpty() || propertyAttributes != null && !propertyAttributes.isEmpty() || entityAttributes != null && !entityAttributes.isEmpty())) continue;
            Element element = document.createElementNS("http://metawidget.org/inspection-result", "property");
            element.setAttribute("name", property.getName());
            XmlUtils.setMapAsAttributes(element, traitAttributes);
            XmlUtils.setMapAsAttributes(element, propertyAttributes);
            XmlUtils.setMapAsAttributes(element, entityAttributes);
            toAddTo.appendChild(element);
        }
        for (Action action : this.getActions(type).values()) {
            traitAttributes = this.inspectTrait(action);
            Map<String, String> actionAttributes = this.inspectAction(action);
            if (!(traitAttributes != null && !traitAttributes.isEmpty() || actionAttributes != null && !actionAttributes.isEmpty())) continue;
            Element element = document.createElementNS("http://metawidget.org/inspection-result", "action");
            element.setAttribute("name", action.getName());
            XmlUtils.setMapAsAttributes(element, traitAttributes);
            XmlUtils.setMapAsAttributes(element, actionAttributes);
            toAddTo.appendChild(element);
        }
    }

    protected Map<String, String> inspectEntity(String declaredClass, String actualClass) throws Exception {
        return null;
    }

    protected Map<String, String> inspectTrait(Trait trait) throws Exception {
        return null;
    }

    protected Map<String, String> inspectProperty(Property property) throws Exception {
        return null;
    }

    protected Map<String, String> inspectAction(Action action) throws Exception {
        return null;
    }

    protected boolean shouldInspectPropertyAsEntity(Property property) {
        return false;
    }

    protected final Map<String, Property> getProperties(String type) {
        if (this.mPropertyStyle == null) {
            Map map = Collections.EMPTY_MAP;
            return map;
        }
        return this.mPropertyStyle.getProperties(type);
    }

    protected final Map<String, Action> getActions(String type) {
        if (this.mActionStyle == null) {
            Map map = Collections.EMPTY_MAP;
            return map;
        }
        return this.mActionStyle.getActions(type);
    }

    private Map<String, String> inspectPropertyAsEntity(Property property, Object toInspect) throws Exception {
        if (!this.shouldInspectPropertyAsEntity(property)) {
            return null;
        }
        String actualType = property.getType();
        if (toInspect != null) {
            Class<?> actualClass = ClassUtils.niceForName(actualType);
            if (property.isReadable() && (actualClass == null || !Modifier.isFinal(actualClass.getModifiers()))) {
                Object propertyValue = null;
                try {
                    propertyValue = property.read(toInspect);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (propertyValue != null) {
                    actualType = propertyValue.getClass().getName();
                }
            }
        }
        return this.inspectEntity(property.getType(), actualType);
    }

    private boolean isInspectionEmpty(Element elementEntity) {
        if (elementEntity.hasAttributes()) {
            return false;
        }
        return !elementEntity.hasChildNodes();
    }

    @Override
    public /* synthetic */ Object inspectAsDom(Object x0, String x1, String[] x2) {
        return this.inspectAsDom(x0, x1, x2);
    }
}

