/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.statically.faces.component.html.widgetbuilder;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.metawidget.statically.StaticXmlMetawidget;
import org.metawidget.statically.StaticXmlStub;
import org.metawidget.statically.StaticXmlWidget;
import org.metawidget.statically.faces.StaticFacesUtils;
import org.metawidget.statically.faces.component.html.widgetbuilder.Facet;
import org.metawidget.statically.faces.component.html.widgetbuilder.HtmlColumn;
import org.metawidget.statically.faces.component.html.widgetbuilder.HtmlDataTable;
import org.metawidget.statically.faces.component.html.widgetbuilder.HtmlInputSecret;
import org.metawidget.statically.faces.component.html.widgetbuilder.HtmlInputText;
import org.metawidget.statically.faces.component.html.widgetbuilder.HtmlInputTextarea;
import org.metawidget.statically.faces.component.html.widgetbuilder.HtmlOutputText;
import org.metawidget.statically.faces.component.html.widgetbuilder.HtmlSelectBooleanCheckbox;
import org.metawidget.statically.faces.component.html.widgetbuilder.HtmlSelectOneMenu;
import org.metawidget.statically.faces.component.html.widgetbuilder.HtmlWidgetBuilderConfig;
import org.metawidget.statically.faces.component.html.widgetbuilder.SelectItem;
import org.metawidget.statically.faces.component.html.widgetbuilder.SelectItems;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.util.XmlUtils;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlWidgetBuilder
implements WidgetBuilder<StaticXmlWidget, StaticXmlMetawidget> {
    private static final String MAX_LENGTH = "maxLength";
    private final int mMaximumColumnsInDataTable;

    public HtmlWidgetBuilder() {
        this(new HtmlWidgetBuilderConfig());
    }

    public HtmlWidgetBuilder(HtmlWidgetBuilderConfig config) {
        this.mMaximumColumnsInDataTable = config.getMaximumColumnsInDataTable();
    }

    @Override
    public StaticXmlWidget buildWidget(String elementName, Map<String, String> attributes, StaticXmlMetawidget metawidget) {
        if ("true".equals(attributes.get("hidden"))) {
            return new StaticXmlStub();
        }
        if ("action".equals(elementName)) {
            return new StaticXmlStub();
        }
        String facesLookup = attributes.get("faces-lookup");
        if (facesLookup != null && !"".equals(facesLookup)) {
            HtmlSelectOneMenu select = new HtmlSelectOneMenu();
            this.addSelectItems(select, facesLookup, attributes);
            return select;
        }
        String type = WidgetBuilderUtils.getActualClassOrType(attributes);
        if (type == null) {
            return this.createHtmlInputText(attributes);
        }
        Class<?> clazz = ClassUtils.niceForName(type);
        if (Boolean.class.equals(clazz) && "true".equals(attributes.get("required"))) {
            return new HtmlSelectBooleanCheckbox();
        }
        String lookup = attributes.get("lookup");
        if (lookup != null && !"".equals(lookup)) {
            HtmlSelectOneMenu select = new HtmlSelectOneMenu();
            this.addSelectItems(select, CollectionUtils.fromString(lookup), CollectionUtils.fromString(attributes.get("lookup-labels")), attributes);
            return select;
        }
        if (clazz != null) {
            if (Boolean.TYPE.equals(clazz)) {
                return new HtmlSelectBooleanCheckbox();
            }
            if (clazz.isPrimitive()) {
                return this.createHtmlInputText(attributes);
            }
            if (String.class.equals(clazz)) {
                if ("true".equals(attributes.get("large"))) {
                    return new HtmlInputTextarea();
                }
                if ("true".equals(attributes.get("masked"))) {
                    HtmlInputSecret inputSecret = new HtmlInputSecret();
                    inputSecret.putAttribute(MAX_LENGTH, attributes.get("maximum-length"));
                    return inputSecret;
                }
                return this.createHtmlInputText(attributes);
            }
            if (Character.class.equals(clazz)) {
                HtmlInputText inputText = new HtmlInputText();
                inputText.putAttribute(MAX_LENGTH, "1");
                return inputText;
            }
            if (Date.class.equals(clazz)) {
                return this.createHtmlInputText(attributes);
            }
            if (Number.class.isAssignableFrom(clazz)) {
                return this.createHtmlInputText(attributes);
            }
            if (List.class.isAssignableFrom(clazz) || clazz.isArray()) {
                return this.createDataTableComponent(elementName, attributes, metawidget);
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return new StaticXmlStub();
            }
        }
        if ("true".equals(attributes.get("dont-expand"))) {
            return this.createHtmlInputText(attributes);
        }
        return null;
    }

    protected StaticXmlWidget createDataTableComponent(String elementName, Map<String, String> attributes, StaticXmlMetawidget metawidget) {
        HtmlDataTable dataTable = new HtmlDataTable();
        String dataTableVar = "_item";
        dataTable.putAttribute("var", dataTableVar);
        String componentType = WidgetBuilderUtils.getComponentType(attributes);
        String inspectedType = null;
        if (componentType != null) {
            inspectedType = metawidget.inspect(null, componentType, null);
        }
        if (inspectedType == null) {
            HashMap<String, String> columnAttributes = CollectionUtils.newHashMap();
            columnAttributes.put("name", attributes.get("name"));
            this.addColumnComponent(dataTable, attributes, "entity", columnAttributes, metawidget);
        } else {
            Element root = XmlUtils.documentFromString(inspectedType).getDocumentElement();
            NodeList elements = root.getFirstChild().getChildNodes();
            this.addColumnComponents(dataTable, attributes, elements, metawidget);
        }
        return dataTable;
    }

    protected void addColumnComponents(HtmlDataTable dataTable, Map<String, String> attributes, NodeList elements, StaticXmlMetawidget metawidget) {
        boolean onlyRequired = true;
        while (true) {
            int length = elements.getLength();
            for (int loop = 0; loop < length; ++loop) {
                Element element;
                Node node = elements.item(loop);
                if (!(node instanceof Element) || "action".equals((element = (Element)node).getNodeName()) || "true".equals(element.getAttribute("hidden")) || onlyRequired && !"true".equals(element.getAttribute("required"))) continue;
                this.addColumnComponent(dataTable, attributes, "property", XmlUtils.getAttributesAsMap(element), metawidget);
                if (dataTable.getChildren().size() == this.mMaximumColumnsInDataTable) break;
            }
            if (!dataTable.getChildren().isEmpty() || !onlyRequired) break;
            onlyRequired = false;
        }
    }

    protected void addColumnComponent(HtmlDataTable dataTable, Map<String, String> tableAttributes, String elementName, Map<String, String> columnAttributes, StaticXmlMetawidget metawidget) {
        HtmlColumn column = new HtmlColumn();
        HtmlOutputText columnText = new HtmlOutputText();
        String valueExpression = dataTable.getAttribute("var");
        if (!"entity".equals(elementName)) {
            valueExpression = valueExpression + '.' + columnAttributes.get("name");
        }
        columnText.putAttribute("value", StaticFacesUtils.wrapExpression(valueExpression));
        column.getChildren().add(columnText);
        HtmlOutputText headerText = new HtmlOutputText();
        headerText.putAttribute("value", metawidget.getLabelString(columnAttributes));
        Facet headerFacet = new Facet();
        headerFacet.putAttribute("name", "header");
        headerFacet.getChildren().add(headerText);
        column.getChildren().add(0, headerFacet);
        dataTable.getChildren().add(column);
    }

    protected void addSelectItems(HtmlSelectOneMenu select, String valueExpression, Map<String, String> attributes) {
        if (WidgetBuilderUtils.needsEmptyLookupItem(attributes)) {
            this.addSelectItem(select, "", null);
        }
        SelectItems selectItems = new SelectItems();
        selectItems.putAttribute("value", valueExpression);
        select.getChildren().add(selectItems);
    }

    private HtmlInputText createHtmlInputText(Map<String, String> attributes) {
        HtmlInputText inputText = new HtmlInputText();
        inputText.putAttribute(MAX_LENGTH, attributes.get("maximum-length"));
        return inputText;
    }

    private void addSelectItems(HtmlSelectOneMenu select, List<String> values, List<String> labels, Map<String, String> attributes) {
        if (values == null) {
            return;
        }
        if (WidgetBuilderUtils.needsEmptyLookupItem(attributes)) {
            this.addSelectItem(select, "", null);
        }
        int length = values.size();
        for (int loop = 0; loop < length; ++loop) {
            String value = values.get(loop);
            String label = null;
            if (labels != null && !labels.isEmpty()) {
                label = labels.get(loop);
            }
            this.addSelectItem(select, value, label);
        }
    }

    private void addSelectItem(HtmlSelectOneMenu select, String value, String label) {
        SelectItem selectItem = new SelectItem();
        selectItem.putAttribute("itemLabel", label);
        selectItem.putAttribute("itemValue", value);
        select.getChildren().add(selectItem);
    }
}

