/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.metawidget.util.simple.StringUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionUtils {
    public static final <T> ArrayList<T> newArrayList() {
        return new ArrayList();
    }

    public static final <T> ArrayList<T> newArrayList(Collection<T> collection) {
        return new ArrayList<T>(collection);
    }

    public static final <T> ArrayList<T> newArrayList(int capacity) {
        return new ArrayList(capacity);
    }

    public static final <T> ArrayList<T> newArrayList(T[] array) {
        if (array == null) {
            return new ArrayList();
        }
        return new ArrayList<T>(Arrays.asList(array));
    }

    public static final <K> HashSet<K> newHashSet() {
        return new HashSet();
    }

    public static final <K> HashSet<K> newHashSet(Collection<K> set) {
        return new HashSet<K>(set);
    }

    public static final <K> HashSet<K> newHashSet(K[] array) {
        return new HashSet<K>(Arrays.asList(array));
    }

    public static final <K> Stack<K> newStack() {
        return new Stack();
    }

    public static final <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static final <K, V> HashMap<K, V> newHashMap(Map<K, V> map) {
        return new HashMap<K, V>(map);
    }

    public static final <K, V> HashMap<K, V> newHashMap(int size) {
        return new HashMap(size);
    }

    public static final <K, V> WeakHashMap<K, V> newWeakHashMap() {
        return new WeakHashMap();
    }

    public static final <K, V> LinkedHashMap<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static final <K, V> LinkedHashMap<K, V> newLinkedHashMap(Map<K, V> map) {
        return new LinkedHashMap<K, V>(map);
    }

    public static final <K, V> TreeMap<K, V> newTreeMap() {
        return new TreeMap();
    }

    public static final <K, V> TreeMap<K, V> newTreeMap(Comparator<K> comparator) {
        return new TreeMap(comparator);
    }

    public static <T> List<T> unmodifiableList(T[] array) {
        return Collections.unmodifiableList(Arrays.asList(array));
    }

    public static <T> String toString(Collection<T> collection) {
        return CollectionUtils.toString(collection, StringUtils.SEPARATOR_COMMA);
    }

    public static <T> String toString(Collection<T> collection, String separator) {
        return CollectionUtils.toString(collection, separator, false, false);
    }

    public static <T> String toString(Collection<T> collection, String separator, boolean leadingSeparator, boolean trailingSeparator) {
        if (collection == null) {
            return "";
        }
        Collection<T> consistentlyOrderedCollection = collection;
        if (consistentlyOrderedCollection instanceof Set) {
            consistentlyOrderedCollection = CollectionUtils.newArrayList(collection);
            Collections.sort((List)consistentlyOrderedCollection, null);
        }
        Pattern patternSeparator = Pattern.compile(separator, 16);
        String replacement = new StringBuffer().append("\\\\").append(separator).toString();
        StringBuffer buffer = new StringBuffer();
        for (T t : consistentlyOrderedCollection) {
            String value = String.valueOf(t);
            if (buffer.length() > 0 || leadingSeparator) {
                buffer.append(separator);
            }
            value = patternSeparator.matcher(value).replaceAll(replacement);
            buffer.append(value);
        }
        if (trailingSeparator && buffer.length() > 0) {
            buffer.append(separator);
        }
        return buffer.toString();
    }

    public static List<String> fromString(String collection) {
        return CollectionUtils.fromString(collection, ',');
    }

    public static List<String> fromString(String collection, char separator) {
        if (collection == null || collection.length() == 0) {
            List list = Collections.EMPTY_LIST;
            return list;
        }
        ArrayList<String> split = CollectionUtils.newArrayList();
        Pattern patternSplit = Pattern.compile(new StringBuffer().append("((\\\\").append(separator).append("|[^").append(separator).append("])*)(").append(separator).append("|$)").toString());
        Pattern patternSeparator = Pattern.compile(new StringBuffer().append("\\").append(separator).toString(), 16);
        String replacement = String.valueOf(separator);
        Matcher matcher = patternSplit.matcher(collection);
        while (matcher.find()) {
            String match = matcher.group(1).trim();
            match = patternSeparator.matcher(match).replaceAll(replacement);
            split.add(match);
            if (matcher.end(1) != collection.length()) continue;
            break;
        }
        return split;
    }

    private CollectionUtils() {
    }
}

