/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.util.simple;

import java.util.Map;
import org.metawidget.iface.Immutable;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleLayoutUtils {
    private static final char MNEMONIC_INDICATOR = '&';
    private static final int MNEMONIC_INDEX_NONE = -1;

    public static boolean isSpanAllColumns(Map<String, String> attributes) {
        if (attributes == null) {
            return false;
        }
        if ("true".equals(attributes.get("large"))) {
            return true;
        }
        return "true".equals(attributes.get("wide"));
    }

    public static boolean needsLabel(String labelText, String elementName) {
        if (labelText == null) {
            return false;
        }
        if (labelText.trim().length() == 0) {
            return false;
        }
        return !"action".equals(elementName);
    }

    public static StrippedMnemonicAndFirstIndex stripMnemonic(String withMnemonic) {
        int markerIndex = withMnemonic.indexOf(38);
        if (markerIndex == -1) {
            return new StrippedMnemonicAndFirstIndex(withMnemonic, -1);
        }
        int mnemonicIndex = -1;
        int beginIndex = 0;
        int length = withMnemonic.length();
        int numberOfDoubleMarkers = 0;
        StringBuffer buffer = new StringBuffer();
        while (++markerIndex != length) {
            char markerChar = withMnemonic.charAt(markerIndex);
            switch (markerChar) {
                case '&': {
                    ++numberOfDoubleMarkers;
                    break;
                }
                case ' ': {
                    break;
                }
                default: {
                    --markerIndex;
                    if (mnemonicIndex != -1) break;
                    mnemonicIndex = markerIndex - numberOfDoubleMarkers;
                }
            }
            buffer.append(withMnemonic.substring(beginIndex, markerIndex));
            beginIndex = markerIndex + 1;
            if (markerChar == ' ') {
                buffer.append(' ');
            }
            if (beginIndex < length && (markerIndex = withMnemonic.indexOf(38, beginIndex)) != -1) continue;
        }
        buffer.append(withMnemonic.substring(beginIndex));
        return new StrippedMnemonicAndFirstIndex(buffer.toString(), mnemonicIndex);
    }

    private SimpleLayoutUtils() {
    }

    public static class StrippedMnemonicAndFirstIndex
    implements Immutable {
        private String mStrippedMnemonic;
        private int mFirstIndex;

        public StrippedMnemonicAndFirstIndex(String strippedMnemonic, int firstIndex) {
            this.mStrippedMnemonic = strippedMnemonic;
            this.mFirstIndex = firstIndex;
        }

        public String getStrippedMnemonic() {
            return this.mStrippedMnemonic;
        }

        public int getFirstIndex() {
            return this.mFirstIndex;
        }
    }
}

