/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.faces;

import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FacesUtils {
    private static final Pattern PATTERN_EXPRESSION;
    private static final String EXPRESSION_START = "#{";
    private static final String EXPRESSION_END = "}";
    private static final boolean IS_JSF_2;

    public static boolean isExpression(String value) {
        return FacesUtils.matchExpression(value).matches();
    }

    public static Matcher matchExpression(String value) {
        return PATTERN_EXPRESSION.matcher(value);
    }

    public static String unwrapExpression(String value) {
        Matcher matcher = PATTERN_EXPRESSION.matcher(value);
        if (!matcher.matches()) {
            return value;
        }
        return matcher.group(2);
    }

    public static String wrapExpression(String value) {
        if (FacesUtils.isExpression(value)) {
            return value;
        }
        return new StringBuffer().append(EXPRESSION_START).append(FacesUtils.unwrapExpression(value)).append(EXPRESSION_END).toString();
    }

    public static void render(FacesContext context, UIComponent component) throws IOException {
        if (component == null || !component.isRendered()) {
            return;
        }
        component.encodeBegin(context);
        if (component.getRendersChildren()) {
            component.encodeChildren(context);
        } else {
            FacesUtils.renderChildren(context, component);
        }
        component.encodeEnd(context);
    }

    public static boolean isJsf2() {
        return IS_JSF_2;
    }

    public static boolean isValidationFailed() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (FacesUtils.isJsf2()) {
            return FacesContext.getCurrentInstance().isValidationFailed();
        }
        return context.getMaximumSeverity() != null;
    }

    public static boolean isPartialStateSavingDisabled() {
        FacesContext context = FacesContext.getCurrentInstance();
        return "false".equals(context.getExternalContext().getInitParameter("javax.faces.PARTIAL_STATE_SAVING"));
    }

    public static <T extends UIComponent> T createComponent(String componentType, String rendererType) {
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        if (FacesUtils.isJsf2()) {
            return (T)application.createComponent(context, componentType, rendererType);
        }
        return (T)application.createComponent(componentType);
    }

    public static void setStyleAndStyleClass(UIComponent component, String style, String styleClass) {
        Map attributes = component.getAttributes();
        if (style != null) {
            String existingStyle = (String)attributes.get("style");
            if (existingStyle == null || "".equals(existingStyle)) {
                attributes.put("style", style);
            } else {
                attributes.put("style", new StringBuffer().append(existingStyle).append(" ").append(style).toString());
            }
        }
        if (styleClass != null) {
            String existingStyleClass = (String)attributes.get("styleClass");
            if (existingStyleClass == null || "".equals(existingStyleClass)) {
                attributes.put("styleClass", styleClass);
            } else {
                attributes.put("styleClass", new StringBuffer().append(existingStyleClass).append(" ").append(styleClass).toString());
            }
        }
    }

    private static void renderChildren(FacesContext context, UIComponent component) throws IOException {
        for (UIComponent componentChild : component.getChildren()) {
            FacesUtils.render(context, componentChild);
        }
    }

    private FacesUtils() {
    }

    static {
        boolean isJsf2;
        PATTERN_EXPRESSION = Pattern.compile("(#|\\$)\\{([^\\}]+)\\}");
        try {
            Class.forName("javax.faces.event.PreRenderViewEvent");
            isJsf2 = true;
        }
        catch (ClassNotFoundException e) {
            isJsf2 = false;
        }
        IS_JSF_2 = isJsf2;
    }
}

