/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.faces;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.metawidget.inspector.faces.UiFacesAjax;
import org.metawidget.inspector.faces.UiFacesComponent;
import org.metawidget.inspector.faces.UiFacesConverter;
import org.metawidget.inspector.faces.UiFacesDateTimeConverter;
import org.metawidget.inspector.faces.UiFacesLookup;
import org.metawidget.inspector.faces.UiFacesNumberConverter;
import org.metawidget.inspector.faces.UiFacesSuggest;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.BaseObjectInspector;
import org.metawidget.inspector.impl.BaseObjectInspectorConfig;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesInspector
extends BaseObjectInspector {
    private static final Pattern PATTERN_EXPRESSION = Pattern.compile("((#|\\$)\\{)(.*)(\\})");

    public FacesInspector() {
        this(new BaseObjectInspectorConfig());
    }

    public FacesInspector(BaseObjectInspectorConfig config) {
        super(config);
    }

    @Override
    protected Map<String, String> inspectProperty(Property property) throws Exception {
        UiFacesDateTimeConverter dateTimeConverter;
        UiFacesNumberConverter numberConverter;
        UiFacesConverter converter;
        UiFacesAjax ajax;
        UiFacesComponent component;
        UiFacesSuggest facesSuggest;
        HashMap<String, String> attributes = CollectionUtils.newHashMap();
        UiFacesLookup facesLookup = property.getAnnotation(UiFacesLookup.class);
        if (facesLookup != null) {
            this.putExpression(attributes, "faces-lookup", facesLookup.value());
            String var = facesLookup.var();
            if (!"".equals(var)) {
                attributes.put("faces-lookup-var", var);
            }
            this.putExpression(attributes, "faces-lookup-item-value", facesLookup.itemValue());
            this.putExpression(attributes, "faces-lookup-item-label", facesLookup.itemLabel());
        }
        if ((facesSuggest = property.getAnnotation(UiFacesSuggest.class)) != null) {
            this.putExpression(attributes, "faces-suggest", facesSuggest.value());
        }
        if ((component = property.getAnnotation(UiFacesComponent.class)) != null) {
            attributes.put("faces-component", component.value());
        }
        if ((ajax = property.getAnnotation(UiFacesAjax.class)) != null) {
            attributes.put("faces-ajax-event", ajax.event());
            this.putExpression(attributes, "faces-ajax-action", ajax.action());
        }
        if ((converter = property.getAnnotation(UiFacesConverter.class)) != null) {
            attributes.put("faces-converter-id", converter.value());
        }
        if ((numberConverter = property.getAnnotation(UiFacesNumberConverter.class)) != null) {
            if (!"".equals(numberConverter.currencyCode())) {
                attributes.put("currency-code", numberConverter.currencyCode());
            }
            if (!"".equals(numberConverter.currencySymbol())) {
                attributes.put("currency-symbol", numberConverter.currencySymbol());
            }
            if (numberConverter.groupingUsed()) {
                attributes.put("number-uses-grouping-separators", "true");
            }
            if (numberConverter.minIntegerDigits() != -1) {
                attributes.put("minimum-integer-digits", String.valueOf(numberConverter.minIntegerDigits()));
            }
            if (numberConverter.maxIntegerDigits() != -1) {
                attributes.put("maximum-integer-digits", String.valueOf(numberConverter.maxIntegerDigits()));
            }
            if (numberConverter.minFractionDigits() != -1) {
                attributes.put("minimum-fractional-digits", String.valueOf(numberConverter.minFractionDigits()));
            }
            if (numberConverter.maxFractionDigits() != -1) {
                attributes.put("maximum-fractional-digits", String.valueOf(numberConverter.maxFractionDigits()));
            }
            if (!"".equals(numberConverter.locale())) {
                attributes.put("locale", numberConverter.locale());
            }
            if (!"".equals(numberConverter.pattern())) {
                attributes.put("number-pattern", numberConverter.pattern());
            }
            if (!"".equals(numberConverter.type())) {
                attributes.put("number-type", numberConverter.type());
            }
        }
        if ((dateTimeConverter = property.getAnnotation(UiFacesDateTimeConverter.class)) != null) {
            if (!"".equals(dateTimeConverter.dateStyle())) {
                attributes.put("date-style", dateTimeConverter.dateStyle());
            }
            if (!"".equals(dateTimeConverter.locale())) {
                attributes.put("locale", dateTimeConverter.locale());
            }
            if (!"".equals(dateTimeConverter.pattern())) {
                attributes.put("datetime-pattern", dateTimeConverter.pattern());
            }
            if (!"".equals(dateTimeConverter.timeStyle())) {
                attributes.put("time-style", dateTimeConverter.timeStyle());
            }
            if (!"".equals(dateTimeConverter.timeZone())) {
                attributes.put("time-zone", dateTimeConverter.timeZone());
            }
            if (!"".equals(dateTimeConverter.type())) {
                attributes.put("datetime-type", dateTimeConverter.type());
            }
        }
        return attributes;
    }

    private void putExpression(Map<String, String> attributes, String attributeName, String expression) {
        if ("".equals(expression)) {
            return;
        }
        if (!this.isExpression(expression)) {
            throw InspectorException.newException("Expression '" + expression + "' (for '" + attributeName + "') is not of the form #{...}");
        }
        attributes.put(attributeName, expression);
    }

    private boolean isExpression(String value) {
        return PATTERN_EXPRESSION.matcher(value).matches();
    }
}

