/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl.propertystyle;

import java.util.HashSet;
import java.util.Map;
import org.metawidget.inspector.impl.BaseTraitStyle;
import org.metawidget.inspector.impl.BaseTraitStyleConfig;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.inspector.impl.propertystyle.PropertyStyle;
import org.metawidget.inspector.impl.propertystyle.ValueAndDeclaredType;
import org.metawidget.util.ArrayUtils;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.simple.StringUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasePropertyStyle
extends BaseTraitStyle<Property>
implements PropertyStyle {
    protected BasePropertyStyle(BaseTraitStyleConfig config) {
        super(config);
    }

    @Override
    public Map<String, Property> getProperties(String type) {
        return this.getTraits(type);
    }

    @Override
    public ValueAndDeclaredType traverse(Object toTraverse, String type, boolean onlyToParent, String[] names) {
        if (toTraverse == null) {
            if (names != null && names.length > 0) {
                return new ValueAndDeclaredType(null, null);
            }
            return new ValueAndDeclaredType(null, type);
        }
        Class<?> sanityCheck = ClassUtils.niceForName(type, toTraverse.getClass().getClassLoader());
        if (sanityCheck != null && !sanityCheck.isAssignableFrom(toTraverse.getClass())) {
            return new ValueAndDeclaredType(null, null);
        }
        Object traverse = toTraverse;
        String traverseDeclaredType = type;
        if (names == null || names.length == 0) {
            if (onlyToParent) {
                return new ValueAndDeclaredType(null, null);
            }
        } else {
            HashSet traversed = CollectionUtils.newHashSet();
            traversed.add(traverse);
            int length = names.length;
            for (int loop = 0; loop < length; ++loop) {
                String name = names[loop];
                Property property = this.getProperties(traverse.getClass().getName()).get(name);
                if (property == null || !property.isReadable()) {
                    return new ValueAndDeclaredType(null, null);
                }
                Object parentTraverse = traverse;
                if (!traversed.add(traverse = property.read(traverse))) {
                    this.mLog.trace("Prevented infinite recursion on {0}{1}. Consider marking {2} as hidden", new Object[]{type, ArrayUtils.toString(names, StringUtils.SEPARATOR_FORWARD_SLASH, true, false), name});
                    return new ValueAndDeclaredType(null, null);
                }
                if (onlyToParent && loop >= length - 1) {
                    return new ValueAndDeclaredType(parentTraverse, traverseDeclaredType);
                }
                traverseDeclaredType = property.getType();
                if (traverse != null) continue;
                if (loop == length - 1) {
                    return new ValueAndDeclaredType(null, traverseDeclaredType);
                }
                return new ValueAndDeclaredType(null, null);
            }
        }
        return new ValueAndDeclaredType(traverse, traverseDeclaredType);
    }

    @Override
    protected final Map<String, Property> getUncachedTraits(String type) {
        return this.inspectProperties(type);
    }

    protected abstract Map<String, Property> inspectProperties(String var1);
}

