/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.metawidget.util.simple.StringUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Java5ClassUtils {
    public static <T extends Annotation> T getOriginalAnnotation(Method method, Class<T> annotationClass) {
        T annotation;
        Method methodToUse = method;
        String name = methodToUse.getName();
        Class<?>[] parameterTypes = methodToUse.getParameterTypes();
        while (methodToUse.getAnnotations().length == 0) {
            Class<?> superclass = methodToUse.getDeclaringClass().getSuperclass();
            methodToUse = null;
            while (superclass != null) {
                try {
                    methodToUse = superclass.getDeclaredMethod(name, parameterTypes);
                    break;
                }
                catch (Exception e) {
                    superclass = superclass.getSuperclass();
                }
            }
            if (methodToUse != null) continue;
            break;
        }
        if (methodToUse != null && (annotation = methodToUse.getAnnotation(annotationClass)) != null) {
            return annotation;
        }
        for (Class<?> iface : method.getDeclaringClass().getInterfaces()) {
            try {
                methodToUse = iface.getDeclaredMethod(name, parameterTypes);
                T annotation2 = methodToUse.getAnnotation(annotationClass);
                if (annotation2 == null) continue;
                return annotation2;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    public static Type getOriginalGenericReturnType(Method method) {
        Method methodToUse = method;
        String name = methodToUse.getName();
        Class<?>[] parameterTypes = methodToUse.getParameterTypes();
        block2: do {
            Type type;
            if ((type = methodToUse.getGenericReturnType()) instanceof ParameterizedType) {
                return type;
            }
            Class<?> superclass = methodToUse.getDeclaringClass().getSuperclass();
            methodToUse = null;
            while (superclass != null) {
                try {
                    methodToUse = superclass.getDeclaredMethod(name, parameterTypes);
                    continue block2;
                }
                catch (Exception e) {
                    superclass = superclass.getSuperclass();
                }
            }
        } while (methodToUse != null);
        return method.getGenericReturnType();
    }

    public static Type[] getOriginalGenericParameterTypes(Method method) {
        Method methodToUse = method;
        String name = methodToUse.getName();
        Class<?>[] parameterTypes = methodToUse.getParameterTypes();
        block2: do {
            Type[] type;
            if ((type = methodToUse.getGenericParameterTypes())[0] instanceof ParameterizedType) {
                return type;
            }
            Class<?> superclass = methodToUse.getDeclaringClass().getSuperclass();
            methodToUse = null;
            while (superclass != null) {
                try {
                    methodToUse = superclass.getDeclaredMethod(name, parameterTypes);
                    continue block2;
                }
                catch (Exception e) {
                    superclass = superclass.getSuperclass();
                }
            }
        } while (methodToUse != null);
        return method.getGenericParameterTypes();
    }

    public static String getGenericTypeAsString(Type type) {
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        Type[] typeActuals = null;
        try {
            typeActuals = ((ParameterizedType)type).getActualTypeArguments();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (typeActuals == null || typeActuals.length == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (Type typeActual : typeActuals) {
            if (typeActual == null) continue;
            if (builder.length() > 0) {
                builder.append(StringUtils.SEPARATOR_COMMA);
            }
            if (typeActual instanceof Class) {
                builder.append(((Class)typeActual).getName());
                continue;
            }
            builder.append(typeActual.toString());
        }
        return builder.toString();
    }

    private Java5ClassUtils() {
    }
}

