/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspectionresultprocessor.jsp;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.el.ExpressionEvaluator;
import javax.servlet.jsp.el.VariableResolver;
import org.metawidget.inspectionresultprocessor.iface.InspectionResultProcessorException;
import org.metawidget.inspectionresultprocessor.impl.BaseInspectionResultProcessor;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.jsp.tagext.MetawidgetTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JspInspectionResultProcessor
extends BaseInspectionResultProcessor<MetawidgetTag> {
    private static final Pattern PATTERN_EXPRESSION = Pattern.compile("\\$\\{([^\\}]+)\\}");

    @Override
    protected void processAttributes(Map<String, String> attributes, MetawidgetTag metawidgetTag) {
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if ("jsp-lookup".equals(key)) continue;
            Matcher matcher = PATTERN_EXPRESSION.matcher(value);
            int matchOffset = 0;
            while (matcher.find()) {
                ExpressionEvaluator expressionEvaluator;
                String expression = matcher.group(0);
                PageContext pageContext = metawidgetTag.getPageContext();
                try {
                    expressionEvaluator = pageContext.getExpressionEvaluator();
                }
                catch (Exception e) {
                    throw InspectorException.newException("ExpressionEvaluator requires JSP 2.0");
                }
                try {
                    String valueObjectAsString;
                    VariableResolver variableResolver = pageContext.getVariableResolver();
                    Object valueObject = expressionEvaluator.evaluate(expression, Object.class, variableResolver, null);
                    if (valueObject == null) {
                        if (matcher.start() == 0 && matcher.end() == value.length()) {
                            value = null;
                            break;
                        }
                        valueObjectAsString = "";
                    } else {
                        if (matcher.start() == 0 && matcher.end() == value.length()) {
                            value = String.valueOf(valueObject);
                            break;
                        }
                        valueObjectAsString = String.valueOf(valueObject);
                    }
                    value = new StringBuilder(value).replace(matcher.start() + matchOffset, matcher.end() + matchOffset, valueObjectAsString).toString();
                    matchOffset += valueObjectAsString.length() - (matcher.end() - matcher.start());
                }
                catch (Exception e) {
                    throw InspectionResultProcessorException.newException("Unable to evaluate " + value, e);
                }
            }
            attributes.put(key, value);
        }
    }
}

