/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.statically.jsp.html.widgetbuilder;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.metawidget.statically.StaticXmlMetawidget;
import org.metawidget.statically.StaticXmlStub;
import org.metawidget.statically.StaticXmlWidget;
import org.metawidget.statically.jsp.StaticJspUtils;
import org.metawidget.statically.jsp.html.widgetbuilder.CoreForEach;
import org.metawidget.statically.jsp.html.widgetbuilder.CoreOut;
import org.metawidget.statically.jsp.html.widgetbuilder.HtmlInput;
import org.metawidget.statically.jsp.html.widgetbuilder.HtmlOption;
import org.metawidget.statically.jsp.html.widgetbuilder.HtmlSelect;
import org.metawidget.statically.jsp.html.widgetbuilder.HtmlTable;
import org.metawidget.statically.jsp.html.widgetbuilder.HtmlTableBody;
import org.metawidget.statically.jsp.html.widgetbuilder.HtmlTableCell;
import org.metawidget.statically.jsp.html.widgetbuilder.HtmlTableHead;
import org.metawidget.statically.jsp.html.widgetbuilder.HtmlTableHeader;
import org.metawidget.statically.jsp.html.widgetbuilder.HtmlTableRow;
import org.metawidget.statically.jsp.html.widgetbuilder.HtmlTextarea;
import org.metawidget.statically.jsp.html.widgetbuilder.HtmlWidgetBuilderConfig;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.util.XmlUtils;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlWidgetBuilder
implements WidgetBuilder<StaticXmlWidget, StaticXmlMetawidget> {
    private static final String MAX_LENGTH = "maxlength";
    private final int mMaximumColumnsInDataTable;

    public HtmlWidgetBuilder() {
        this(new HtmlWidgetBuilderConfig());
    }

    public HtmlWidgetBuilder(HtmlWidgetBuilderConfig config) {
        this.mMaximumColumnsInDataTable = config.getMaximumColumnsInDataTable();
    }

    @Override
    public StaticXmlWidget buildWidget(String elementName, Map<String, String> attributes, StaticXmlMetawidget metawidget) {
        if ("true".equals(attributes.get("hidden"))) {
            return new StaticXmlStub();
        }
        if ("action".equals(elementName)) {
            return new StaticXmlStub();
        }
        String jspLookup = attributes.get("jsp-lookup");
        if (jspLookup != null && !"".equals(jspLookup)) {
            HtmlSelect select = new HtmlSelect();
            this.addSelectItems(select, jspLookup, attributes);
            return select;
        }
        String type = WidgetBuilderUtils.getActualClassOrType(attributes);
        if (type == null) {
            return this.createHtmlInputText(attributes);
        }
        Class<?> clazz = ClassUtils.niceForName(type);
        if (Boolean.class.equals(clazz) && "true".equals(attributes.get("required"))) {
            return this.createHtmlCheckbox();
        }
        String lookup = attributes.get("lookup");
        if (lookup != null && !"".equals(lookup)) {
            HtmlSelect select = new HtmlSelect();
            this.addSelectItems(select, CollectionUtils.fromString(lookup), CollectionUtils.fromString(attributes.get("lookup-labels")), attributes);
            return select;
        }
        if (clazz != null) {
            if (clazz.isPrimitive()) {
                if (Boolean.TYPE.equals(clazz)) {
                    return this.createHtmlCheckbox();
                }
                if (Character.TYPE.equals(clazz)) {
                    attributes.put("maximum-length", "1");
                    HtmlInput characterInput = this.createHtmlInputText(attributes);
                    return characterInput;
                }
                return this.createHtmlInputText(attributes);
            }
            if (String.class.equals(clazz)) {
                if ("true".equals(attributes.get("large"))) {
                    return this.createHtmlTextareaTag(attributes);
                }
                if ("true".equals(attributes.get("masked"))) {
                    HtmlInput secret = this.createHtmlInputText(attributes);
                    secret.putAttribute("type", "secret");
                    return secret;
                }
                return this.createHtmlInputText(attributes);
            }
            if (Character.class.equals(clazz)) {
                attributes.put("maximum-length", "1");
                HtmlInput characterInput = this.createHtmlInputText(attributes);
                return characterInput;
            }
            if (Date.class.equals(clazz)) {
                return this.createHtmlInputText(attributes);
            }
            if (Number.class.isAssignableFrom(clazz)) {
                return this.createHtmlInputText(attributes);
            }
            if (List.class.isAssignableFrom(clazz) || clazz.isArray()) {
                return this.createDataTableComponent(elementName, attributes, metawidget);
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return new StaticXmlStub();
            }
        }
        if ("true".equals(attributes.get("dont-expand"))) {
            return this.createHtmlInputText(attributes);
        }
        return null;
    }

    protected StaticXmlWidget createDataTableComponent(String elementName, Map<String, String> attributes, StaticXmlMetawidget metawidget) {
        HtmlTable table = new HtmlTable();
        CoreForEach forEach = new CoreForEach();
        String items = attributes.get("name");
        if (items != null) {
            items = StaticJspUtils.wrapExpression(items);
        }
        forEach.putAttribute("items", items);
        String var = "item";
        forEach.putAttribute("var", var);
        HtmlTableHead tableHead = new HtmlTableHead();
        table.getChildren().add(tableHead);
        tableHead.getChildren().add(new HtmlTableRow());
        HtmlTableBody body = new HtmlTableBody();
        body.getChildren().add(forEach);
        table.getChildren().add(body);
        String componentType = WidgetBuilderUtils.getComponentType(attributes);
        String inspectedType = null;
        if (componentType != null) {
            inspectedType = metawidget.inspect(null, componentType, null);
        }
        if (inspectedType == null) {
            HtmlTableRow row = new HtmlTableRow();
            forEach.getChildren().add(row);
            HashMap<String, String> columnAttributes = CollectionUtils.newHashMap();
            columnAttributes.put("name", attributes.get("name"));
            this.addColumnComponent(row, forEach, attributes, "entity", columnAttributes);
        } else {
            Element root = XmlUtils.documentFromString(inspectedType).getDocumentElement();
            NodeList elements = root.getFirstChild().getChildNodes();
            this.addColumnComponents(table, forEach, attributes, elements, metawidget);
        }
        return table;
    }

    protected void addColumnComponents(HtmlTable table, CoreForEach forEach, Map<String, String> attributes, NodeList elements, StaticXmlMetawidget metawidget) {
        boolean onlyRequired = true;
        while (true) {
            HtmlTableRow row = new HtmlTableRow();
            for (int i = 0; i < elements.getLength(); ++i) {
                Element element;
                Node node = elements.item(i);
                if (!(node instanceof Element) || "action".equals((element = (Element)node).getNodeName()) || "true".equals(element.getAttribute("hidden")) || onlyRequired && !"true".equals(element.getAttribute("required"))) continue;
                this.addColumnComponent(row, forEach, attributes, "property", XmlUtils.getAttributesAsMap(element));
                this.addColumnHeader(table, XmlUtils.getAttributesAsMap(element), metawidget);
                if (row.getChildren().size() == this.mMaximumColumnsInDataTable) break;
            }
            if (!row.getChildren().isEmpty()) {
                forEach.getChildren().add(row);
            }
            if (!forEach.getChildren().isEmpty() || !onlyRequired) break;
            onlyRequired = false;
        }
    }

    protected void addColumnComponent(HtmlTableRow row, CoreForEach forEach, Map<String, String> tableAttributes, String elementName, Map<String, String> columnAttributes) {
        HtmlTableCell cell = new HtmlTableCell();
        row.getChildren().add(cell);
        String valueExpression = forEach.getAttribute("var");
        if (!"entity".equals(elementName)) {
            valueExpression = valueExpression + '.' + columnAttributes.get("name");
        }
        CoreOut out = new CoreOut();
        out.putAttribute("value", StaticJspUtils.wrapExpression(valueExpression));
        cell.getChildren().add(out);
    }

    protected void addSelectItems(HtmlSelect select, String valueExpression, Map<String, String> attributes) {
        if (WidgetBuilderUtils.needsEmptyLookupItem(attributes)) {
            this.addSelectItem(select, "", null);
        }
        this.addSelectItem(select, valueExpression, null);
    }

    protected void addSelectItems(HtmlSelect select, List<String> values, List<String> labels, Map<String, String> attributes) {
        if (values == null) {
            return;
        }
        if (WidgetBuilderUtils.needsEmptyLookupItem(attributes)) {
            this.addSelectItem(select, "", null);
        }
        int length = values.size();
        for (int i = 0; i < length; ++i) {
            String value = values.get(i);
            String label = null;
            if (labels != null && !labels.isEmpty()) {
                label = labels.get(i);
            }
            this.addSelectItem(select, value, label);
        }
    }

    protected void addColumnHeader(HtmlTable table, Map<String, String> attributes, StaticXmlMetawidget metawidget) {
        HtmlTableHeader header = new HtmlTableHeader();
        header.setTextContent(metawidget.getLabelString(attributes));
        table.getChildren().get(0).getChildren().get(0).getChildren().add(header);
    }

    private StaticXmlWidget createHtmlCheckbox() {
        HtmlInput checkbox = new HtmlInput();
        checkbox.putAttribute("type", "checkbox");
        return checkbox;
    }

    private HtmlInput createHtmlInputText(Map<String, String> attributes) {
        HtmlInput input = new HtmlInput();
        input.putAttribute("type", "text");
        input.putAttribute(MAX_LENGTH, attributes.get("maximum-length"));
        return input;
    }

    private StaticXmlWidget createHtmlTextareaTag(Map<String, String> attributes) {
        String rows;
        HtmlTextarea textarea = new HtmlTextarea();
        String cols = attributes.get("cols");
        if (cols != null) {
            textarea.putAttribute("cols", cols);
        }
        if ((rows = attributes.get("rows")) != null) {
            textarea.putAttribute("rows", rows);
        }
        return textarea;
    }

    private void addSelectItem(HtmlSelect select, String value, String label) {
        HtmlOption selectItem = new HtmlOption();
        selectItem.putAttribute("value", value);
        if (label != null) {
            selectItem.setTextContent(label);
        }
        select.getChildren().add(selectItem);
    }
}

