/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessControlException;
import java.util.Set;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.simple.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassUtils {
    public static final String JAVABEAN_SET_PREFIX = "set";
    public static final String JAVABEAN_GET_PREFIX = "get";
    public static final String JAVABEAN_IS_PREFIX = "is";
    static final Set<ClassLoader> ALIEN_CLASSLOADERS = CollectionUtils.newHashSet();

    public static Method getReadMethod(Class<?> clazz, String property) {
        String propertyUppercased = StringUtils.capitalize(property);
        try {
            return clazz.getMethod(JAVABEAN_GET_PREFIX + propertyUppercased, new Class[0]);
        }
        catch (Exception e1) {
            try {
                Method method = clazz.getMethod(JAVABEAN_IS_PREFIX + propertyUppercased, new Class[0]);
                if (Boolean.TYPE.equals(method.getReturnType())) {
                    return method;
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw new RuntimeException("No such method get" + propertyUppercased + " (or boolean " + JAVABEAN_IS_PREFIX + propertyUppercased + ") on " + clazz);
        }
    }

    public static Method getWriteMethod(Class<?> clazz, String property, Class<?> type) {
        String propertyUppercased = StringUtils.capitalize(property);
        for (Class<?> typeSuper = type; typeSuper != null; typeSuper = typeSuper.getSuperclass()) {
            try {
                return clazz.getMethod(JAVABEAN_SET_PREFIX + propertyUppercased, typeSuper);
            }
            catch (Exception e) {
                continue;
            }
        }
        for (Class<?> anInterface : type.getInterfaces()) {
            try {
                return clazz.getMethod(JAVABEAN_SET_PREFIX + propertyUppercased, anInterface);
            }
            catch (Exception e) {
            }
        }
        throw new RuntimeException("No such method set" + propertyUppercased + "( " + type.getName() + " ) on " + clazz);
    }

    public static <T> T getProperty(Object base, String property) {
        try {
            Method method = ClassUtils.getReadMethod(base.getClass(), property);
            return (T)method.invoke(base, new Object[0]);
        }
        catch (Exception e) {
            if (base == null) {
                throw new RuntimeException("Unable to get '" + property + "' because base is null", e);
            }
            throw new RuntimeException("Unable to get '" + property + "' of '" + base + "' (" + base.getClass() + ")", e);
        }
    }

    public static void setProperty(Object base, String property, Object value) {
        try {
            Class<?> baseClass = base.getClass();
            Method method = ClassUtils.getReadMethod(baseClass, property);
            method = ClassUtils.getWriteMethod(baseClass, property, method.getReturnType());
            method.invoke(base, value);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to set '" + property + "' of '" + base + "' to '" + value + "'", e);
        }
    }

    public static boolean isPrimitiveWrapper(Class<?> clazz) {
        if (Number.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Boolean.class.isAssignableFrom(clazz)) {
            return true;
        }
        return Character.class.isAssignableFrom(clazz);
    }

    public static Class<?> getWrapperClass(Class<?> clazz) {
        if (clazz.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (clazz.equals(Short.TYPE)) {
            return Short.class;
        }
        if (clazz.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (clazz.equals(Long.TYPE)) {
            return Long.class;
        }
        if (clazz.equals(Float.TYPE)) {
            return Float.class;
        }
        if (clazz.equals(Double.TYPE)) {
            return Double.class;
        }
        if (clazz.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (clazz.equals(Character.TYPE)) {
            return Character.class;
        }
        throw new RuntimeException(clazz + " is not a primitive type");
    }

    public static boolean classExists(String clazz) {
        try {
            Class.forName(clazz, false, null);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerAlienClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            return;
        }
        if (classLoader.equals(Thread.currentThread().getContextClassLoader())) {
            return;
        }
        if (classLoader.equals(ClassUtils.class.getClassLoader())) {
            return;
        }
        Set<ClassLoader> set = ALIEN_CLASSLOADERS;
        synchronized (set) {
            ALIEN_CLASSLOADERS.add(classLoader);
        }
    }

    public static Class<?> niceForName(String className) {
        return ClassUtils.niceForName(className, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> niceForName(String className, ClassLoader classLoader) {
        try {
            if (classLoader != null) {
                return Class.forName(className, false, classLoader);
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (threadClassLoader != null && !threadClassLoader.equals(classLoader)) {
                return Class.forName(className, false, threadClassLoader);
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        ClassLoader thisClassLoader = ClassUtils.class.getClassLoader();
        try {
            if (!thisClassLoader.equals(threadClassLoader) && !thisClassLoader.equals(classLoader)) {
                return Class.forName(className, false, thisClassLoader);
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        Set<ClassLoader> set = ALIEN_CLASSLOADERS;
        synchronized (set) {
            for (ClassLoader alienClassLoader : ALIEN_CLASSLOADERS) {
                try {
                    return Class.forName(className, false, alienClassLoader);
                }
                catch (ClassNotFoundException e) {
                }
            }
        }
        return ClassUtils.getPrimitive(className);
    }

    public static boolean isPrimitive(String className) {
        return ClassUtils.getPrimitive(className) != null;
    }

    public static String getSimpleName(String qualifiedClassName) {
        return StringUtils.substringAfterLast(qualifiedClassName, '.');
    }

    public static Class<?> getOriginalDeclaringClass(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        for (Class<?> superclass = declaringClass.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            try {
                superclass.getDeclaredMethod(method.getName(), method.getParameterTypes());
                declaringClass = superclass;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return declaringClass;
    }

    public static String getPackagesAsFolderNames(Class<?> clazz) {
        return clazz.getPackage().getName().replace('.', '/');
    }

    public static <T extends Annotation> T getOriginalAnnotation(Method method, Class<T> annotationClass) {
        T annotation;
        Method methodToUse = method;
        String name = methodToUse.getName();
        Class<?>[] parameterTypes = methodToUse.getParameterTypes();
        while (methodToUse.getAnnotations().length == 0) {
            Class<?> superclass = methodToUse.getDeclaringClass().getSuperclass();
            methodToUse = null;
            while (superclass != null) {
                try {
                    methodToUse = superclass.getDeclaredMethod(name, parameterTypes);
                    break;
                }
                catch (Exception e) {
                    superclass = superclass.getSuperclass();
                }
            }
            if (methodToUse != null) continue;
            break;
        }
        if (methodToUse != null && (annotation = methodToUse.getAnnotation(annotationClass)) != null) {
            return annotation;
        }
        for (Class<?> iface : method.getDeclaringClass().getInterfaces()) {
            try {
                methodToUse = iface.getDeclaredMethod(name, parameterTypes);
                T annotation2 = methodToUse.getAnnotation(annotationClass);
                if (annotation2 == null) continue;
                return annotation2;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    public static Type getOriginalGenericReturnType(Method method) {
        Method methodToUse = method;
        String name = methodToUse.getName();
        Class<?>[] parameterTypes = methodToUse.getParameterTypes();
        block2: do {
            Type type;
            if ((type = methodToUse.getGenericReturnType()) instanceof ParameterizedType) {
                return type;
            }
            Class<?> superclass = methodToUse.getDeclaringClass().getSuperclass();
            methodToUse = null;
            while (superclass != null) {
                try {
                    methodToUse = superclass.getDeclaredMethod(name, parameterTypes);
                    continue block2;
                }
                catch (Exception e) {
                    superclass = superclass.getSuperclass();
                }
            }
        } while (methodToUse != null);
        return method.getGenericReturnType();
    }

    public static Type[] getOriginalGenericParameterTypes(Method method) {
        Method methodToUse = method;
        String name = methodToUse.getName();
        Class<?>[] parameterTypes = methodToUse.getParameterTypes();
        block2: do {
            Type[] type;
            if ((type = methodToUse.getGenericParameterTypes())[0] instanceof ParameterizedType) {
                return type;
            }
            Class<?> superclass = methodToUse.getDeclaringClass().getSuperclass();
            methodToUse = null;
            while (superclass != null) {
                try {
                    methodToUse = superclass.getDeclaredMethod(name, parameterTypes);
                    continue block2;
                }
                catch (Exception e) {
                    superclass = superclass.getSuperclass();
                }
            }
        } while (methodToUse != null);
        return method.getGenericParameterTypes();
    }

    public static String getGenericTypeAsString(Type type) {
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        Type[] typeActuals = null;
        try {
            typeActuals = ((ParameterizedType)type).getActualTypeArguments();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (typeActuals == null || typeActuals.length == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (Type typeActual : typeActuals) {
            if (typeActual == null) continue;
            if (builder.length() > 0) {
                builder.append(StringUtils.SEPARATOR_COMMA);
            }
            if (typeActual instanceof Class) {
                builder.append(((Class)typeActual).getName());
                continue;
            }
            builder.append(typeActual.toString());
        }
        return builder.toString();
    }

    private static Class<?> getPrimitive(String className) {
        if ("byte".equals(className)) {
            return Byte.TYPE;
        }
        if ("short".equals(className)) {
            return Short.TYPE;
        }
        if ("int".equals(className)) {
            return Integer.TYPE;
        }
        if ("long".equals(className)) {
            return Long.TYPE;
        }
        if ("float".equals(className)) {
            return Float.TYPE;
        }
        if ("double".equals(className)) {
            return Double.TYPE;
        }
        if ("boolean".equals(className)) {
            return Boolean.TYPE;
        }
        if ("char".equals(className)) {
            return Character.TYPE;
        }
        return null;
    }

    private ClassUtils() {
    }
}

