/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.layout.decorator;

import java.util.Map;
import org.metawidget.layout.decorator.LayoutDecorator;
import org.metawidget.layout.decorator.LayoutDecoratorConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NestedSectionLayoutDecorator<W, C extends W, M extends C>
extends LayoutDecorator<W, C, M> {
    protected NestedSectionLayoutDecorator(LayoutDecoratorConfig<W, C, M> config) {
        super(config);
    }

    @Override
    public void startContainerLayout(C container, M metawidget) {
        super.startContainerLayout(container, metawidget);
        State<C> state = this.getState(container, metawidget);
        state.currentSection = null;
        state.currentSectionWidget = null;
    }

    @Override
    public void layoutWidget(W widget, String elementName, Map<String, String> attributes, C container, M metawidget) {
        String section = this.stripSection(attributes);
        State<C> state = this.getState(container, metawidget);
        if (this.isIgnored(widget) || section == null || section.equals(state.currentSection)) {
            if (state.currentSectionWidget == null) {
                super.layoutWidget(widget, elementName, attributes, container, metawidget);
            } else {
                super.layoutWidget(widget, elementName, attributes, state.currentSectionWidget, metawidget);
            }
            return;
        }
        Object previousSectionWidget = state.currentSectionWidget;
        if (state.currentSectionWidget != null) {
            super.endContainerLayout(state.currentSectionWidget, metawidget);
        }
        state.currentSection = section;
        state.currentSectionWidget = null;
        if ("".equals(section)) {
            super.layoutWidget(widget, elementName, attributes, container, metawidget);
            return;
        }
        state.currentSectionWidget = this.createSectionWidget(previousSectionWidget, attributes, container, metawidget);
        super.startContainerLayout(state.currentSectionWidget, metawidget);
        super.layoutWidget(widget, elementName, attributes, state.currentSectionWidget, metawidget);
    }

    @Override
    public void endContainerLayout(C container, M metawidget) {
        State<C> state = this.getState(container, metawidget);
        if (state.currentSectionWidget != null) {
            super.endContainerLayout(state.currentSectionWidget, metawidget);
        }
        super.endContainerLayout(container, metawidget);
        state.currentSection = null;
        state.currentSectionWidget = null;
    }

    protected abstract String stripSection(Map<String, String> var1);

    protected abstract State<C> getState(C var1, M var2);

    protected abstract boolean isIgnored(W var1);

    protected abstract C createSectionWidget(C var1, Map<String, String> var2, C var3, M var4);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class State<C> {
        public String currentSection;
        public C currentSectionWidget;
    }
}

