/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.android.widget.widgetbuilder;

import android.text.SpannableStringBuilder;
import android.view.View;
import android.widget.TextView;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.metawidget.android.widget.AndroidMetawidget;
import org.metawidget.android.widget.AndroidValueAccessor;
import org.metawidget.android.widget.Stub;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.util.simple.StringUtils;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyWidgetBuilder
implements WidgetBuilder<View, AndroidMetawidget>,
AndroidValueAccessor {
    @Override
    public Object getValue(View view) {
        if (TextView.class.equals(view.getClass())) {
            CharSequence text = ((TextView)view).getText();
            if (text instanceof SpannableStringBuilder) {
                text = ((Object)text).toString();
            }
            return text;
        }
        return null;
    }

    @Override
    public boolean setValue(Object value, View view) {
        if (TextView.class.equals(view.getClass())) {
            ((TextView)view).setText((CharSequence)StringUtils.quietValueOf(value));
            return true;
        }
        return false;
    }

    @Override
    public View buildWidget(String elementName, Map<String, String> attributes, AndroidMetawidget metawidget) {
        if (!WidgetBuilderUtils.isReadOnly(attributes)) {
            return null;
        }
        if ("true".equals(attributes.get("hidden"))) {
            return new Stub(metawidget.getContext());
        }
        if ("action".equals(elementName)) {
            return new Stub(metawidget.getContext());
        }
        if ("true".equals(attributes.get("masked"))) {
            TextView view = new TextView(metawidget.getContext());
            view.setVisibility(4);
            return view;
        }
        String lookup = attributes.get("lookup");
        if (lookup != null && !"".equals(lookup)) {
            return new TextView(metawidget.getContext());
        }
        Class<?> clazz = WidgetBuilderUtils.getActualClassOrType(attributes, String.class);
        if (clazz != null) {
            if (clazz.isPrimitive()) {
                return new TextView(metawidget.getContext());
            }
            if (String.class.equals(clazz)) {
                return new TextView(metawidget.getContext());
            }
            if (Character.class.equals(clazz)) {
                return new TextView(metawidget.getContext());
            }
            if (Date.class.equals(clazz)) {
                return new TextView(metawidget.getContext());
            }
            if (Boolean.class.equals(clazz)) {
                return new TextView(metawidget.getContext());
            }
            if (Number.class.isAssignableFrom(clazz)) {
                return new TextView(metawidget.getContext());
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return new Stub(metawidget.getContext());
            }
        }
        if ("true".equals(attributes.get("dont-expand"))) {
            return new TextView(metawidget.getContext());
        }
        return null;
    }
}

