/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.faces.component.html.layout;

import java.util.HashMap;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.html.HtmlPanelGroup;
import javax.faces.context.FacesContext;
import org.metawidget.faces.component.UIMetawidget;
import org.metawidget.faces.component.html.layout.PanelGroupLayoutDecoratorConfig;
import org.metawidget.faces.component.layout.UIComponentNestedSectionLayoutDecorator;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.simple.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PanelGroupLayoutDecorator
extends UIComponentNestedSectionLayoutDecorator {
    private String mStyle;
    private String mStyleClass;
    private String mPanelLayout;

    public PanelGroupLayoutDecorator(PanelGroupLayoutDecoratorConfig config) {
        super(config);
        this.mStyle = config.getStyle();
        this.mStyleClass = config.getStyleClass();
        this.mPanelLayout = config.getPanelLayout();
    }

    @Override
    protected UIComponent createNewSectionWidget(UIComponent previousSectionWidget, Map<String, String> attributes, UIComponent container, UIMetawidget metawidget) {
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        UIViewRoot viewRoot = context.getViewRoot();
        HtmlPanelGroup panel = (HtmlPanelGroup)application.createComponent("javax.faces.HtmlPanelGroup");
        panel.setId(viewRoot.createUniqueId());
        panel.setStyle(this.mStyle);
        panel.setLayout(this.mPanelLayout);
        String sectionStyleClass = StringUtils.camelCase(this.getState((UIComponent)container, (UIMetawidget)metawidget).currentSection);
        if (this.mStyleClass == null) {
            panel.setStyleClass(sectionStyleClass);
        } else {
            panel.setStyleClass(this.mStyleClass + ' ' + sectionStyleClass);
        }
        HashMap<String, String> panelAttributes = CollectionUtils.newHashMap();
        panelAttributes.put("label", "");
        panel.getAttributes().put("metawidget-metadata", panelAttributes);
        this.getDelegate().layoutWidget(panel, "property", panelAttributes, container, metawidget);
        UIMetawidget nestedMetawidget = (UIMetawidget)application.createComponent(metawidget.getComponentType());
        nestedMetawidget.setRendererType(metawidget.getRendererType());
        nestedMetawidget.setId(viewRoot.createUniqueId());
        nestedMetawidget.setLayout(metawidget.getLayout());
        nestedMetawidget.copyParameters(metawidget);
        panel.getChildren().add(nestedMetawidget);
        return nestedMetawidget;
    }
}

